/*
 * Decompiled with CFR 0.152.
 */
package phic.common;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.Vector;
import phic.Current;
import phic.Resource;

public class Table {
    public Vector rows = new Vector();
    double[][] dbls;
    public int nRows;
    public int nCols;

    public Table(String tablefile, int width) {
        try {
            BufferedReader r = new BufferedReader(new InputStreamReader(Resource.loader.getResource(tablefile)));
            StreamTokenizer st = new StreamTokenizer(r);
            st.wordChars(36, 36);
            st.wordChars(95, 95);
            boolean eof = false;
            while (!eof) {
                String[] str = new String[width];
                int i = 0;
                while (i < width) {
                    switch (st.nextToken()) {
                        case -1: {
                            eof = true;
                            break;
                        }
                        case -3: 
                        case 34: {
                            str[i] = st.sval;
                            break;
                        }
                        case -2: {
                            double d = st.nval;
                            int p = 0;
                            if (st.nextToken() == -3 && st.sval.startsWith("E")) {
                                String ex = st.sval.substring(1);
                                boolean num = true;
                                try {
                                    p = Integer.parseInt(ex);
                                }
                                catch (NumberFormatException e) {
                                    num = false;
                                }
                                if (num) {
                                    st.nextToken();
                                }
                            }
                            str[i] = Double.toString(d * Math.pow(10.0, p));
                            st.pushBack();
                        }
                    }
                    if (eof) break;
                    ++i;
                }
                if (eof) continue;
                this.rows.add(str);
            }
        }
        catch (Exception e) {
            System.out.println("Failed to initialise table " + tablefile + ", due to:");
            e.printStackTrace();
        }
        this.nCols = width;
        this.nRows = this.rows.size();
        this.dbls = new double[this.nRows][this.nCols];
        int i = 0;
        while (i < this.nRows) {
            int j = 0;
            while (j < this.nCols) {
                if (((String[])this.rows.get(i))[j] == null) {
                    throw new IllegalStateException("line " + i + " of table " + tablefile + " failed: " + this.rows.get(i));
                }
                try {
                    this.dbls[i][j] = Double.parseDouble(((String[])this.rows.get(i))[j]);
                }
                catch (NumberFormatException e) {
                    this.dbls[i][j] = Double.NaN;
                }
                ++j;
            }
            ++i;
        }
    }

    public double getDouble(int row, int col) {
        return this.dbls[row][col];
    }

    public String getString(int row, int col) {
        return this.line(row)[col];
    }

    public String[] line(int num) {
        return (String[])this.rows.elementAt(num);
    }

    public int findRowFromColumn(int col, String txt) {
        int i = 0;
        while (i < this.nRows) {
            if (this.line(i)[col].equals(txt)) {
                return i;
            }
            ++i;
        }
        Current.body.error(String.valueOf(txt) + " not found in table");
        return -1;
    }

    public String[] getColumn(int j) {
        String[] s = new String[this.nRows];
        int i = 0;
        while (i < this.nRows) {
            s[i] = this.getString(i, j);
            ++i;
        }
        return s;
    }
}

