/*
 * Decompiled with CFR 0.152.
 */
package phic.common;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import phic.common.Container;
import phic.common.VDouble;
import phic.common.Variable;

public class Quantity
extends VDouble
implements Cloneable {
    Container parent;
    public Variable Q = new VDouble(){
        {
            this.unit = 22;
        }

        public double get() {
            return Quantity.this.get() * Quantity.this.parent.volume.get();
        }

        public void set(double quantity) {
            Quantity.this.set(quantity / Quantity.this.parent.volume.get());
        }
    };
    static final NumberFormat numformat = new DecimalFormat("0.##E0");

    public Quantity(Container parent) {
        this.unit = 14;
        this.parent = parent;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void setC(double cc) {
        this.set(cc);
    }

    public void setQ(double qq) {
        if (qq == 0.0) {
            this.set(0.0);
        } else {
            this.set(qq / this.parent.volume.get());
        }
    }

    public double getC() {
        return this.get();
    }

    public double getQ() {
        return this.get() * this.parent.vol;
    }

    public double C() {
        return this.getC();
    }

    public double Q() {
        return this.getQ();
    }

    public void addQ(double qq) {
        if (this.parent.volume.get() == 0.0) {
            return;
        }
        this.set(Math.max(this.getQ() + qq, 0.0) / this.parent.volume.get());
    }

    public final void addC(double cc) {
        super.add(cc);
    }

    public final void multiplyC(double factor) {
        this.set(this.get() * factor);
    }

    public final void moveTo(Quantity to) {
        to.addQ(this.getQ());
        this.setQ(0.0);
    }

    public final void moveTo(Quantity to, double quantity) {
        quantity = Math.max(Math.min(quantity, this.getQ()), -to.getQ());
        to.addQ(quantity);
        this.addQ(-quantity);
    }

    public final void equilibrateConcentration(Quantity to, double fraction) {
        double equilConc = (to.getQ() + this.getQ()) / (this.parent.vol + to.parent.vol);
        double lostQ = (this.getC() - equilConc) * this.parent.vol;
        this.moveTo(to, lostQ * fraction);
    }

    public String toString() {
        return numformat.format(this.get());
    }

    public static String toString(double d) {
        return numformat.format(d);
    }

    public static double getNearestRoundAbove(double d) {
        double p = Math.log(d) / Math.log(10.0);
        p = Math.floor(p);
        return Math.pow(10.0, p + 1.0);
    }

    static final double sgn(double x) {
        return x > 0.0 ? 1 : (x < 0.0 ? -1 : 0);
    }

    public static double getNearestRoundBelow(double d) {
        int p = (int)(Math.log(d) / Math.log(10.0));
        return Math.pow(10.0, p);
    }
}

