/*
 * Decompiled with CFR 0.152.
 */
package phic.common;

import java.util.List;
import java.util.Random;
import java.util.Vector;
import phic.Body;
import phic.Current;
import phic.Environment;
import phic.common.Clock;
import phic.common.CommonThread;
import phic.common.CriticalPeriod;
import phic.common.HasContent;
import phic.modifiable.Eqn;

public abstract class Organ
implements Runnable,
HasContent {
    private static Vector list = new Vector();
    public static DataLock cycleLock = new DataLock();
    public static CriticalPeriod criticalPeriod = CriticalPeriod.newCriticalPeriod();
    public transient List eqnList = new Vector();
    String name;
    public boolean active = true;
    public boolean verbose = false;
    public Body body;
    public Environment environment;
    boolean kill = false;
    public CommonThread getCommonThread = Current.thread;
    protected double elapsedTime = 60.0;
    public static boolean useRandomSeed = false;
    public static long randomSeed = System.currentTimeMillis();
    protected static Random rand = new Random(randomSeed);

    public static void setList(Vector v) {
        list = v;
        Clock clock = Current.body.getClock();
        clock.clearThreads();
    }

    public static Vector getList() {
        return list;
    }

    public static void setBody(Body b) {
        int i = 0;
        while (i < list.size()) {
            Organ org = (Organ)list.get(i);
            org.body = b;
            int j = 0;
            while (j < org.eqnList.size()) {
                b.addEqn((Eqn)org.eqnList.get(j));
                ++j;
            }
            ++i;
        }
    }

    public void addEqn(String lhs, String rhs) {
        Eqn eq = new Eqn(lhs, rhs);
        eq.setOrgan(this);
        this.eqnList.add(eq);
    }

    public void addEqn(String lhs, String rhs, String descr) {
        Eqn eq = new Eqn(lhs, rhs, descr);
        eq.setOrgan(this);
        this.eqnList.add(eq);
    }

    public Organ() {
        this.name = this.getClass().getName();
        this.name = this.name.substring(this.name.lastIndexOf(46) + 1);
        this.body = Current.body;
        this.environment = Current.environment;
        list.add(this);
    }

    public final void inform(String message) {
        if (this.verbose) {
            this.body.message(String.valueOf('[') + this.name + "] " + message);
        }
    }

    public void run() {
        while (!this.kill) {
            if (this.active && Current.body.clock.running) {
                this.tickOrgan();
                continue;
            }
            Thread.yield();
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void tickOrgan() {
        Clock clock = Current.body.clock;
        clock.latch();
        this.elapsedTime = clock.elapsedTime() / 1000.0;
        this.tick();
    }

    public abstract void tick();

    public void reset() {
        this.body = Current.body;
        this.environment = Current.environment;
    }

    static final double lowpass(double target, double oldvalue, double rate) {
        return target * rate + oldvalue * (1.0 - rate);
    }

    static final double limit(double value, double minimum, double maximum) {
        return Math.min(Math.max(value, minimum), maximum);
    }

    protected final void waitSeconds(double seconds) {
    }

    protected final void waitMinutes(double minutes) {
    }

    protected final double fractionDecayPerMinute(double fraction) {
        return 1.0 - Math.pow(1.0 - fraction, this.elapsedTime / 60.0);
    }

    public static final double fractionDecayPerMinute(double fraction, double seconds) {
        return 1.0 - Math.pow(1.0 - fraction, seconds / 60.0);
    }

    public static final boolean randomEventOccurs(double probabilityPerMinute, double elapsedSeconds) {
        return rand.nextDouble() < Organ.fractionDecayPerMinute(probabilityPerMinute, elapsedSeconds);
    }

    public final boolean randomEventOccurs(double probabilityPerMinute) {
        return Organ.randomEventOccurs(probabilityPerMinute, this.elapsedTime);
    }

    protected final double fractionPerMinute(double fraction) {
        return Math.pow(fraction, this.elapsedTime / 60.0);
    }

    protected static final double random() {
        return rand.nextDouble();
    }

    public static void resetRandom() {
        if (!useRandomSeed) {
            randomSeed = System.currentTimeMillis();
        }
        rand.setSeed(randomSeed);
    }

    public static class DataLock {
        protected int dirt;
        protected static int sn = 0;

        public int createID() {
            if (sn > 32) {
                throw new RuntimeException("Too many targets have registered with this data broker.");
            }
            return sn++;
        }

        public synchronized void dirty(boolean b) {
            this.dirt = b ? -1 : 0;
        }

        public synchronized boolean isDirty(int s) {
            return (this.dirt & 1 << sn) > 0;
        }

        public synchronized void clean(int s) {
            this.dirt &= ~(1 << sn);
        }
    }
}

