/*
 * Decompiled with CFR 0.152.
 */
package phic.common;

import java.io.Serializable;
import phic.Body;
import phic.gui.Variables;
import phic.gui.VisibleVariable;

public class LifeSupport
implements Serializable {
    protected boolean[] isFudged;
    protected double[] fudgeValue;
    Body body;

    public void setBody(Body body) {
        this.body = body;
        this.isFudged = new boolean[Variables.variable.length];
        this.fudgeValue = new double[Variables.variable.length];
        int i = 0;
        while (i < this.fudgeValue.length) {
            this.fudgeValue[i] = Double.NaN;
            ++i;
        }
    }

    public void tick() {
        int i = 0;
        while (i < this.isFudged.length) {
            if (this.isFudged[i]) {
                if (Double.isNaN(this.fudgeValue[i])) {
                    Variables.variable[i].initialise();
                } else {
                    Variables.variable[i].node.doubleSetVal(this.fudgeValue[i]);
                }
            }
            ++i;
        }
    }

    public void setFudgeVariable(VisibleVariable variable, boolean fudge) {
        int i = 0;
        while (i < this.isFudged.length) {
            if (Variables.variable[i] == variable) {
                this.isFudged[i] = fudge;
            }
            ++i;
        }
    }

    public boolean isFudgeVariable(VisibleVariable v) {
        int i = 0;
        while (i < this.isFudged.length) {
            if (Variables.variable[i] == v) {
                return this.isFudged[i];
            }
            ++i;
        }
        throw new IllegalArgumentException("No such variable, " + v.toString());
    }

    public void setFudgeVariable(int i, boolean fudge) {
        this.isFudged[i] = fudge;
    }

    public boolean isFudgeVariable(int i) {
        return this.isFudged[i];
    }

    public void setFudgeValue(VisibleVariable v, double value) {
        int i = 0;
        while (i < Variables.variable.length) {
            if (v == Variables.variable[i]) {
                this.fudgeValue[i] = value;
            }
            ++i;
        }
    }

    public double getFudgeValue(VisibleVariable v) {
        int i = 0;
        while (i < Variables.variable.length) {
            if (v == Variables.variable[i]) {
                if (Double.isNaN(this.fudgeValue[i])) {
                    return Variables.variable[i].node.getVDouble().initialValue;
                }
                return this.fudgeValue[i];
            }
            ++i;
        }
        return Double.NaN;
    }

    public void reset() {
        this.setBody(this.body);
    }
}

