/*
 * Decompiled with CFR 0.152.
 */
package phic.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.swing.JOptionPane;
import phic.Resource;

public class IniReader {
    private String[] line = new String[0];
    private String[] headers = new String[0];
    private String filename = "Unknown";
    boolean doneHeaders = false;

    public IniReader(String filename) {
        this.filename = filename;
        try {
            this.initialise(Resource.loader.getResource(filename));
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Unable to read file " + filename);
        }
    }

    public IniReader(InputStream is) throws IOException {
        try {
            this.initialise(is);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Unable to read this resource: " + is);
        }
    }

    protected void initialise(InputStream is) throws IOException {
        String s;
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        Vector<String> v = new Vector<String>();
        do {
            s = br.readLine();
            v.add(s);
        } while (s != null);
        v.remove(v.size() - 1);
        this.line = v.toArray(this.line);
    }

    public String[] getSectionHeaders() {
        if (this.doneHeaders) {
            return this.headers;
        }
        Vector<String> v = new Vector<String>();
        int i = 0;
        while (i < this.line.length) {
            String s = this.line[i];
            if (s.startsWith("[") && s.endsWith("]")) {
                v.add(s.substring(1, s.length() - 1));
            }
            ++i;
        }
        this.headers = v.toArray(this.headers);
        return this.headers;
    }

    public String[] getSectionStrings(String sectionHeader) {
        String s;
        int i = 0;
        Vector<String> v = new Vector<String>();
        while (!(s = this.line[i++]).equals(String.valueOf('[') + sectionHeader + ']') && i < this.line.length) {
        }
        if (i >= this.line.length) {
            return new String[0];
        }
        --i;
        while (i < this.line.length) {
            if (++i >= this.line.length || (s = this.line[i]).startsWith("[")) break;
            if (s.length() <= 0 || s.startsWith("//")) continue;
            v.add(s);
        }
        String[] ss = new String[v.size()];
        return v.toArray(ss);
    }

    public Map getSectionMap(String sectionHeader) {
        String s;
        int i = 0;
        try {
            while (!(s = this.line[i++]).equals(String.valueOf('[') + sectionHeader + ']')) {
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.errorCannotFind(sectionHeader);
        }
        if (i >= this.line.length) {
            return new Hashtable();
        }
        Hashtable<String, Object> h = new Hashtable<String, Object>();
        --i;
        while (i < this.line.length) {
            String right;
            String left;
            if (++i >= this.line.length || (s = this.line[i]).startsWith("[")) break;
            if (s.startsWith("//")) continue;
            int p = s.indexOf(61);
            if (p > 0) {
                left = s.substring(0, p).trim();
                right = s.substring(p + 1).trim();
                if (left.equals("")) {
                    continue;
                }
            } else {
                left = s.trim();
                if (left.equals("")) continue;
                right = "";
            }
            try {
                double d = Double.parseDouble(right);
                h.put(left, new Double(d));
            }
            catch (NumberFormatException e) {
                if (right.equalsIgnoreCase("true") || right.equalsIgnoreCase("yes")) {
                    h.put(left, Boolean.TRUE);
                    continue;
                }
                if (right.equalsIgnoreCase("false") || right.equalsIgnoreCase("no")) {
                    h.put(left, Boolean.FALSE);
                    continue;
                }
                h.put(left, right);
            }
        }
        return h;
    }

    public String[][] getSectionPairs(String sectionHeader) {
        String s;
        int i = 0;
        while (!(s = this.line[i++]).equals(String.valueOf('[') + sectionHeader + ']') && i < this.line.length) {
        }
        if (i >= this.line.length) {
            throw new IllegalArgumentException("Section '" + sectionHeader + "' not found in file '" + this.filename + "'.");
        }
        Vector<String[]> v = new Vector<String[]>();
        --i;
        while (i < this.line.length) {
            String right;
            String left;
            if (++i >= this.line.length || (s = this.line[i]).startsWith("[")) break;
            if (s.startsWith("//")) continue;
            int p = s.indexOf(61);
            if (p > 0) {
                left = s.substring(0, p).trim();
                right = s.substring(p + 1).trim();
                if (left.equals("")) {
                    continue;
                }
            } else {
                left = s.trim();
                if (left.equals("")) continue;
                right = "";
            }
            v.add(new String[]{left, right});
        }
        String[][] strings = new String[2][v.size()];
        return (String[][])v.toArray((T[])strings);
    }

    public static String[][] getPairsFromStrings(String[] in) {
        Vector<String[]> out = new Vector<String[]>();
        int i = 0;
        while (i < in.length) {
            block5: {
                String right;
                String left;
                block4: {
                    block3: {
                        int p = in[i].indexOf(61);
                        if (p <= 0) break block3;
                        left = in[i].substring(0, p).trim();
                        right = in[i].substring(p + 1).trim();
                        if (!left.equals("")) break block4;
                        break block5;
                    }
                    left = in[i].trim();
                    if (left.equals("")) break block5;
                    right = "";
                }
                out.add(new String[]{left, right});
            }
            ++i;
        }
        String[][] strings = new String[2][out.size()];
        return (String[][])out.toArray((T[])strings);
    }

    void errorCannotFind(String object) {
        throw new IllegalArgumentException("Item not found in file " + this.filename + ": '" + object + "'");
    }

    public String getFilename() {
        return this.filename;
    }
}

