/*
 * Decompiled with CFR 0.152.
 */
package phic.common;

import phic.Blood;
import phic.common.Gas;
import phic.common.VDouble;

public class GasConcentration
extends Gas {
    private Blood blood;
    public VDouble PO2 = new VDouble(){

        public double get() {
            return GasConcentration.this.PO2();
        }

        public void set(double value) {
            GasConcentration.this.O2.set(GasConcentration.this.cO2(value, GasConcentration.this.PCO2.get()));
        }
    };
    public VDouble PCO2 = new VDouble(){

        public double get() {
            return GasConcentration.this.PCO2();
        }

        public void set(double value) {
            GasConcentration.this.CO2.set(GasConcentration.cCO2(GasConcentration.this.PO2.get(), value));
        }
    };
    protected static final double HB_O2_CAPACITY = 0.00139;
    protected final long A = 53831L;

    public GasConcentration(Blood blood) {
        this.blood = blood;
    }

    private double getO2Capacity() {
        if (this.blood == null) {
            return Double.NaN;
        }
        return GasConcentration.getO2Capacity(this.blood);
    }

    private final double PO2() {
        double satO2 = 100.0 * this.getSatO2();
        double c = this.CO2.get() * 1000.0;
        return (904.0 - c) / 904.0 * Math.pow(10.0, (c - 119.0) / 300.0 + satO2 / 135.6 + 1.0 / (101.8 - satO2) + 0.13) / 1000.0;
    }

    private final double PCO2() {
        double satO2 = 100.0 * this.getSatO2();
        double c = this.CO2.get() * 1000.0;
        return ((1804.0 + 5.98 * satO2) * (Math.pow(1.55990210055191E14 + c * c * c, 0.3333333333333333) - 53831.0) + 5.86) / 1000.0;
    }

    public static double getO2Capacity(Blood blood) {
        return blood.Hb.get() * 0.00139;
    }

    private static final double cO2(double ppO2, double ppCO2, Blood blood) {
        double satO2 = 1.0 - Math.pow(2992.0 / (Math.pow(ppO2, 2.23) * Math.pow(40.0 / ppCO2, 2.29) + 2992.0), 1.69);
        return satO2 * GasConcentration.getO2Capacity(blood);
    }

    private double cO2(double ppO2, double ppCO2) {
        return GasConcentration.cO2(ppO2, ppCO2, this.blood);
    }

    private static final double cCO2(double ppO2, double ppCO2) {
        return (1.0 - 9.78E-4 * ppO2) * (4.4 * ppCO2 + 384.3 * (1.0 - 3.82 / ppCO2));
    }

    public double estimateConcO2(double ppO2, double ppCO2) {
        return this.cO2(ppO2 *= 1000.0, ppCO2 *= 1000.0) / 1000.0;
    }

    public static double estimateConcO2(double ppO2, double ppCO2, Blood blood) {
        return GasConcentration.cO2(ppO2 * 1000.0, ppCO2 * 1000.0, blood);
    }

    public static double estimateO2ConcChange(double ppO2from, double ppO2to, double ppCO2, Blood blood) {
        return GasConcentration.estimateConcO2(ppO2from, ppCO2, blood) - GasConcentration.estimateConcO2(ppO2to, ppCO2, blood);
    }

    public double estimateConcCO2(double ppO2, double ppCO2) {
        return GasConcentration.cCO2(ppO2 *= 1000.0, ppCO2 *= 1000.0) / 1000.0;
    }

    public double getSatO2() {
        return this.O2.get() / this.getO2Capacity();
    }

    public void setBlood(Blood blood) {
        this.blood = blood;
    }

    public Blood getBlood() {
        return this.blood;
    }
}

