/*
 * Decompiled with CFR 0.152.
 */
package phic.common;

import phic.Blood;
import phic.common.Curve;
import phic.common.Gas;
import phic.common.TwoVarTable;
import phic.common.VDouble;
import phic.common.VDoubleReadOnly;

public class GasConc
extends Gas {
    public static TwoVarTable pO2Table = new TwoVarTable("pO2Table.txt", 14);
    public static TwoVarTable pCO2Table = new TwoVarTable("pCO2Table.txt", 13);
    Blood blood = null;
    public VDoubleReadOnly PO2 = new VDoubleReadOnly(){

        public double get() {
            return GasConc.this.PO2();
        }
    };
    public VDoubleReadOnly PCO2 = new VDoubleReadOnly(){

        public double get() {
            return GasConc.this.PCO2();
        }
    };
    protected Gas pp = new Gas();
    public VDouble SatO2 = new VDouble(){

        public double get() {
            double o = GasConc.this.O2.get() * 1000.0;
            if (GasConc.this.blood != null) {
                o *= 0.45 / GasConc.this.blood.Hct.get();
            }
            return Math.min(1.0, o / 203.0);
        }

        public void set(double d) {
            GasConc.this.O2.set(203.0 * d * GasConc.this.blood.Hct.get() / 0.45 / 1000.0);
        }
    };
    public Curve O2Dissociation = new DissocCurve();

    public GasConc(Blood blood) {
        this.blood = blood;
        this.pp.O2 = this.PO2;
        this.pp.CO2 = this.PCO2;
    }

    public Gas getPartials() {
        return this.pp;
    }

    private double PO2() {
        double o = this.O2.get() * 1000.0;
        double c = this.CO2.get() * 1000.0;
        if (this.blood != null) {
            o *= 0.45 / (this.blood.Hct.get() - this.blood.CO.get());
        }
        return pO2Table.lookUp(o, 484.0) / 10000.0;
    }

    private double PCO2() {
        double o = this.O2.get() * 1000.0;
        double c = this.CO2.get() * 1000.0;
        if (this.blood != null) {
            o *= 0.45 / this.blood.Hct.get();
        }
        return pCO2Table.lookUp(o, c) / 10000.0;
    }

    public void setBlood(Blood blood) {
        this.blood = blood;
    }

    public class DissocCurve
    extends Curve {
        public double getValue(double x) {
            x *= 1000.0;
            double c = GasConc.this.CO2.get() * 1000.0;
            if (GasConc.this.blood != null) {
                x *= 0.45 / GasConc.this.blood.Hct.get();
            }
            return pO2Table.lookUp(x, c) / 10000.0;
        }

        public double getInverse(double y) {
            throw new IllegalStateException("o2 dissoc: noninvertible function");
        }
    }
}

