/*
 * Decompiled with CFR 0.152.
 */
package phic.common;

import phic.common.Container;
import phic.common.Quantity;
import phic.drug.DrugContainer;

public class FoodContainer
extends DrugContainer {
    public static final double MOLES_GLUCOSE_PER_GRAM_CARB = 0.005555555555555556;
    public Quantity carbohydrate = new Quantity(this);

    public FoodContainer() {
        this.qs.add(this.carbohydrate);
        this.carbohydrate.setUnit(21);
    }

    public FoodContainer(Container source) {
        this();
        this.add(source);
    }

    public void digestFraction(double f) {
        double cglu = f * this.carbohydrate.getQ() * 0.005555555555555556;
        this.carbohydrate.multiplyBy(1.0 - f);
        this.glucose.addC(cglu);
    }

    public Container withdrawVol(double volume) {
        FoodContainer f = new FoodContainer();
        this.withdrawVol_overwrite(volume, f);
        return f;
    }

    protected double getOsmolarity() {
        return super.getOsmolarity() + this.carbohydrate.getC() * 0.8 / 180.0;
    }
}

