/*
 * Decompiled with CFR 0.152.
 */
package phic.common;

import java.io.Serializable;
import java.util.Vector;
import phic.Body;

public class EventLog
implements Serializable {
    public static String FLUID_EVENT = "Fluid";
    Body body;
    public Vector events = new Vector();
    long logDuration = 604800000L;

    public EventLog(Body body) {
        this.body = body;
    }

    public void document(Object eventType, String name, Object parameter) {
        Event e = new Event();
        e.type = eventType;
        e.parameter = parameter;
        e.time = this.body.getClock().getTime();
        e.name = name;
        this.events.add(e);
        Event e0 = (Event)this.events.get(0);
        if (e0.time < e.time - this.logDuration) {
            this.events.remove(0);
        }
    }

    public Vector getEventsOfType(Object type) {
        Vector<Event> v = new Vector<Event>();
        int i = 0;
        while (i < this.events.size()) {
            Event e = (Event)this.events.get(i);
            if (e.type == type) {
                v.add(e);
            }
            ++i;
        }
        return v;
    }

    public class Event
    implements Serializable {
        public Object type;
        public Object parameter;
        public long time;
        public String name;

        public String toString() {
            return String.valueOf(EventLog.this.body.getClock().getTimeString(0)) + ": " + EventLog.this.body.getName() + this.type.toString() + this.parameter.toString();
        }
    }
}

