/*
 * Decompiled with CFR 0.152.
 */
package phic.common;

import evaluator.MathException;
import evaluator.ParseException;
import evaluator.StackException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import phic.Current;
import phic.Resource;
import phic.common.IniReader;
import phic.gui.PhicApplication;
import phic.gui.PhicFrameSetup;
import phic.modifiable.Script;

public class DiseaseCreator {
    public String[] getDiseaseList() {
        IniReader r = new IniReader("Diseases.txt");
        return r.getSectionHeaders();
    }

    public JMenu getMenu() {
        final Action[] diseaseActions = this.getDiseaseActions();
        ActionListener myal = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int i = 0;
                while (i < diseaseActions.length) {
                    if (diseaseActions[i].getValue("Name").equals(e.getActionCommand())) {
                        diseaseActions[i].actionPerformed(e);
                    }
                    ++i;
                }
            }
        };
        try {
            JMenu m = Resource.loader.createMenuFromIni("Diseases.txt", "Diseases", myal, null);
            return m;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Action[] getDiseaseActions() {
        String[] s = this.getDiseaseList();
        Action[] a = new Action[s.length];
        int i = 0;
        while (i < a.length) {
            Disease d = new Disease(s[i]);
            a[i] = d.getAction();
            ++i;
        }
        return a;
    }

    public static class Disease {
        Script script;
        String name;
        String description = "";
        String scriptText;
        public boolean showMessage = true;

        public String toString() {
            return this.name;
        }

        public Disease(String name) {
            IniReader r = new IniReader("Diseases.txt");
            String[] s = r.getSectionStrings(name);
            Map map = r.getSectionMap(name);
            try {
                this.description = map.get("Description").toString().trim();
            }
            catch (Exception e) {
                System.out.println("Disease " + name + " has no description");
            }
            this.script = new Script();
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < s.length) {
                if (!s[i].startsWith("Icon") && !s[i].startsWith("Description")) {
                    sb.append(s[i]);
                }
                ++i;
            }
            this.scriptText = sb.toString();
            this.recompile();
            this.name = name;
        }

        void recompile() {
            try {
                this.script.setText(this.scriptText);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }

        public void invoke() {
            try {
                String m;
                this.script.executeOnce();
                String string = m = this.showMessage ? ": " + this.description : "";
                if (PhicFrameSetup.treeIsShowing) {
                    m = ": " + this.script.getText();
                }
                Current.body.message("Disease " + this.name + m);
                PhicApplication.frame.markEvent(this.name);
            }
            catch (MathException e) {
                e.printStackTrace();
            }
            catch (StackException e) {
                e.printStackTrace();
            }
        }

        public Action getAction() {
            return new DiseaseAction();
        }

        protected class DiseaseAction
        extends AbstractAction {
            DiseaseAction() {
                super(Disease.this.name);
                this.putValue("LongDescription", Disease.this.description);
            }

            public void actionPerformed(ActionEvent e) {
                Disease.this.recompile();
                if (Disease.this.script.getStatements().length < 1) {
                    JOptionPane.showMessageDialog(null, "Disease " + Disease.this.name + " not yet implemented", "Disease not implemented", 2);
                }
                Disease.this.invoke();
            }
        }
    }
}

