/*
 * Decompiled with CFR 0.152.
 */
package phic.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import phic.Current;
import phic.Person;
import phic.common.Clock;
import phic.gui.SimplePhicFrame;
import phic.modifiable.RecordedEvent;

public class DataHistory {
    Vector data = new Vector();
    Vector events = new Vector();

    public void storeSnapshot(Person p) {
        this.data.add(new Snapshot(p));
    }

    public void storeEvent(String eventScript) {
        RecordedEvent e = new RecordedEvent();
        e.setStatement(eventScript);
        e.setTime(Current.body.getClock().getTime());
        this.events.add(e);
    }

    public void removeEarliestSnapshot() {
        this.data.remove(0);
    }

    public int getDataSize() {
        return this.data.size();
    }

    public String[] getTimes() {
        String[] s = new String[this.data.size()];
        int i = 0;
        while (i < this.data.size()) {
            s[i] = Clock.datetimeformat.format(new Date(((Snapshot)this.data.get(i)).getTime()));
            ++i;
        }
        return s;
    }

    public void restore(int i, SimplePhicFrame frame) {
        ((Snapshot)this.data.get(i)).restore(frame);
    }

    public void removeAll() {
        this.data.removeAllElements();
    }

    public void removeAfter(int i) {
        while (this.data.size() > i + 1) {
            this.data.remove(i + 1);
        }
    }

    static class Snapshot {
        byte[] data;
        protected long time;

        public Snapshot(Person p) {
            try {
                this.time = p.body.getClock().getTime();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ZipOutputStream zos = new ZipOutputStream(baos);
                zos.putNextEntry(new ZipEntry(this.toString()));
                ObjectOutputStream oos = new ObjectOutputStream(zos);
                oos.writeObject(p);
                zos.closeEntry();
                zos.close();
                this.data = baos.toByteArray();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public Person getPerson() {
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(this.data);
                ZipInputStream zis = new ZipInputStream(bais);
                zis.getNextEntry();
                ObjectInputStream ois = new ObjectInputStream(zis);
                Person p = (Person)ois.readObject();
                zis.closeEntry();
                zis.close();
                return p;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public long getTime() {
            return this.time;
        }

        public String toString() {
            return Clock.datetimeformat.format(new Date(this.time));
        }

        public void restore(SimplePhicFrame f) {
            f.setupNewPerson(this.getPerson());
        }
    }
}

