/*
 * Decompiled with CFR 0.152.
 */
package phic.common;

import evaluator.MathExtra;
import phic.common.HasContent;

public abstract class Curve
implements HasContent {
    protected double[] params;

    public abstract double getValue(double var1);

    public abstract double getInverse(double var1);

    public static class ExponentialApproach
    extends Curve {
        public double decayConstant = 1.0;
        public double maximalValue = 1.0;

        public double getValue(double x) {
            return this.maximalValue * (1.0 - Math.exp(-this.decayConstant * x));
        }

        public double getInverse(double y) {
            return -Math.log(1.0 - y / this.maximalValue) / this.decayConstant;
        }
    }

    public static class Linear
    extends Curve {
        public double gradient;
        public double constant;

        public Linear(double gradient, double constant) {
            this.gradient = gradient;
            this.constant = constant;
        }

        public double getValue(double x) {
            return this.gradient * x + this.constant;
        }

        public double getInverse(double y) {
            return (y - this.constant) / this.gradient;
        }
    }

    public static class Sigmoid
    extends Curve {
        public Sigmoid(double xmin, double xmax, double ymin, double ymax) {
            this.params = new double[]{xmin, xmax, ymin, ymax};
        }

        public double getValue(double x) {
            return this.params[2] + (this.params[3] - this.params[2]) * MathExtra.sigmoid(x * (this.params[1] - this.params[0]) - this.params[0]);
        }

        public double getInverse(double y) {
            return (MathExtra.inverseSigmoid((y - this.params[2]) / (this.params[3] - this.params[2])) + this.params[0]) / (this.params[1] - this.params[0]);
        }
    }

    public static class Starling
    extends Curve {
        public double optimumEDV = 0.12;
        public double maximalSV = 0.11;
        public double minimumEDV = 0.015;

        public double getValue(double EDV) {
            if (EDV < this.optimumEDV) {
                return this.maximalSV * (EDV - this.minimumEDV) / (this.optimumEDV - this.minimumEDV);
            }
            return Math.max(this.maximalSV * (1.0 + 0.2 * (EDV - this.optimumEDV) / this.optimumEDV), 0.0);
        }

        public double getInverse(double y) {
            throw new IllegalStateException("Starling curve is a noninvertible function");
        }
    }

    public static class TwoGradients
    extends Curve {
        public double splitX = 0.0;
        public double splitY = 0.0;
        public double lowerGradient = 1.0;
        public double higherGradient = 1.0;
        public boolean isSmooth = true;
        public double smoothing = 0.4;

        public double getValue(double x) {
            double linear = (x > this.splitX ? this.higherGradient : this.lowerGradient) * (x - this.splitX);
            return this.splitY + linear - (this.isSmooth ? this.smoothing * Math.exp(-Math.abs(linear) / this.smoothing) : 0.0);
        }

        public double getInverse(double y) {
            if (this.lowerGradient * this.higherGradient <= 0.0) {
                throw new IllegalStateException("Noninvertible twogradient function");
            }
            return (y > this.splitY ? (this.higherGradient > 0.0 ? (y - this.splitY) / this.higherGradient : (y - this.splitY) / this.lowerGradient) : (this.higherGradient > 0.0 ? (y - this.splitY) / this.lowerGradient : (y - this.splitY) / this.higherGradient)) + this.splitX;
        }
    }
}

