/*
 * Decompiled with CFR 0.152.
 */
package phic.common;

import java.io.PrintStream;
import java.util.Vector;
import phic.Current;
import phic.common.Fluids;
import phic.common.HasContent;
import phic.common.Quantity;
import phic.common.VDouble;
import phic.common.VDoubleReadOnly;

public class Container
implements Cloneable,
HasContent {
    static int serial = 0;
    public Vector qs = new Vector();
    public Quantity bicarb = new Quantity(this);
    public Quantity H = new Quantity(this);
    public Quantity glucose = new Quantity(this);
    public Quantity urea = new Quantity(this);
    public Quantity prot = new Quantity(this);
    public Quantity K = new Quantity(this);
    public Quantity Na = new Quantity(this);
    public Quantity creat = new Quantity(this);
    public Quantity solids = new Quantity(this);
    public VDouble volume = new VDouble(){
        {
            this.unit = 4;
        }

        public void set(double v) {
            Container.this.vol = v;
        }

        public double get() {
            return Container.this.vol;
        }
    };
    protected double vol;
    private static Container PROTEIN_1M = null;
    protected static Container WATER = Fluids.get("Water", 1.0);
    public VDouble Osm = new VDoubleReadOnly(){
        {
            this.unit = 11;
        }

        public double get() {
            return Container.this.getOsmolarity();
        }
    };
    protected static final double log10 = Math.log(10.0);
    public VDouble pH = new VDouble(){

        public double get() {
            return Container.this.calculatepH();
        }

        public void set(double value) {
            Container.this.H.setC((1.0 - Container.this.solids.getC()) * Math.pow(10.0, -value));
        }
    };
    public VDoubleReadOnly Cl = new VDoubleReadOnly(){

        public double get() {
            return Container.this.calculateChloride();
        }
    };
    protected static final double BICARB_DISSOC_K = 7.95E-7;
    public Quantity H2CO3 = new Quantity(this);
    public double ABC;
    public static String[] quantityname = new String[]{"bicarb", "H", "glucose", "urea", "prot", "K", "Na", "solids", "creat"};

    public Container() {
        this.qs.add(this.bicarb);
        this.qs.add(this.H);
        this.qs.add(this.glucose);
        this.qs.add(this.urea);
        this.qs.add(this.prot);
        this.qs.add(this.K);
        this.qs.add(this.Na);
        this.qs.add(this.solids);
        this.qs.add(this.creat);
        ++serial;
    }

    public Quantity substance(int i) {
        return (Quantity)this.qs.elementAt(i);
    }

    public void set(Container from) {
        Container lock1 = this;
        Container lock2 = from;
        if (this.hashCode() > from.hashCode()) {
            lock1 = from;
        }
        lock2 = this;
        this.vol = from.vol;
        int i = 0;
        while (i < from.qs.size()) {
            this.substance(i).set(from.substance(i).get());
            ++i;
        }
    }

    public Container withdrawVol(double volume) {
        Container c = new Container();
        this.withdrawVol_overwrite(volume, c);
        return c;
    }

    public void withdrawVol_overwrite(double volume, Container into) {
        into.set(this);
        if (volume < 0.0) {
            Current.body.error("cannot withdraw negative amount, " + volume);
        }
        into.vol = volume = Math.min(volume, this.vol);
        int i = 0;
        while (i < this.qs.size()) {
            into.substance(i).setC(this.substance(i).getC());
            ++i;
        }
        this.vol -= volume;
    }

    public Container withdrawFrac(double fraction) {
        double frac = Math.max(Math.min(fraction, 1.0), 0.0);
        return this.withdrawVol(this.vol * frac);
    }

    public void withdrawFrac_overwrite(double fraction, Container into) {
        double frac = Math.max(Math.min(fraction, 1.0), 0.0);
        this.withdrawVol_overwrite(this.vol * frac, into);
    }

    public void add(Container from) {
        this.increaseVolume(from.vol);
        int n = from.qs.size();
        if (this.qs.size() < n) {
            throw new IllegalArgumentException("This " + this.getClass() + " and that " + from.getClass() + " have different quantities.");
        }
        int i = 0;
        while (i < n) {
            this.substance(i).addQ(from.substance(i).getQ());
            from.substance(i).setQ(0.0);
            ++i;
        }
        from.vol = 0.0;
    }

    public void addAndDiscardExtras(Container from) {
        this.increaseVolume(from.vol);
        int n = this.compatibleQSize(from);
        int i = 0;
        while (i < n) {
            this.substance(i).addQ(from.substance(i).getQ());
            from.substance(i).setQ(0.0);
            ++i;
        }
        from.vol = 0.0;
    }

    public void add(Container from, double volume) {
        if (volume < 0.0 && this.solids.getC() > Math.abs(volume)) {
            throw new RuntimeException("Withdrawal of " + Math.abs(volume) + "L from " + this.vol + "L, " + this.solids.getQ() + " of which is solids.");
        }
        Container lock1 = this;
        Container lock2 = from;
        if (this.hashCode() > from.hashCode()) {
            lock1 = from;
        }
        lock2 = this;
        volume = Math.min(volume, from.vol);
        double p = volume / from.vol;
        int i = 0;
        while (i < this.qs.size()) {
            double t = p * from.substance(i).getQ();
            if (p < 0.0) {
                t = Math.max(t, -this.substance(i).getQ());
            }
            this.substance(i).setC((this.substance(i).getQ() + t) / (this.vol + volume));
            from.substance(i).setC((from.substance(i).getQ() - t) / (from.vol - volume));
            ++i;
        }
        from.vol -= volume;
        this.vol += volume;
    }

    public void withdrawVolExample_overwrite(Container example, Container into) {
        double fraction = example.vol / this.vol;
        double maxVolume = example.volume.get();
        into.set(example);
        int i = 0;
        while (i < this.qs.size()) {
            double availableQ;
            double exampleC = example.substance(i).getC();
            double exampleQ = exampleC * maxVolume;
            if (exampleQ > (availableQ = this.substance(i).getQ())) {
                maxVolume = Math.min(maxVolume, availableQ / exampleC);
            }
            ++i;
        }
        into.vol = maxVolume;
        if (maxVolume <= 0.0) {
            return;
        }
        i = 0;
        while (i < this.qs.size()) {
            double transferQ = into.substance(i).getQ();
            this.substance(i).addQ(-transferQ);
            ++i;
        }
        this.increaseVolume(-maxVolume);
    }

    private Container withdrawAllPossible(Container example, double withdrawVolume) {
        Container n = new Container();
        n.vol = withdrawVolume;
        if (withdrawVolume != 0.0) {
            int i = 0;
            while (i < this.qs.size()) {
                double exampleQ = example.substance(i).getC() * withdrawVolume;
                double availableQ = this.substance(i).getQ();
                double transferQ = Math.min(exampleQ, availableQ);
                n.substance(i).setQ(transferQ);
                this.substance(i).addQ(-transferQ);
                ++i;
            }
            this.increaseVolume(-withdrawVolume);
        }
        return n;
    }

    private void withdrawAllPossible_overwrite(Container example, double withdrawVolume, Container into) {
        double tx;
        into.vol = tx = Math.min(this.vol, withdrawVolume);
        if (tx == 0.0) {
            return;
        }
        int i = 0;
        while (i < this.qs.size()) {
            double exampleQ = example.substance(i).getC() * tx;
            double availableQ = this.substance(i).getQ();
            double transferQ = Math.min(exampleQ, availableQ);
            into.substance(i).setQ(transferQ);
            this.substance(i).addQ(-transferQ);
            ++i;
        }
        this.increaseVolume(-tx);
    }

    public Container withdrawFracII(Container example, double fraction) {
        double maxVolume = this.vol;
        int i = 0;
        while (i < this.qs.size()) {
            double availableQ = this.substance(i).getQ();
            double requiredC = example.substance(i).getC();
            if (requiredC != 0.0) {
                maxVolume = Math.min(maxVolume, availableQ / requiredC);
            }
            ++i;
        }
        Container extract = this.withdrawAllPossible(example, maxVolume * fraction);
        return extract;
    }

    public void withdrawFracII_overwrite(Container example, double fraction, Container into) {
        double maxVolume = this.vol;
        int i = 0;
        while (i < this.qs.size()) {
            double availableQ = this.substance(i).getQ();
            double requiredC = example.substance(i).getC();
            if (requiredC != 0.0) {
                maxVolume = Math.min(maxVolume, availableQ / requiredC);
            }
            ++i;
        }
        this.withdrawAllPossible_overwrite(example, maxVolume * fraction, into);
    }

    public Container filterSolids() {
        Container to = new Container();
        double solidvolume = this.solids.getQ();
        to.increaseVolume(solidvolume);
        this.increaseVolume(-solidvolume);
        to.solids.set(1.0);
        this.solids.set(0.0);
        return to;
    }

    public void filterSolidsInto(Container c) {
        double solidVol = this.solids.getQ();
        double oldsol = c.solids.getQ();
        c.increaseVolume(solidVol);
        c.solids.setQ(oldsol + solidVol);
        this.increaseVolume(-solidVol);
        this.solids.set(0.0);
    }

    public Container ultraFiltrate(double volume) {
        if (PROTEIN_1M == null) {
            PROTEIN_1M = Fluids.get("Large", 1.0);
        }
        Container to = this.withdrawVol(volume);
        this.add(to.filterSolids());
        this.add(to.withdrawFracII(PROTEIN_1M, 1.0));
        return to;
    }

    public void ultraFiltrate_overwrite(double volume, Container into) {
        this.withdrawVol_overwrite(volume, into);
        into.filterSolidsInto(this);
        into.prot.moveTo(this.prot);
    }

    public void increaseVolume(double volume) {
        double cfrac = (volume = Math.max(volume, -this.vol)) + this.vol <= 0.0 ? 0.0 : this.vol / (this.vol + volume);
        int i = 0;
        while (i < this.qs.size()) {
            this.substance(i).multiplyC(cfrac);
            ++i;
        }
        this.vol += volume;
    }

    public void addWater(double volume) {
        if ((volume = Math.max(volume, -this.vol)) > 0.0) {
            Container.WATER.vol = volume;
            this.add(WATER);
        } else if (volume < 0.0) {
            Container.WATER.vol = 1.0;
            this.add(WATER, volume);
        }
    }

    public void osmose(Container to, double osmolarity, double frac) {
        double transf = (osmolarity - this.getOsmolarity()) * this.vol / osmolarity;
        transf *= frac;
        transf = Math.max(transf, -to.vol);
        to.increaseVolume(transf);
        this.increaseVolume(-transf);
    }

    protected double getOsmolarity() {
        return this.H.getC() + this.glucose.getC() + this.urea.getC() + this.prot.getC() + 2.0 * this.Na.getC() + 2.0 * this.K.getC();
    }

    protected double calculatepH() {
        double fconc = this.H.getC() / (1.0 - this.solids.getC());
        if (fconc <= 0.0) {
            return 0.0;
        }
        return -Math.log(fconc) / log10;
    }

    protected double calculateChloride() {
        return this.Na.getC() + this.K.getC() - this.bicarb.getC();
    }

    public void diffuse(double mu, double conc1, double conc2, Quantity q1, Quantity q2) {
        double R = (q1.getQ() - q2.getQ()) * mu / (conc1 + conc2);
        q1.moveTo(q2, conc2 * R);
    }

    public Container createMore(double volume) {
        try {
            Container c = (Container)this.clone();
            c.vol = volume;
            c.qs = new Vector();
            int i = 0;
            while (i < this.qs.size()) {
                Quantity q = (Quantity)this.substance(i).clone();
                q.parent = c;
                c.qs.add(q);
                ++i;
            }
            return c;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void empty() {
        int i = 0;
        while (i < this.qs.size()) {
            this.substance(i).setC(0.0);
            ++i;
        }
        this.vol = 0.0;
        this.ABC = 0.0;
        this.H2CO3.set(0.0);
    }

    public void doBicarbonateBuffering() {
        double cH = this.H.getC();
        double cBic = this.bicarb.getC();
        double cH2CO3 = this.H2CO3.get();
        double quantity = this.ABC = (7.95E-7 * cH2CO3 - cH * cBic) / (cBic + cH + 7.95E-7);
        this.H.addC(quantity);
        this.bicarb.addC(quantity);
        this.H2CO3.addC(-quantity * 22.4);
    }

    public void report(PrintStream ps) {
        ps.print("volume\t");
        int i = 0;
        while (i < quantityname.length) {
            ps.print(String.valueOf(quantityname[i]) + "\t");
            ++i;
        }
        ps.print('\n');
        ps.print(this.vol + 9.0);
        i = 0;
        while (i < this.qs.size()) {
            ps.print(String.valueOf(this.substance(i).getC()) + "\t");
            ++i;
        }
        ps.print('\n');
    }

    public String toString() {
        StringBuffer s = new StringBuffer("{");
        int i = 0;
        while (i < quantityname.length) {
            if (i > 0) {
                s.append(", ");
            }
            s.append(quantityname[i]);
            s.append("=" + this.substance(i).formatValue(true, false));
            ++i;
        }
        s.append("}");
        return s.toString();
    }

    public boolean hasError() {
        if (Double.isNaN(this.vol)) {
            return true;
        }
        int i = 0;
        while (i < this.qs.size()) {
            if (Double.isNaN(((Quantity)this.qs.get(i)).getC())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected int compatibleQSize(Container from) {
        int n1 = this.qs.size();
        int n2 = from.qs.size();
        int n = Math.min(n1, n2);
        return n;
    }

    public class NonSolid {
        Container outerC;
        public Quantity bicarb;
        VDouble volume;

        public NonSolid() {
            this.bicarb = new LQuantity(Container.this);
            this.volume = new VDouble(){

                public double get() {
                    return NonSolid.this.outerC.volume.get() - NonSolid.this.outerC.solids.getQ();
                }

                public void set(double volume) {
                    NonSolid.this.outerC.volume.set(volume + NonSolid.this.outerC.solids.getQ());
                }
            };
            this.outerC = Container.this;
        }

        private class LQuantity
        extends Quantity {
            public LQuantity(Container parent) {
                super(parent);
            }

            public void set(double value) {
            }

            public double get() {
                return 0.0;
            }
        }
    }
}

