/*
 * Decompiled with CFR 0.152.
 */
package phic.common;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import phic.Current;
import phic.common.Ticker;

public class Clock
implements Serializable {
    private double second;
    private double minute;
    private double hour;
    private double day;
    public boolean running = false;
    public long time;
    public long simulationStartTime = this.time = System.currentTimeMillis();
    public transient Vector tickers = new Vector();
    protected long lasttime = this.time;
    public transient Vector threads = new Vector();
    private transient Vector allThreads = new Vector();
    transient Vector notifyList = new Vector();
    public static final int DATETIME = 0;
    public static final int DATE = 1;
    public static final int TIME = 2;
    public static final int SHORTDATE = 3;
    public static final int DAYONLY = 4;
    public static final int SHORTDATETIME = 5;
    protected static DateFormat datetimeformat = DateFormat.getDateTimeInstance(1, 2);
    protected static DateFormat dateformat = DateFormat.getDateInstance(2);
    protected static DateFormat timeformat = DateFormat.getTimeInstance(2);
    protected static DateFormat shortdateformat = new SimpleDateFormat("d MMM");
    protected static DateFormat dayonlyformat = new SimpleDateFormat("dd");
    protected static DateFormat shortdatetimeformat = new SimpleDateFormat("dd/MM, hha");
    public boolean isSlowMode = false;

    public Clock() {
        this.setSecond(1000.0);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        this.tickers = new Vector();
        this.notifyList = new Vector();
    }

    public void resetTime() {
        this.simulationStartTime = this.time = (this.lasttime = System.currentTimeMillis());
    }

    public void start() {
        this.lasttime = System.currentTimeMillis();
        int i = 0;
        while (i < this.threads.size()) {
            ((WaitingThread)this.threads.get((int)i)).latchtime = this.lasttime;
            ++i;
        }
        this.running = true;
    }

    public void stop() {
        String z = this.getTimeString(2);
        this.running = false;
    }

    public long getTime() {
        long ctm = System.currentTimeMillis();
        long diff = ctm - this.lasttime;
        this.lasttime = ctm;
        if (!this.running) {
            diff = 0L;
        }
        this.time = (long)((double)this.time + (double)(1000L * diff) / this.second);
        return this.time;
    }

    public boolean dayChanged() {
        long pt;
        int d2;
        long lt;
        int d1;
        WaitingThread t = this.getThread();
        if (t == null) {
            t = this.getThread(Current.thread);
        }
        return (d1 = (int)((double)(lt = t.latchtime) / this.day)) != (d2 = (int)((double)(pt = lt - t.elapsed) / this.day));
    }

    public synchronized void setSecond(double s) {
        this.second = s;
        this.minute = 60.0 * this.second;
        this.hour = 60.0 * this.minute;
        this.day = 24.0 * this.hour;
        this.isSlowMode = this.second >= 200.0;
        this.notifyAll();
    }

    public double getSecond() {
        return this.second;
    }

    public synchronized void latch() {
        WaitingThread t = this.getThread();
        if (t == null) {
            t = new WaitingThread();
            t.thread = Thread.currentThread();
            this.allThreads.add(t);
            t.latchtime = System.currentTimeMillis() - 1000L;
            this.threads.add(t);
        }
        long scm = System.currentTimeMillis();
        t.elapsed = scm - t.latchtime;
        t.latchtime = scm;
    }

    public double elapsedTime() {
        WaitingThread w = this.getThread();
        if (w == null) {
            w = this.getThread(Current.thread);
        }
        return (long)((double)(w.elapsed * 1000L) / this.second);
    }

    public void preventTimeLapse() {
        this.lasttime = System.currentTimeMillis() - 100L;
    }

    public void clearThreads() {
        this.allThreads = new Vector();
        this.threads = new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final WaitingThread getThread() {
        Vector vector = this.allThreads;
        synchronized (vector) {
            int i = 0;
            while (i < this.allThreads.size()) {
                if (((WaitingThread)this.allThreads.get((int)i)).thread.equals(Thread.currentThread())) {
                    return (WaitingThread)this.allThreads.get(i);
                }
                ++i;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final WaitingThread getThread(Thread thread) {
        Vector vector = this.allThreads;
        synchronized (vector) {
            int i = 0;
            while (i < this.allThreads.size()) {
                if (((WaitingThread)this.allThreads.get((int)i)).thread.equals(thread)) {
                    return (WaitingThread)this.allThreads.get(i);
                }
                ++i;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void IwaitSeconds(double s) {
        WaitingThread w = this.getThread();
        if (w == null) {
            Current.body.error("Thread not latched");
        }
        this.threads.remove(w);
        long millis = (long)(s * this.second) - (System.currentTimeMillis() - w.latchtime);
        if (millis > 0L) {
            try {
                Clock clock = this;
                synchronized (clock) {
                    this.wait(millis);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
    }

    public void elapseTime(double seconds) {
        this.running = true;
        this.lasttime = System.currentTimeMillis() - (long)(seconds * this.second);
        this.getTime();
        this.running = false;
    }

    protected void IwaitMinutes(double m) {
        this.IwaitSeconds(m * 60.0);
    }

    public void requestNotifyAfter(double seconds, Object waitingObject) {
        this.notifyList.add(new NotifyObject(this.time + (long)(seconds * 1000.0), waitingObject));
    }

    public final void checkNotifyObejcts() {
        int i = 0;
        while (i < this.notifyList.size()) {
            NotifyObject o = (NotifyObject)this.notifyList.get(i);
            if (o.time < this.time) {
                o.elapsed();
            }
            ++i;
        }
    }

    public String getTimeString(int type) {
        long ctime = this.getTime();
        return this.getDateFormatForDateType(type).format(new Date(ctime));
    }

    public DateFormat getDateFormatForDateType(int type) {
        DateFormat d = null;
        switch (type) {
            case 0: {
                d = datetimeformat;
                break;
            }
            case 1: {
                d = dateformat;
                break;
            }
            case 2: {
                d = timeformat;
                break;
            }
            case 3: {
                d = shortdateformat;
                break;
            }
            case 4: {
                d = dayonlyformat;
                break;
            }
            case 5: {
                d = shortdatetimeformat;
            }
        }
        return d;
    }

    public String getTimeAsString(long time, int type) {
        return this.getDateFormatForDateType(type).format(new Date(time));
    }

    public static double getAverageElapsedTime() {
        return Current.thread.averageElapsedTime;
    }

    public static double getExactElapsedTime() {
        return Current.thread.averageUncorrectedTime;
    }

    public void addTicker(Ticker ticker) {
        this.tickers.add(ticker);
    }

    public void removeTicker(Ticker ticker) {
        this.tickers.remove(ticker);
    }

    public int getHour() {
        return (int)(this.getTime() / 3600000L) % 24;
    }

    public String getHourString() {
        int h = this.getHour();
        return String.valueOf((h + 11) % 12 + 1) + (h >= 12 ? "pm" : "am");
    }

    final class NotifyObject {
        Object object;
        long time;

        NotifyObject(long t, Object o) {
            this.time = t;
            this.object = o;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void elapsed() {
            Object object = this.object;
            synchronized (object) {
                this.object.notify();
                Clock.this.notifyList.remove(this);
            }
        }
    }

    protected class WaitingThread
    implements Serializable {
        Thread thread;
        long latchtime;
        long elapsed;

        protected WaitingThread() {
        }
    }
}

