/*
 * Decompiled with CFR 0.152.
 */
package phic.common;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Vector;
import phic.BasicActions;
import phic.Current;
import phic.common.HasContent;
import phic.common.Variable;
import phic.gui.LimitedNode;
import phic.gui.Node;

public class ClassVisualiser
implements Member {
    Class c;
    Vector simpleMethods = new Vector();
    Vector doubleFields = new Vector();
    Vector booleanFields = new Vector();
    Vector containers = new Vector();
    public Object object;
    public String name = "Visualiser";

    public ClassVisualiser(Object o) throws Exception {
        this.object = o;
        this.initialise(o.getClass());
    }

    public ClassVisualiser(String className) throws Exception {
        this.object = null;
        try {
            this.initialise(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            Current.body.error("Cannot find class " + className);
        }
    }

    public ClassVisualiser(Class cls) throws Exception {
        this.object = null;
        this.initialise(cls);
    }

    private void initialise(Class cls) throws Exception {
        this.c = cls;
        Method[] m = this.c.getMethods();
        int i = 0;
        while (i < m.length) {
            if (m[i].getParameterTypes().length == 0 && Modifier.isPublic(m[i].getModifiers()) && !this.isDefaultMethod(m[i].getName())) {
                if (m[i].getReturnType().equals(Void.TYPE)) {
                    this.simpleMethods.add(m[i]);
                } else if (m[i].getReturnType().equals(Double.TYPE)) {
                    this.doubleFields.add(m[i]);
                }
            }
            ++i;
        }
        Field[] f = this.c.getFields();
        int i2 = 0;
        while (i2 < f.length) {
            Class<?> d = f[i2].getType();
            if (d == Double.TYPE) {
                this.doubleFields.add(f[i2]);
            } else if (d == Boolean.TYPE) {
                this.booleanFields.add(f[i2]);
            } else if (ClassVisualiser.is(d, Variable.class)) {
                this.doubleFields.add(f[i2]);
            } else if (ClassVisualiser.is(d, HasContent.class)) {
                ClassVisualiser nv = new ClassVisualiser(f[i2].get(this.object));
                nv.name = f[i2].getName();
                this.containers.add(nv);
            } else if (ClassVisualiser.is(d, BasicActions.ComplexAction.class)) {
                this.simpleMethods.add(f[i2]);
            }
            ++i2;
        }
    }

    public static boolean is(Class a, Class b) {
        Class c = a;
        while (c != Object.class && c != null) {
            if (c == b) {
                return true;
            }
            if (ClassVisualiser.isinterface(c, b)) {
                return true;
            }
            c = c.getSuperclass();
        }
        return false;
    }

    static boolean isinterface(Class a, Class b) {
        Class<?>[] c = a.getInterfaces();
        int i = 0;
        while (i < c.length) {
            if (c[i] == b) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isDefaultMethod(String m) {
        return m.equals("notify") || m.equals("notifyAll") || m.equals("wait") || m.equals("run");
    }

    public void createTree(Node n) {
        this.createNodes(n, this.simpleMethods);
        this.createNodes(n, this.doubleFields);
        this.createNodes(n, this.booleanFields);
        this.createNodes(n, this.containers);
        if (this.object instanceof Vector) {
            this.createNodes(n, (Vector)this.object);
        }
    }

    void createNodes(Node n, Vector v) {
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (!(o instanceof Member)) continue;
            LimitedNode next = LimitedNode.createOrFind((Member)o, this.object, n);
            n.add(next);
            if (!(o instanceof ClassVisualiser)) continue;
            ((ClassVisualiser)o).createTree(next);
        }
    }

    public Class getDeclaringClass() {
        return ClassVisualiser.class;
    }

    public int getModifiers() {
        return 0;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSynthetic() {
        return false;
    }
}

