/*
 * Decompiled with CFR 0.152.
 */
package phic;

import phic.Current;
import phic.Environment;
import phic.common.Container;
import phic.common.EventLog;
import phic.common.Fluids;
import phic.common.PerfusedOrgan;
import phic.common.VDouble;

public class Skin
extends PerfusedOrgan {
    public VDouble SwR = new VDouble();
    public VDouble Temp = new VDouble();
    Container sweatLost = new Container();
    public VDouble area = new VDouble();
    VDouble evaporationRate;
    private Container sweat_example;
    private Container sweat_temp;

    public Skin() {
        this.addEqn("\\frac{d}{dt}Temp", "\\frac{Cals}{Wt} - 0.05 \\left(Temp-SkTmp\\right)\\frac{SkFlo+0.045ml/min}{10}");
        this.addEqn("\\frac{d}{dt}SkTemp", "0.95 \\left(Temp-SkTmp\\right)\\frac{SkFlo+0.045ml/min}{10} - 100 SwR + 0.1 (SkTmp-AmbT)(1-Togs) ");
        this.addEqn("SwR\\rightarrow_{0.1/min}", "\\left[ min\\left(\\left[0.5ml/min + 10ml/min \\cdot \\left(\\Delta Temp + 0.1 \\Delta SkTemp - 6\\cdot Fever\\right) \\right]_{0.1}^{30}  , \\frac{svp\\left(AmbT\\right)}{2\\cdot BarP}\\left(1-\\left(Togs\\cdot\\left(1-Hum\\right)+Hum\\right) \\right) \\right) \\cdot \\left( \\frac{\\Delta SkFlo}{400ml/min}-1\\right)\\right]_0^1");
        this.evaporationRate = new VDouble();
        this.sweat_example = Fluids.get("Saline", 1.0);
        this.sweat_temp = new Container();
    }

    public void tick() {
        Environment e = Current.environment;
        criticalPeriod.enter();
        double skinDT = this.Temp.get() - e.Temp.get();
        this.sweat_example.volume.set(this.SwR.get() * this.elapsedTime / 60.0);
        this.body.blood.withdrawVolExample_overwrite(this.sweat_example, this.sweat_temp);
        this.sweatLost.add(this.sweat_temp);
        double metabolicHeat = this.body.Cals.get() / this.body.Mass.get();
        double R = (this.body.Temp.get() - this.Temp.get()) * (this.flow.get() + 0.045) / 10.0;
        this.body.Temp.set(this.body.Temp.get() + (metabolicHeat - 0.05 * R) * this.elapsedTime / 60.0);
        this.Temp.set(this.Temp.get() + 0.95 * R * this.elapsedTime / 60.0);
        criticalPeriod.exit();
        if (this.body.getClock().dayChanged()) {
            this.body.eventLog.document(EventLog.FLUID_EVENT, "Sweated", new Double(-this.sweatLost.volume.get()));
            this.environment.rubbish.add(this.sweatLost);
        }
        double radiationPerMin = skinDT * (1.0 - e.Togs.get()) / 2.0;
        double effectiveHumidity = e.Togs.get() * (1.0 - e.Hum.get()) + e.Hum.get();
        double error = this.body.Temp.getError() + 0.1 * this.Temp.getError() - 6.0 * this.body.brain.fever.get();
        double resError = Math.min(Math.max(error * -0.125 + 0.25, 0.01), 5.0);
        double vct = this.body.CVS.VCT.get();
        double apco2 = this.body.blood.arterial.PCO2.get();
        double resProduct = (1.0 + (vct - 1.0) * 15.0) * resError + this.body.blood.getDrugBinding("ALPHA_ADRENOCEPTOR");
        double swError = Math.min(Math.max(5.0E-4 + error / 100.0, 1.0E-4), 0.03);
        double maxVaporPerMin = Environment.getSVP(e.Temp.get()) / e.BarP.get() * 0.5 * (1.0 - effectiveHumidity);
        swError = Math.min(swError, maxVaporPerMin);
        this.evaporationRate.set(swError *= Math.max(0.0, Math.min(1.0, this.flow.getErrorRatio() * 3.0 - 1.0)));
        double actualSweatVolume = this.SwR.get();
        this.SwR.lowPass(swError, this.fractionDecayPerMinute(0.1));
        double sweatHeatPerMin = actualSweatVolume * 500.0;
        this.Temp.set(this.Temp.get() - (sweatHeatPerMin + radiationPerMin) / 5.0 * this.elapsedTime / 60.0);
        if (this.verbose) {
            this.inform("lost " + (radiationPerMin + sweatHeatPerMin) + " deg/min");
        }
        this.waitMinutes(1.0);
    }
}

