/*
 * Decompiled with CFR 0.152.
 */
package phic;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import phic.common.IniReader;

public class Resource {
    public static double HOM_VERSION = 1.45;
    public static String versionFile = "version.html";
    public static String homServer = "http://www.homphysiology.org";
    public static Resource loader = new Resource();
    protected static final String resourcePrefix = "resources/";
    Map versionInfoMap;
    protected final String ICON_PROPERTY_NAME = "Icon";

    public double getHOMVersionFromCode() {
        return HOM_VERSION;
    }

    public double getHOMVersion() {
        try {
            String doc = this.readWholeStreamToString(this.getResource(versionFile));
            Pattern p = Pattern.compile("<[Tt][Hh]>\\s*Version\\s*</[Tt][Hh]>\\s*<[Tt][Dd]>\\s*([0-9.]*)\\s*");
            Matcher m = p.matcher(doc);
            m.find();
            String s = m.group(1);
            return Double.parseDouble(s);
        }
        catch (IOException x) {
            return this.getHOMVersionFromCode();
        }
        catch (NumberFormatException x) {
            return this.getHOMVersionFromCode();
        }
    }

    public Map getVersionInfo() {
        if (this.versionInfoMap == null) {
            this.versionInfoMap = new HashMap();
            try {
                String doc = this.readWholeStreamToString(this.getResource(versionFile));
                Pattern p = Pattern.compile("<[Tt][Hh]>([^<]*)</[Tt][Hh]>\\s*<[Tt][Dd]>([^<]*)</[Tt][Dd]>");
                Matcher m = p.matcher(doc);
                while (m.find()) {
                    this.versionInfoMap.put(m.group(1).trim(), m.group(2).trim());
                }
            }
            catch (IOException x) {
                x.printStackTrace();
            }
        }
        return this.versionInfoMap;
    }

    public InputStream getResource(String resourceName) {
        try {
            if (resourceName.startsWith("http://") || resourceName.startsWith("file://")) {
                return new URL(resourceName).openStream();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.getClass().getResourceAsStream(resourcePrefix + resourceName);
    }

    public URL getResourceURL(String resourceName) {
        try {
            if (resourceName.startsWith("http://") || resourceName.startsWith("file://")) {
                return new URL(resourceName);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.getClass().getResource(resourcePrefix + resourceName);
    }

    public Image getImageResource(String resourceName) {
        if (resourceName == null) {
            throw new NullPointerException("Bad resource name '" + resourceName + "'");
        }
        Image i = Toolkit.getDefaultToolkit().createImage(this.getClass().getResource(resourcePrefix + resourceName));
        if (i == null) {
            throw new RuntimeException("Image '" + resourceName + "' could not be loaded");
        }
        return i;
    }

    public ImageIcon getIconResource(String resourceName) {
        return new ImageIcon(this.getImageResource(resourceName));
    }

    public Properties getProperties(String resourceName) {
        Properties p = new Properties();
        try {
            p.load(this.getResource(resourceName));
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load resource " + resourceName, e);
        }
        return p;
    }

    public static String[] getStringList(Properties p, String item) {
        String s = p.getProperty(item);
        if (s != null) {
            return s.split("\\s*,\\s*");
        }
        return null;
    }

    public String[] getStringList(String propertiesResourceName, String item) {
        return Resource.getStringList(this.getProperties(propertiesResourceName), item);
    }

    public static String identifierToText(String o) {
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < o.length()) {
            char c = o.charAt(i);
            if (i == 0 && !Character.isUpperCase(o.charAt(i + 1))) {
                c = Character.toUpperCase(c);
            }
            if (i > 1 && Character.isUpperCase(c)) {
                if (i < o.length() - 1 && Character.isLowerCase(o.charAt(i + 1))) {
                    s.append(' ');
                } else if (Character.isLowerCase(o.charAt(i - 1))) {
                    s.append(' ');
                }
            }
            s.append(c);
            ++i;
        }
        return s.toString();
    }

    public JMenu createMenuFromIni(String resourceName, String menuName, ActionListener al, Icon icon) throws IOException {
        Properties p = this.getProperties(resourceName);
        IniReader ini = new IniReader(this.getResource(resourceName));
        return this.recursiveCreateMenu(p, ini, menuName, al, icon);
    }

    protected JMenu recursiveCreateMenu(Properties p, IniReader ini, String menuName, final ActionListener al, Icon icon) {
        String friendlyname = Resource.identifierToText(menuName);
        JMenu menu = new JMenu(friendlyname);
        String[] itemName = Resource.getStringList(p, menuName);
        if (itemName == null) {
            itemName = ini.getSectionHeaders();
        }
        int i = 0;
        while (i < itemName.length) {
            block10: {
                String[] sectionStrings = null;
                try {
                    sectionStrings = ini.getSectionStrings(itemName[i]);
                    if (sectionStrings.length == 0) {
                        throw new IllegalArgumentException();
                    }
                }
                catch (IllegalArgumentException e) {
                    if (p.containsKey(itemName[i])) {
                        menu.add(this.recursiveCreateMenu(p, ini, itemName[i], al, icon));
                        break block10;
                    }
                    throw new IllegalArgumentException("Malformed menu file: element " + itemName[i]);
                }
                final String[] eventParams = sectionStrings;
                Icon oldicon = icon;
                try {
                    ImageIcon ic = this.getIconResource(ini.getSectionMap(itemName[i]).get("Icon").toString());
                    if (ic != null) {
                        icon = ic;
                    }
                }
                catch (NullPointerException ic) {
                }
                catch (IllegalArgumentException ic) {
                    // empty catch block
                }
                JMenuItem m = new JMenuItem(new AbstractAction(itemName[i], icon){

                    public void actionPerformed(ActionEvent e) {
                        e.setSource(eventParams);
                        al.actionPerformed(e);
                    }
                });
                icon = oldicon;
                menu.add(m);
            }
            ++i;
        }
        return menu;
    }

    public String readWholeStreamToString(InputStream s) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(s));
        String x = null;
        StringBuffer sb = new StringBuffer();
        while ((x = br.readLine()) != null) {
            sb.append(x);
        }
        return sb.toString();
    }
}

