/*
 * Decompiled with CFR 0.152.
 */
package phic;

import java.awt.Color;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.Vector;
import phic.Body;
import phic.Environment;
import phic.common.IniReader;
import phic.modifiable.Script;

public class Person
implements Serializable {
    public String name = "Jason";
    public Body body;
    public Environment environment;
    public String description = "Healthy 20-year-old male";
    public Vector organList;
    public static final boolean MALE = true;
    public static final boolean FEMALE = false;
    public boolean sex = true;
    public double height = 1.7;
    public double age = 20.0;
    public double BMI = 25.0;
    public Color skinBasePigment = new Color(255, 255, 235);
    public static final String PERSON_FILE = "patient/Patients.txt";

    public void calculateEstimates() {
        this.body.skin.area.set(this.estimateSurfaceArea());
        this.body.BMR.initialValue = this.estimateBasalEnergyExpenditure() * 1000.0;
        this.adjustFatToBMI();
        this.body.lungs.FRC.set(this.estimateFRC());
        this.body.lungs.airwayResistance.set(this.estimateAirwayResistance());
        this.body.lungs.TidV.initialValue = this.estimateTidalVolume();
        this.setupBloodVolume();
        this.body.kidney.overallRenalFunction.set(this.estimateRenalFunctionFraction());
    }

    double estimateTidalVolume() {
        return 0.51 * (this.height / 1.7) * (this.height / 1.7);
    }

    void adjustFatToBMI() {
        double expectedMass = 1000.0 * this.BMI * this.height * this.height;
        this.body.Fat.mass.set(Math.max(0.0, this.body.Fat.mass.get() + expectedMass - this.body.Mass.get()));
    }

    double estimateBasalEnergyExpenditure() {
        double kcalperday = this.sex ? 66.47 + 13.75 * this.body.Mass.get() / 1000.0 + 500.0 * this.height - 6.76 * this.age : 655.1 + 9.56 * this.body.Mass.get() / 1000.0 + 185.0 * this.height - 4.68 * this.age;
        return kcalperday;
    }

    double estimateSurfaceArea() {
        return Math.exp(-3.73 + 0.417 * Math.log(this.height * 100.0) + 0.517 * Math.log(this.body.Mass.get() / 1000.0));
    }

    double estimateFRC() {
        double reduction = Math.min(1.0, Math.max(0.0, (this.age - 25.0) / 50.0));
        if (this.age < 16.0) {
            reduction = 1.0 - this.age / 16.0;
        }
        return (this.sex ? 3.0 : 2.5) * (1.0 - reduction * 0.75);
    }

    double estimateAirwayResistance() {
        return 0.003 * (this.height / 1.7) * (this.height / 1.7) * Math.max(1.0, this.BMI / 25.0);
    }

    double estimateBloodVolume() {
        return 5.0 * (this.height * this.height * this.BMI / 72.25) * (!this.sex ? 0.94 : 1.0);
    }

    double estimateRenalFunctionFraction() {
        return Math.pow(this.age, -0.203) * (this.sex ? 1.0 : 0.742) * 32788.0 * Math.pow(60.0, -1.1) / 120.0;
    }

    public void setupDetailsFromResource(String personName) {
        IniReader ir = new IniReader(PERSON_FILE);
        Map m = ir.getSectionMap(personName);
        this.name = personName;
        String desc = (String)m.get("Description");
        if (desc != null) {
            this.description = desc;
        }
        try {
            this.age = (Double)m.get("Age");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String sex = (String)m.get("Sex");
        if (sex != null) {
            this.sex = sex.startsWith("M") || sex.startsWith("m");
        }
        try {
            this.BMI = (Double)m.get("BMI");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.height = (Double)m.get("Height");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void setupBloodVolume() {
        this.body.blood.Hct.initialValue = this.sex ? 0.45 : 0.415;
        this.body.blood.volume.initialValue = this.estimateBloodVolume();
        this.body.blood.RCM.initialValue = this.body.blood.Hct.initialValue * this.body.blood.volume.initialValue;
    }

    public void setupParametersFromResource(String personName) {
        this.calculateEstimates();
        IniReader ir = new IniReader(PERSON_FILE);
        String[] s = ir.getSectionStrings(personName);
        Vector l = new Vector(Arrays.asList(s));
        int i = 0;
        while (i < l.size()) {
            String t = l.get(i).toString().trim();
            if (t.startsWith("Description")) {
                l.remove(i);
                --i;
            }
            if (t.startsWith("Sex")) {
                l.remove(i);
                --i;
            }
            ++i;
        }
        s = l.toArray(s);
        try {
            Script script = new Script(s);
            script.executeOnce();
            this.body.startupScript = script;
        }
        catch (Exception e) {
            System.out.println("Error in resource " + personName);
            e.printStackTrace();
        }
    }

    public static Person newPersonDetailsFromResource(String personName) {
        Person p = new Person();
        p.setupDetailsFromResource(personName);
        return p;
    }

    public static Person newPersonFromResource(String personName) {
        Person p = new Person();
        p.body = new Body();
        p.environment = new Environment();
        p.setupDetailsFromResource(personName);
        p.setupParametersFromResource(personName);
        return p;
    }

    public static String[] getResourceNames() {
        IniReader ir = new IniReader(PERSON_FILE);
        return ir.getSectionHeaders();
    }
}

