/*
 * Decompiled with CFR 0.152.
 */
package phic;

import phic.Blood;
import phic.common.Organ;
import phic.common.VDouble;
import phic.common.VDoubleReadOnly;

public class Ovary
extends Organ {
    VDouble synthRateLH = new VDouble();
    VDouble synthRateFSH = new VDouble();
    VDouble releaseRateLH = new VDouble();
    VDouble releaseRateFSH = new VDouble();
    public VDouble poolLH = new VDouble();
    public VDouble poolFSH = new VDouble();
    public VDouble follicleStage = new VDoubleReadOnly(){

        public double get() {
            return Ovary.this.MsF + 10.0 * Ovary.this.SeF + 100.0 * Ovary.this.PrF + 1000.0 * Ovary.this.Sc1 + 1000.0 * Ovary.this.Sc2 + 10000.0 * Ovary.this.Lut1 + 100000.0 * Ovary.this.Lut2 + 1000000.0 * Ovary.this.Lut3 + 1.0E7 * Ovary.this.Lut4;
        }
    };
    public double clearanceLH = 14.0;
    public double clearanceFSH = 8.21;
    public double pitOestrogen;
    public double pitProgesterone;
    public double pitInhibin;
    public double MsF;
    public double SeF;
    public double PrF;
    public double Sc1;
    public double Sc2;
    public double Lut1;
    public double Lut2;
    public double Lut3;
    public double Lut4;

    public void tick() {
        this.gonadotropins();
        this.sexHormones();
    }

    void gonadotropins() {
        Blood blood = this.body.blood;
        int a = 8;
        double oe = blood.oestrogen.get();
        double pr = blood.progesterone.get();
        double ih = blood.inhibin.get();
        double elapsedDays = this.elapsedTime / 86400.0;
        double foe = this.fractionDecayPerMinute(0.0016534391534391536);
        this.pitOestrogen = foe * oe + (1.0 - foe) * this.pitOestrogen;
        double fpr = this.fractionDecayPerMinute(2.3946360153256704E-4);
        this.pitProgesterone = fpr * pr + (1.0 - fpr) * this.pitProgesterone;
        double fih = this.fractionDecayPerMinute(3.4722222222222224E-4);
        this.pitInhibin = fih * ih + (1.0 - fih) * this.pitInhibin;
        double oe_lh = 0.0959 * Math.pow(this.pitOestrogen, 8.0) / (Math.pow(3.6E-7, 8.0) + Math.pow(this.pitOestrogen, 8.0));
        this.synthRateLH.set((oe_lh + 0.0014) / (1.0 + this.pitProgesterone / 2.6E-8));
        this.releaseRateLH.set(3.0 * this.poolLH.get() * (1.0 + 2.4E7 * pr) / (1.0 + 8000000.0 * oe));
        this.poolLH.add((this.synthRateLH.get() - this.releaseRateLH.get()) * elapsedDays);
        blood.LH.add((this.releaseRateLH.get() / blood.PV.get() - blood.LH.get() * this.clearanceLH) * elapsedDays);
        this.synthRateFSH.set(4.4E-4 / (1.0 + this.pitInhibin / 1176.5));
        this.releaseRateFSH.set(45.0 * this.poolFSH.get() * (1.0 + 3.0E9 * pr) / (1.0 + 5.0E15 * oe * oe));
        this.poolFSH.add((this.synthRateFSH.get() - this.releaseRateFSH.get()) * elapsedDays);
        blood.FSH.add((this.releaseRateFSH.get() / blood.PV.get() - blood.FSH.get() * this.clearanceFSH) * elapsedDays);
    }

    void sexHormones2() {
    }

    void sexHormones() {
        Blood blood = this.body.blood;
        double elapsedDays = this.elapsedTime / 86400.0;
        double fsh = blood.FSH.get();
        double lh = blood.LH.get();
        this.MsF += elapsedDays * (4000.0 * fsh + (4500.0 * fsh - 0.077 * Math.pow(lh * 1000000.0, 0.6)) * this.MsF);
        this.SeF += elapsedDays * (0.077 * Math.pow(lh * 1000000.0, 0.6) * this.MsF + (0.006 * Math.pow(lh * 1000000.0, 0.6) - 8000.0 * lh) * this.SeF);
        this.PrF += elapsedDays * (8000.0 * lh * this.SeF - 0.045 * Math.pow(lh * 1000000.0, 0.6) * this.PrF);
        this.Sc1 += elapsedDays * (0.045 * Math.pow(lh * 1000000.0, 0.6) * this.PrF - 0.5 * this.Sc1);
        this.Sc2 += elapsedDays * (0.5 * this.Sc1 - 0.8 * this.Sc2);
        this.Lut1 += elapsedDays * (0.8 * this.Sc2 - 600000.0 * lh * this.Lut1);
        this.Lut2 += elapsedDays * (600000.0 * lh * this.Lut1 - 500000.0 * lh * this.Lut2);
        this.Lut3 += elapsedDays * (500000.0 * lh * this.Lut2 - 800000.0 * lh * this.Lut3);
        this.Lut4 += elapsedDays * (800000.0 * lh * this.Lut3 - 4000000.0 * lh * this.Lut4);
        double e = (48.0 + 0.6 * this.SeF + 0.8 * this.PrF + 4.5 * this.Lut4) * 1.0E-9;
        double p = (0.55 * this.Lut3 + 0.45 * this.Lut4) * 1.0E-9;
        double h = 270.0 + 2.5 * this.PrF + 2.0 * this.Lut2 + 10.0 * this.Lut3 + 14.0 * this.Lut4;
        blood.oestrogen.set(e);
        blood.progesterone.set(p);
        blood.inhibin.set(h);
    }

    public void reset() {
        this.Lut4 = 0.0;
        this.Lut3 = 0.0;
        this.Lut2 = 0.0;
        this.Lut1 = 0.0;
        this.Sc2 = 0.0;
        this.Sc1 = 0.0;
        this.PrF = 0.0;
        this.SeF = 0.0;
        this.MsF = 0.0;
        this.pitInhibin = 0.0;
        this.pitProgesterone = 0.0;
        this.pitOestrogen = 0.0;
    }
}

