/*
 * Decompiled with CFR 0.152.
 */
package phic;

import evaluator.MathExtra;
import phic.Blood;
import phic.common.PerfusedOrgan;
import phic.common.Quantity;
import phic.common.VDouble;
import phic.common.VDoubleReadOnly;

public class Muscle
extends PerfusedOrgan {
    public double EFFICIENCY = 0.243;
    public VDouble Cal = new VDouble();
    public VDouble O2Req = new VDouble();
    public VDouble O2Use = new VDouble();
    public VDouble O2Debt = new VDouble();
    public double maximumO2Extraction;
    public VDoubleReadOnly CO2;

    public Muscle() {
        this.addEqn("MuO2R", "18 \\times 10^{-5} \\cdot MuCal");
        this.addEqn("\\frac{d}{dt}O2Dbt", "MuO2R-MuO2U");
        this.addEqn("MuO2U", "min \\left( 0.8 \\cdot MuFlo \\cdot \\left( AO2 - 80 ml/L \\right), MuO2R + \\frac{O2Dbt}{dt} \\right)");
        this.addEqn("\\frac{d}{dt}BLac", "\\frac{1}{3} \\cdot 22.4 \\cdot \\left( MuO2R - MuO2U \\right)");
        this.maximumO2Extraction = 0.8;
        this.addEqn("MCO2", "ACO2 + \\frac{MuO2R \\cdot RQ}{MuFlo} ", "Muscle venous carbon dioxide concentration is calculated by Fick's law, given the rate of production");
        this.CO2 = new VDoubleReadOnly(){

            public double get() {
                return Muscle.this.body.blood.arterial.CO2.get() + Muscle.this.O2Req.get() * Muscle.this.body.RQ.get() / Muscle.this.flow.get();
            }
        };
        this.addEqn("\\Delta MuRes", "_{0.8}\\longrightarrow -sigmoid \\left(  \\Delta O2Dbt \\right)+6 \\Delta ^+ VCT + 30 \\times 10^{-6} \\cdot MuCal-0.05 \\cdot \\beta-adrenoreceptor");
        this.addEqn("VCO2", "ACO2 + \\frac{CO2Production}{CO} + 33.22 \\cdot ABC");
        this.addEqn("VO2", "AO2 - \\frac{O2Use}{CO}");
        this.addEqn("O2V", "NMO2U + MuO2U");
        this.addEqn("MuCal", "0.2389 \\cdot \\frac{Exer}{Efficiency \\approx 24.3\\% }");
        this.addEqn("Calories wasted", "0.2389 \\cdot \\frac{Exer}{Efficiency - 1} ");
    }

    public void tick() {
        this.regulateVessels();
        this.consumeOxygen();
        this.changeBlood();
        this.waitMinutes(1.0);
    }

    public void consumeOxygen() {
        this.Cal.set(this.totalCalsPerMinute());
        this.O2Req.set(1.8E-4 * this.Cal.get());
        double f = this.flow.get() * this.elapsedTime / 60.0;
        double supply = f * Math.max(this.body.blood.arterial.O2.get() - 0.08, 0.0);
        double oxygenConsumption = this.O2Req.get() * this.elapsedTime / 60.0;
        double need = oxygenConsumption + this.O2Debt.get();
        double oxygenUptake = Math.min(this.maximumO2Extraction * supply, need);
        this.O2Use.set(oxygenUptake / (this.elapsedTime / 60.0));
        this.O2Debt.add(oxygenConsumption - oxygenUptake);
        if (this.verbose) {
            this.inform("used " + Quantity.toString(this.O2Use.get()) + " O2" + ", need " + Quantity.toString(this.O2Debt.get()));
        }
        double lacprod = (oxygenConsumption - oxygenUptake) * 22.4 / 3.0;
        this.body.blood.lactate.addQ(lacprod);
    }

    public void regulateVessels() {
        double c = this.Cal.get();
        double vcterr = this.body.CVS.VCT.getError();
        double beta = this.body.blood.getDrugBinding("BETA_ADRENOCEPTOR") + this.body.brain.Symp.getError() / 10.0;
        double target = this.resistance.initialValue - 0.3 * MathExtra.sigmoid(this.O2Debt.getError() / 0.3) + Math.max(0.0, 6.0 * vcterr) - c * 3.0E-5 - 0.05 * beta;
        this.resistance.lowPassQuantity(target, this.fractionDecayPerMinute(0.8));
    }

    public void changeBlood() {
        double totalO2Use = this.body.NMO2Use.get() + this.O2Use.get();
        this.body.O2Use.set(totalO2Use);
        Blood b = this.body.blood;
        b.venous.O2.set(b.arterial.O2.get() - this.body.O2Use.get() / this.body.CVS.heart.CO.get());
        b.venous.CO2.set(b.arterial.CO2.get() + b.CarbonicProduction.get() + this.body.CO2Production.get() / this.body.CVS.heart.CO.get());
    }

    double totalCalsPerMinute() {
        return this.environment.Exer.get() * 0.2389 / this.EFFICIENCY;
    }

    double heatCalsPerMinute() {
        return this.environment.Exer.get() * 0.2389 * (1.0 / this.EFFICIENCY - 1.0);
    }
}

