/*
 * Decompiled with CFR 0.152.
 */
package phic;

import phic.Blood;
import phic.Current;
import phic.Environment;
import phic.common.Container;
import phic.common.EventLog;
import phic.common.Fluids;
import phic.common.Gas;
import phic.common.GasConc;
import phic.common.Organ;
import phic.common.Quantity;
import phic.common.UnitConstants;
import phic.common.VDouble;
import phic.common.VDoubleReadOnly;

public final class Lung
extends Organ {
    public VDouble DdSp = new VDouble();
    public VDouble TidV = new VDouble();
    public VDouble RespR = new VDouble();
    public VDouble H2Oloss = new VDouble();
    protected double AVentAir;
    public GasConc alvBlood;
    public Gas dpp;
    public Gas alvP;
    public Gas alvV;
    protected Container exhaledWater;
    public Gas.WithCO expired;
    public double pO2Accuracy;
    public double pCO2Accuracy;
    public boolean ventilate;
    public VDoubleReadOnly Vent;
    public VDoubleReadOnly AVent;
    public VDouble Oedema;
    protected Gas alvTmp;
    protected double Pa;
    private Container exhaled_example;
    private Container exhaled_temp;
    public double CO_SOLUBILITY;
    public double CO_AFFINITY;
    public double initialFractionEquilibration;
    protected double fractionEquilibration;
    public static final int DEFAULT_N_CYCLES = 5;
    public static final int MAX_EXTRA_CYCLES = 64;
    public double CO2Permeability;
    public double PtoDC;
    private double cardout;
    private double barp;
    public double tto2;
    public double ttco2;
    double ESTIMATE_DELTA;
    public VDouble Shunt;
    public double phase;
    public VDouble lungVolume;
    public VDouble FRC;
    public VDouble FVC;
    public VDouble TLV;
    public VDouble Pairway;
    public VDouble flow;
    static final int SPONTANEOUS = 0;
    static final int BIPAP = 1;
    int ventilationMode;
    public VDouble compliance;
    public double maximumCompliance;
    public VDouble airwayResistance;
    public VDouble IEratio;
    public double effectiveCompliance;
    public double iap;
    public double peakPressure;
    public double expiratoryResistanceRatio;
    public VDouble ITP;

    public Lung() {
        this.addEqn("APO2", "O2nomogram\\left(AO2,ACO2\\right)", "Blood partial pressures are calculated from the concentrations in blood. Blood affinity for oxygen is determined by pH and CO2.");
        this.addEqn("APCO2", "CO2nomogram\\left(ACO2,AO2\\right)", "Blood partial pressures are calculated from the concentrations in blood. Blood affinity for CO2 is mainly constant, but can depend on oxygenation.");
        this.alvBlood = new GasConc(null);
        this.dpp = new Gas();
        this.alvP = new Gas();
        this.alvV = new Gas();
        this.exhaledWater = new Container();
        this.addEqn("XO2", "AtO2-O2V/Vent");
        this.addEqn("XCO2", "AtCO2+CO2V/Vent");
        this.expired = new Gas.WithCO(){
            {
                this.O2 = new VDoubleReadOnly(){

                    public double get() {
                        double v = (this).Lung.this.Vent.get();
                        if (v == 0.0) {
                            return 0.0;
                        }
                        return (this).Lung.this.environment.air.O2.get() - (this).Lung.this.body.O2Use.get() / (this).Lung.this.Vent.get();
                    }
                };
                this.CO2 = new VDoubleReadOnly(){

                    public double get() {
                        double v = (this).Lung.this.Vent.get();
                        if (v == 0.0) {
                            return 0.0;
                        }
                        return (this).Lung.this.environment.air.CO2.get() + (this).Lung.this.body.CO2Production.get() / (this).Lung.this.Vent.get();
                    }
                };
            }
        };
        this.pO2Accuracy = 1.0E-4;
        this.pCO2Accuracy = 0.001;
        this.ventilate = true;
        this.addEqn("Vent", "RespR \\cdot TidV");
        this.Vent = new VDoubleReadOnly(){

            public double get() {
                return Lung.this.RespR.get() * Lung.this.TidV.get();
            }
        };
        this.addEqn("AVent", "\\left[ RespR \\cdot \\left(TidV-DdSp\\right) \\right]^+");
        this.AVent = new VDoubleReadOnly(){

            public double get() {
                return Math.max(Lung.this.RespR.get() * (Lung.this.TidV.get() - Lung.this.DdSp.get()), 0.0);
            }
        };
        this.Oedema = new VDouble();
        this.alvTmp = new Gas();
        this.addEqn("RH2O", "Vent \\cdot 0.804 ml/mmHgSVP \\cdot \\frac{svpcurve\\left(AmbT\\right)}{0.76} \\cdot \\left(1-Hum\\right) \\frac{273}{273+AmbT} ", "Rate of exhalation of water is the ventilation rate multiplied by the change in humidity content of exhaled air. The humiditygain depends on the saturated vapour pressure.");
        this.addEqn("AlvPO2", "AtO2 \\cdot \\left( BarP - svpcurve\\left(AmbT\\right)\\right)");
        this.addEqn("AlvPCO2", "AtCO2 \\cdot \\left( BarP - svpcurve\\left(AmbT\\right)\\right)");
        this.addEqn("AVentAir", "Avent \\frac{svpcurve(Temp)-Hum\\cdot svpcurve(AmbT)+BarP}{BarP}", "Alveolar effective inspired gas volume excluding water vapour");
        this.addEqn("POe \\rightarrow_{0.13/min}", "\\left[50\\cdot \\Delta LAP - 7 mmHg\\right]^2_0");
        this.addEqn("\\frac{d}{dt}Shunt", "2\\cdot\\left[POe-300ml\\right]^+");
        this.addEqn("AlBO2", "VO2 + \\frac{O2permeability}{CO} O2nomogram\\left(AlvPO2-VPO2, VPCO2\\right)");
        this.addEqn("AlBCO2", "VCO2 + \\frac{CO2permeability}{CO} CO2nomogram\\left(AlvPCO2-VPCO2, VPO2\\right)");
        this.addEqn("AO2", "Shunt \\cdot VO2 + \\left(1-Shunt\\right) AlBO2");
        this.addEqn("ACO2", "Shunt \\cdot VCO2 + \\left(1-Shunt\\right) AlBCO2");
        this.addEqn("\\frac{d}{dt}ACO", "0.01/min \\cdot \\left( AtCO\\cdot BarP \\cdot \\frac{COaffinity}{AlvPO2} - ACO \\right)");
        this.addEqn("XCO", "AtCO-\\frac{1}{AVent} \\frac{d}{dt}ACO");
        this.exhaled_example = Fluids.get("Water", 1.0);
        this.exhaled_temp = new Container();
        this.CO_SOLUBILITY = 0.9;
        this.CO_AFFINITY = 9.5;
        this.initialFractionEquilibration = 1.0;
        this.fractionEquilibration = 0.2;
        this.CO2Permeability = 1.2;
        this.PtoDC = 0.25;
        this.ESTIMATE_DELTA = 1.0E-9;
        this.Shunt = new VDouble();
        this.phase = 0.0;
        this.lungVolume = new VDouble();
        this.FRC = new VDouble();
        this.FVC = new VDouble();
        this.TLV = new VDouble();
        this.Pairway = new VDouble();
        this.flow = new VDouble();
        this.ventilationMode = 0;
        this.compliance = new VDouble();
        this.maximumCompliance = 0.08;
        this.airwayResistance = new VDouble();
        this.IEratio = new VDouble();
        this.addEqn("ITP", "- \\frac{Vlung-FRC}{\\left[Compl \\cdot 4 \\frac{TLV-Vlung}{TLV}+0.10\\right]}\\left(2-Uprt\\right)  - 5mmHg");
        this.addEqn("Paw", "(phase<IER) \\cdot \\frac{TidV}{Compl}\\frac{1}{1-e^{-\\frac{IER}{Compl\\cdot Raw \\cdot RespR}}");
        this.addEqn("Vaw", "\\frac{Paw-\\frac{Vlung-FRC}{Compl}}{Raw}");
        this.addEqn("\\frac{d}{dt}Vlung", "Vaw");
        this.peakPressure = 0.0052;
        this.expiratoryResistanceRatio = 1.3;
        this.ITP = new VDouble();
    }

    public void tick() {
        this.breathe();
        this.calculatePhase();
        this.volumes();
        this.body.blood.acidbase(this.elapsedTime);
        if (this.verbose) {
            this.inform(String.valueOf(Quantity.toString(this.body.blood.ABC)) + " M increase HCO3 & H+");
        }
    }

    public void breathe() {
        double asvp = Environment.getSVP(this.environment.Temp.get());
        double volumePerMinute = this.Vent.get() * (asvp / 0.76) * (1.0 - this.environment.Hum.get());
        double volume = volumePerMinute * this.elapsedTime / 60.0;
        double qH2Oloss = volume * 273.0 / (273.0 + this.environment.Temp.get()) * this.environment.H2OX.get();
        this.H2Oloss.set(qH2Oloss / (this.elapsedTime / 60.0));
        this.exhaled_example.volume.set(qH2Oloss);
        this.body.blood.withdrawVolExample_overwrite(this.exhaled_example, this.exhaled_temp);
        this.exhaledWater.add(this.exhaled_temp);
        if (this.body.getClock().dayChanged()) {
            this.body.eventLog.document(EventLog.FLUID_EVENT, "Expired", new Double(-this.exhaledWater.volume.get()));
            this.environment.rubbish.add(this.exhaledWater);
        }
        Blood blood = this.body.blood;
        this.alvBlood.setBlood(blood);
        this.alvBlood.set(blood.venous);
        boolean bl = this.ventilate = this.AVent.get() > 0.0;
        if (this.ventilate) {
            double dpH2O = Environment.getSVP(this.body.Temp.get()) - this.environment.Hum.get() * asvp;
            this.barp = this.environment.BarP.get();
            this.Pa = this.barp - asvp;
            this.AVentAir = this.AVent.get() * (dpH2O + this.barp) / this.barp;
            this.alvP.O2.set(this.environment.air.O2.get() * this.Pa);
            this.alvP.CO2.set(this.environment.air.CO2.get() * this.Pa);
        } else {
            this.AVentAir = this.FRC.get();
            this.alvTmp.set(this.alvP);
        }
        double target = Math.min(Math.max(50.0 * (this.body.CVS.heart.left.atrialP.getError() - 0.007), 0.0), 2.0);
        this.Oedema.lowPass(target, this.fractionDecayPerMinute(0.13));
        double shunt = this.Shunt.get();
        this.tto2 = 0.0;
        this.ttco2 = 0.0;
        this.alveolarPtoV();
        this.cardout = this.body.CVS.heart.CO.get() * (1.0 - shunt);
        int extraCycles = 0;
        double otto2 = 0.0;
        double ottco2 = 0.0;
        this.fractionEquilibration = this.initialFractionEquilibration;
        int i = 0;
        while (i < 5) {
            otto2 = this.tto2;
            ottco2 = this.ttco2;
            this.exchange();
            if (i == 4 && (Math.abs(this.alvP.O2.get() - this.alvBlood.PO2.get()) > this.pO2Accuracy || Math.abs(this.alvP.CO2.get() - this.alvBlood.PCO2.get()) > this.pCO2Accuracy)) {
                if (++extraCycles < 64) {
                    --i;
                }
                if (extraCycles > 4) {
                    this.fractionEquilibration *= 0.95;
                }
            }
            ++i;
        }
        if (!this.ventilate) {
            this.alvP.O2.set(this.alvTmp.O2.get() - this.tto2 * this.Pa / this.AVentAir * this.elapsedTime / 60.0);
            this.alvP.CO2.set(this.alvTmp.CO2.get() - this.ttco2 * this.Pa / this.AVentAir * this.elapsedTime / 60.0);
        }
        if (this.verbose) {
            double AaO2 = Math.abs(this.alvP.O2.get() - this.alvBlood.PO2.get());
            double AaCO2 = Math.abs(this.alvP.CO2.get() - this.alvBlood.PCO2.get());
            if (AaO2 > this.pO2Accuracy) {
                this.inform("A-a O2 = " + Quantity.toString(AaO2 * 1000.0) + " mmHg");
            } else if (AaCO2 > this.pCO2Accuracy) {
                this.inform("A-a CO2 = " + Quantity.toString(AaCO2 * 1000.0) + " mmHg");
                if (extraCycles > 0) {
                    this.inform("extra cycles = " + extraCycles);
                }
                if (extraCycles > 9) {
                    this.inform("last transfer = " + (this.tto2 - otto2));
                }
            }
            if (extraCycles > 0) {
                this.inform(String.valueOf(extraCycles) + " extra resp cycles");
            }
        }
        double dco = this.environment.air.CO.get() * this.environment.BarP.get() * this.CO_AFFINITY / this.alvP.O2.get() - blood.CO.get();
        double ttco = Math.max(0.0, dco) * this.CO2Permeability * 6.0 + Math.min(0.0, dco) * this.CO2Permeability * 0.65;
        double fdpm = this.fractionDecayPerMinute(0.01);
        double qco = ttco * fdpm;
        qco = Math.max(qco, -blood.CO.get());
        blood.CO.add(qco);
        double avent = this.AVent.get();
        if (avent != 0.0) {
            this.expired.CO.set(Math.max(0.0, this.environment.air.CO.get() - qco / fdpm / this.AVent.get()));
        }
        blood.arterial.O2.lowPass(Math.max(0.0, Math.min(1.0, this.alvBlood.O2.get() * (1.0 - (shunt += Math.max(0.0, this.Oedema.get() - 0.3) * 2.0)) + blood.venous.O2.get() * shunt)), this.fractionDecayPerMinute(0.7));
        blood.arterial.CO2.lowPass(Math.max(0.0, Math.min(1.0, this.alvBlood.CO2.get() * (1.0 - shunt) + blood.venous.CO2.get() * shunt)), this.fractionDecayPerMinute(0.7));
        if (this.verbose) {
            this.inform("Exchanged " + UnitConstants.formatValue(this.tto2, 19, false) + " O2, " + UnitConstants.formatValue(this.ttco2, 19, false) + " CO2");
        }
    }

    public void exchange() {
        this.alveolarPtoV();
        this.dpp.O2.set(this.alvP.O2.get() - this.alvBlood.PO2.get());
        this.dpp.CO2.set(this.alvP.CO2.get() - this.alvBlood.PCO2.get());
        double currentBloodPO2 = this.alvBlood.PO2.get();
        double currentBloodPCO2 = this.alvBlood.PCO2.get();
        double neededChangeO2Conc = this.estimateO2ConcChange(this.alvP.O2.get());
        double transO2 = this.dpp.O2.get() * this.fractionEquilibration / this.barp;
        double transCO2 = this.dpp.CO2.get() * this.CO2Permeability * this.fractionEquilibration / this.barp;
        transO2 = neededChangeO2Conc * this.cardout * 1.0 * this.fractionEquilibration;
        this.tto2 += transO2;
        this.ttco2 += transCO2;
        this.alvBlood.O2.set(this.alvBlood.O2.get() + transO2 / this.cardout);
        this.alvV.O2.set(this.alvV.O2.get() - transO2);
        this.alvBlood.CO2.set(this.alvBlood.CO2.get() + transCO2 / this.cardout);
        this.alvV.CO2.set(this.alvV.CO2.get() - transCO2);
        this.alveolarVtoP();
    }

    protected double estimateO2ConcChange(double ppO2to) {
        double oPO2 = this.alvBlood.PO2.get();
        this.alvBlood.O2.add(this.ESTIMATE_DELTA);
        double gradPO2 = (this.alvBlood.PO2.get() - oPO2) / this.ESTIMATE_DELTA;
        return (ppO2to - oPO2) / gradPO2;
    }

    protected double estimateCO2ConcChange(double ppCO2to) {
        double oPCO2 = this.alvBlood.PCO2.get();
        this.alvBlood.CO2.add(this.ESTIMATE_DELTA);
        double gradPCO2 = (this.alvBlood.PCO2.get() - oPCO2) / this.ESTIMATE_DELTA;
        return (ppCO2to - oPCO2) / gradPCO2;
    }

    private void alveolarPtoV() {
        this.alvV.O2.set(this.aPtoV(this.alvP.O2.get()));
        this.alvV.CO2.set(this.aPtoV(this.alvP.CO2.get()));
    }

    private void alveolarVtoP() {
        this.alvP.O2.set(this.aVtoP(this.alvV.O2.get()));
        this.alvP.CO2.set(this.aVtoP(this.alvV.CO2.get()));
    }

    protected double aPtoV(double p) {
        return p * this.AVentAir / this.barp;
    }

    protected double aVtoP(double v) {
        return v * this.barp / this.AVentAir;
    }

    public void reset() {
        super.reset();
        this.AVentAir = 0.0;
        this.alvBlood.empty();
        this.dpp.empty();
        this.alvP.empty();
        this.alvV.empty();
        this.alvTmp.empty();
        this.lungVolume.set(this.FRC.get());
        this.flow.set(0.0);
        this.phase = 0.0;
        this.ttco2 = 0.0;
        this.tto2 = 0.0;
        this.initialFractionEquilibration = 1.0;
    }

    private static final double min_abs(double a, double b) {
        return Math.abs(a) < Math.abs(b) ? a : b;
    }

    void calculatePhase() {
        this.phase += this.elapsedTime / 60.0 * this.RespR.get();
        this.phase -= (double)((int)this.phase);
    }

    void volumes() {
        if (Current.body.getClock().isSlowMode) {
            double frc = this.FRC.get();
            double v = this.lungVolume.get();
            double tlv = this.TLV.get();
            this.effectiveCompliance = this.compliance.get() * Math.min(1.0, (tlv - v) / tlv * 4.0 + 0.1);
            this.iap = (v - frc) / this.effectiveCompliance * (2.0 - this.environment.Uprt.get());
            this.ITP.set(-this.iap - 0.005);
            if (this.ventilationMode == 1) {
                double paw = this.TidV.get() / 70.0 * (double)(this.phase - this.IEratio.get() < 0.0 ? 1 : 0);
                this.Pairway.set(paw);
                this.flow.set((paw - this.iap) / this.airwayResistance.get());
                double et = this.elapsedTime > 2.0 ? 0.1 : this.elapsedTime;
                this.lungVolume.addLimited(this.flow.get() * et / 60.0);
            } else if (this.ventilationMode == 0) {
                double compl = this.effectiveCompliance;
                double effectiveResistance = this.airwayResistance.get() * (this.phase - this.IEratio.get() < 0.0 ? 1.0 : this.expiratoryResistanceRatio);
                double L = 1.0 - Math.exp(-1.0 / (compl * effectiveResistance * this.RespR.get()));
                double targetP = this.TidV.get() / compl / (1.0 - Math.exp(-this.IEratio.get() / (compl * effectiveResistance * this.RespR.get()))) * (double)(this.phase - this.IEratio.get() < 0.0 ? 1 : 0);
                double frate = Lung.fractionDecayPerMinute(0.9997, this.elapsedTime * 60.0);
                this.Pairway.lowPass(targetP, frate);
                double paw = this.Pairway.get();
                this.flow.set((paw - this.iap) / effectiveResistance);
                double et = this.elapsedTime > 2.0 ? 0.1 : this.elapsedTime;
                this.lungVolume.addLimited(this.flow.get() * et / 60.0);
            }
        } else {
            this.lungVolume.set(this.TidV.get() / 2.0 + this.FRC.get());
            this.flow.set(0.0);
            double hp = this.IEratio.get() * this.TidV.get() / this.compliance.get();
            this.ITP.set(this.ITP.initialValue - hp);
            this.Pairway.set(hp);
        }
    }
}

