/*
 * Decompiled with CFR 0.152.
 */
package phic;

import phic.Body;
import phic.Current;
import phic.common.Organ;
import phic.common.VDouble;
import phic.common.Variable;
import phic.drug.DrugContainer;
import phic.drug.DrugQuantity;

public class Liver
extends Organ {
    DrugContainer portalVein;
    public VDouble syntheticFunction = new VDouble();
    public VDouble metabolicFuction = new VDouble();
    protected double aminoAcidReserve = 0.5;
    public double obligatoryAABreakdown = 2.3E-4;
    public double maximumProteinSynthesisRate = 1.75E-6;
    public double aminoAcidQ = this.aminoAcidReserve;

    public Liver() {
        this.addEqn("\\frac{d}{dt}ExGlu", "0.9/min \\cdot \\left(PGlu-ExGlu\\right) \\frac{BV}{BV+EH2O}   - 10^{-9} \\cdot MBR -\\frac{d}{dt} Gly - \\frac{d}{dt} Fat", "Extracellular glucose is in equilibrium with plasma, is consumed by metabolism, and is buffered by the liver in glycogen and fat.");
        this.addEqn("\\frac{d}{dt}Fat", "\\left[ \\Delta ExGlu \\cdot 0.08/min \\left[ \\frac{Insul}{24\\cdot 10^{-12}}\\right]^+ \\right]^+  + 0.01 \\left[\\Delta Exglu\\right]^-+ \\left(\\frac{Insul}{24\\cdot 10^{-12}}<1\\right)\\cdot 0.0018 \\cdot (1 - \\frac{Insul}{24\\cdot 10^{-12}})", "Fat buffers extracellular glucose, dependent upon insulin levels.");
        this.addEqn("\\frac{d}{dt}Gly", "\\left[\\Delta ExGlu \\cdot 10^{-3} \\frac{Insul}{24\\cdot 10^{-12}}\\right]_0^{0.1} + \\Delta ExGlu \\cdot 0.1 - \\left[0.35mmol/min \\cdot \\frac{\\Delta Insul}{24\\cdot 10^{-12}}\\right]^- - \\left(Gly>0\\right)\\cdot 0.3/min\\left[2.5mM-ExGlu\\right]^+", "Glycogen buffers extracellular glucose, dependent upon insulin levels.");
        this.addEqn("RQ\\rightarrow_0.004", "1+0.29\\cdot \\left[\\frac{\\frac{d}{dt}Fat}{10^{-9}\\cdot MBR}\\right]^-");
        this.addEqn("\\frac{d}{dt}PPr", "- \\left[0.1/min \\Delta PPr + 0.6 \\times 10^{-3} \\cdot Fever\\right]^+  - 0.05 \\left[ \\Delta PPr \\right]^-  ", "Synthesis and breakdown of plasma proteins regulates their concentration.");
        this.addEqn("\\frac{d}{dt}PUN", "1.3 \\frac{d}{dt}PPr + obligatoryAABreakdown \\approx 0.23\\times 10^{-3} - PUN \\cdot GFR \\cdot \\frac{\\sqrt{UVol}}{1.5}");
        this.addEqn("\\frac{d}{dt}PCreat", "0.01\\frac{d}{dt}PPr + 0.1 obligatoryAABreakdown - PCreat \\cdot GFR");
    }

    public void tick() {
        this.portalVein = Current.body.gitract.portalVein;
        this.aminoAcidQ += this.portalVein.prot.getQ();
        this.portalVein.prot.setC(0.0);
        this.metaboliseDrugs(this.portalVein, null);
        this.body.blood.add(this.portalVein);
        this.correctPlasmaProtein();
        this.sugars();
        this.metaboliseDrugs(this.body.blood, this.body.viscera.flow);
    }

    public void reset() {
        this.aminoAcidQ = this.aminoAcidReserve;
    }

    void sugars() {
        Body b = this.body;
        criticalPeriod.enter();
        double glucoseUseRate = 1.0E-9 * b.MBR.get();
        double molesGlucoseUse = glucoseUseRate * this.elapsedTime / 60.0;
        b.ecf.glucose.addQ(-molesGlucoseUse);
        b.ecf.addWater(6.0 * molesGlucoseUse * 0.018);
        double R = (b.blood.glucose.getC() - b.ecf.glucose.getC()) * this.fractionPerMinute(0.9);
        double Q = (R /= b.blood.volume.get() + b.ecf.volume.get()) * b.blood.volume.get() * b.ecf.volume.get();
        b.blood.glucose.moveTo(b.ecf.glucose, Q);
        double effectiveInsulin = (b.blood.Insul.get() + b.blood.getDrugBinding("INSULIN_EFFECT")) / 2.4E-11;
        double gluConcDecrease = 0.0;
        double glucErr = b.ecf.glucose.getError();
        gluConcDecrease = glucErr > 0.0 ? glucErr * this.fractionDecayPerMinute(0.1 * Math.max(Math.min(0.01 * effectiveInsulin, 1.0), 0.0)) : 0.1 * glucErr * this.fractionDecayPerMinute(0.3);
        if (effectiveInsulin < 0.9) {
            gluConcDecrease -= 3.5E-4 * (0.9 - effectiveInsulin) * this.elapsedTime / 60.0;
        }
        gluConcDecrease += 1.0E-4 * Math.max(0.0, Math.min((effectiveInsulin - 1.0) * 0.1, 1.0)) * this.elapsedTime / 60.0;
        if (glucErr < -0.0015) {
            gluConcDecrease += (glucErr + 0.0015) * 0.33 * this.elapsedTime / 60.0 * Math.min(1.0, Math.max(0.0, 1.0 / (effectiveInsulin * effectiveInsulin)));
        }
        this.gluStore(gluConcDecrease, b.Glycogen);
        double fatBreakdownRate = 0.0;
        glucErr = b.ecf.glucose.getError();
        gluConcDecrease = glucErr > 0.0 ? glucErr * this.fractionDecayPerMinute(0.08 * Math.min(effectiveInsulin * 10.0, 1.0)) : glucErr * this.fractionDecayPerMinute(0.01);
        if (effectiveInsulin < 1.0) {
            gluConcDecrease -= 1.7999999999999998E-4 * (1.0 - effectiveInsulin) * this.elapsedTime / 60.0;
        }
        this.gluStore(gluConcDecrease, b.Fat.mass);
        fatBreakdownRate = -gluConcDecrease * this.body.ecf.volume.get() * 179.0 / this.elapsedTime * 60.0;
        double glycogenConversionRate = Math.max(Math.min(this.body.Glycogen.getError() * 2.5E-4, this.body.Glycogen.get()), -this.body.Fat.mass.get());
        this.body.Glycogen.add(-glycogenConversionRate * this.elapsedTime / 60.0);
        this.body.Fat.mass.add(glycogenConversionRate * this.elapsedTime / 60.0);
        VDouble ket = this.body.blood.ketones;
        ket.add(Math.max(-ket.get(), -2.0 * this.body.blood.Insul.getError() / 2.4E-9 * this.fractionDecayPerMinute(0.001)));
        double fracFat = Math.min(1.0, Math.max(0.0, fatBreakdownRate / glucoseUseRate));
        this.body.RQ.lowPassQuantity(1.0 - 0.29 * fracFat, this.fractionDecayPerMinute(0.004));
        criticalPeriod.exit();
    }

    void correctPlasmaProtein() {
        Body b = this.body;
        double proteinExcess = b.blood.PPr.getError();
        if (proteinExcess > 0.0) {
            double breakdown = this.fractionDecayPerMinute(0.1) * proteinExcess;
            b.blood.setPlasma(b.blood.prot, b.blood.PPr.get() - breakdown);
            this.aminoAcidQ += breakdown;
        } else {
            double synthesise = -this.fractionDecayPerMinute(0.05) * (proteinExcess + 6.0E-4 * this.body.brain.fever.get());
            synthesise = Math.min(synthesise, this.aminoAcidQ);
            synthesise = Math.min(synthesise, this.maximumProteinSynthesisRate * this.elapsedTime / 60.0);
            b.blood.setPlasma(b.blood.prot, b.blood.PPr.get() + synthesise);
            this.aminoAcidQ -= synthesise;
        }
        double convert = Math.min(1.0E-4 * this.elapsedTime / 60.0, Math.max(0.0, this.aminoAcidQ - this.aminoAcidReserve));
        if (this.verbose && convert > 0.0) {
            this.inform("protein destroyed " + 1000.0 * convert / this.elapsedTime * 60.0 + " mOsm/min");
        }
        b.blood.PUN.add(1.3 * convert + this.obligatoryAABreakdown * this.elapsedTime / 60.0);
        b.blood.PCreat.add(0.01 * convert + this.obligatoryAABreakdown * 0.01 * this.elapsedTime / 60.0);
        this.aminoAcidQ -= convert;
    }

    public void metaboliseDrugs(DrugContainer d, VDouble flow) {
        int i = 0;
        while (i < d.drugqs.size()) {
            DrugQuantity dq = (DrugQuantity)d.drugqs.get(i);
            double hmet = dq.getProperty("HEPATIC_METABOLISM");
            if (hmet > 0.0) {
                double q = flow != null ? this.body.viscera.flow.get() * dq.getC() * hmet * this.elapsedTime / 60.0 : dq.getQ() * hmet;
                dq.addQ(-q);
            }
            ++i;
        }
    }

    public void gluStore(double decr, Variable store) {
        Body b = Current.body;
        double masseq = decr * b.ecf.volume.get() * 179.0;
        if (masseq < 0.0) {
            masseq = Math.max(masseq, -0.1 * this.elapsedTime / 60.0 * store.get());
            decr = masseq / b.ecf.volume.get() / 179.0;
        }
        store.set(store.get() + masseq);
        b.ecf.glucose.setC(b.ecf.glucose.getC() - decr);
    }
}

