/*
 * Decompiled with CFR 0.152.
 */
package phic;

import phic.Blood;
import phic.common.Container;
import phic.common.Fluids;
import phic.common.PerfusedOrgan;
import phic.common.VDouble;
import phic.common.VDoubleReadOnly;
import phic.drug.DrugContainer;
import phic.drug.DrugQuantity;

public class Kidney
extends PerfusedOrgan {
    public VDouble MacDn = new VDouble();
    protected static final double GLUCOSE_TRANSPORT_MAXIMUM = 0.00225;
    public VDouble GFR = new VDouble();
    public Container glomerulus;
    public Container PCT;
    public Container Loop;
    public Container DCT;
    public Container urine;
    public VDouble urinaryKetones;
    protected double urKetQ;
    public VDouble glomerularLeak;
    protected static final Container IDEAL_FLUID = Fluids.get("Ideal", 1.0);
    Blood blood;
    private double urineflowrate;
    public double maximumMedullaOsmolarity;
    public double adhPotency;
    public boolean doProx;
    public boolean doDuct;
    public boolean doDist;
    public boolean doHenle;
    public VDouble bicarbReabsRate;
    public VDouble HexcretionRate;
    public double RENAL_PH_SET_POINT;
    protected double angiotensinFraction;
    private DrugContainer proxAbsorbTemp;
    private DrugContainer filtertmp;
    public VDoubleReadOnly urineFlow;
    public VDouble overallRenalFunction;
    public VDouble tubularFunction;

    public Kidney() {
        this.addEqn("\\frac{d}{dt}ReTub", "0.01/min \\left[ReFlo-200ml/min\\right]^- - 0.0005/min \\Delta ReTub", "Renal tubular function becomes impaired with low perfusion, but improves again slowly");
        this.glomerulus = new DrugContainer();
        this.PCT = new DrugContainer();
        this.Loop = new DrugContainer();
        this.DCT = new DrugContainer();
        this.urine = new DrugContainer();
        this.urinaryKetones = new VDouble();
        this.urKetQ = 0.0;
        this.glomerularLeak = new VDouble();
        this.urineflowrate = 0.0;
        this.maximumMedullaOsmolarity = 5.0;
        this.adhPotency = 1.0;
        this.doProx = true;
        this.doDuct = true;
        this.doDist = true;
        this.doHenle = true;
        this.addEqn("\\frac{d}{dt}ductH2O", "\\left[1-\\frac{4 \\times 10^{-13}}{ADH}\\right]_0^1 \\left(5 M \\cdot (1+loopReabsorption) - ductOsm\\right)");
        this.addEqn("\\frac{d}{dt}BKet", "\\left[-0.83 \\times 10^9 \\cdot \\Delta Insul\\right]^+   - 0.01 \\frac{GFR}{BV} \\Delta BKet  ", "Ketones are produced when insulin is low, and are passively excreted by the kidney");
        this.addEqn("\\frac{d}{dt}UKet", "0.01 \\frac{GFR}{UVol} \\Delta BKet");
        this.bicarbReabsRate = new VDouble();
        this.HexcretionRate = new VDouble();
        this.RENAL_PH_SET_POINT = 7.4;
        this.proxAbsorbTemp = new DrugContainer();
        this.filtertmp = new DrugContainer();
        this.urineFlow = new VDoubleReadOnly(){

            public double get() {
                return Kidney.this.urineflowrate;
            }
        };
        this.overallRenalFunction = new VDouble();
        this.tubularFunction = new VDouble();
    }

    public void tick() {
        this.blood = this.body.blood;
        this.autoregulate();
        this.doNephron();
        this.hormones();
        this.waitMinutes(1.0);
    }

    void autoregulate() {
        double deficit = Math.max(0.0, 0.2 - this.flow.get());
        this.tubularFunction.lowPass(1.0, this.fractionDecayPerMinute(5.0E-4));
        this.tubularFunction.addQuantity(-0.01 * this.elapsedTime / 60.0 * deficit);
    }

    void doNephron() {
        Container c = this.getGlom(this.blood);
        c.add(this.glomerulus);
        c.withdrawVol_overwrite(Math.min(1.0E-8, 0.01 * c.volume.get()), this.glomerulus);
        c = this.doProx(c);
        c.add(this.PCT);
        c.withdrawVol_overwrite(Math.min(1.0E-8, 0.01 * c.volume.get()), this.PCT);
        c = this.doHenle(c);
        c.add(this.Loop);
        c.withdrawVol_overwrite(Math.min(1.0E-8, 0.01 * c.volume.get()), this.Loop);
        c = this.doDist(c);
        c.add(this.DCT);
        c.withdrawVol_overwrite(Math.min(1.0E-8, 0.01 * c.volume.get()), this.DCT);
        this.body.bladder.add(this.urine);
        this.urine.add(this.doDuct(c));
        double uvol = this.urine.volume.get();
        this.urineflowrate = uvol / (this.elapsedTime / 60.0);
        if (uvol > 0.0) {
            this.urinaryKetones.set(this.urKetQ / uvol);
        } else {
            this.urinaryKetones.set(0.0);
        }
    }

    void hormones() {
    }

    protected Container doDuct(Container duct) {
        if (this.doDuct) {
            double adh = Math.max(this.blood.ADH.get() + this.blood.getDrugBinding("ADH_RECEPTOR"), 0.0);
            double fraction = Math.max(0.0, Math.min(1.0, 1.0 - this.adhPotency * 4.0E-13 / adh));
            if (this.verbose) {
                this.inform("osmosis " + fraction + " from duct");
            }
            double medullaOsmolarity = this.maximumMedullaOsmolarity * Math.max(0.05, 1.0 + this.blood.getDrugBinding("LOOP_REABSORPTION"));
            duct.osmose(this.blood, medullaOsmolarity, fraction);
            DrugContainer dduct = (DrugContainer)duct;
            DrugQuantity dq2 = null;
            for (DrugQuantity dq2 : dduct.drugqs) {
                double reabs = dq2.getProperty("RENAL_REABSORPTION");
                if (reabs > 0.0) {
                    dq2.moveTo(this.blood.findMatchingDrug(dq2), reabs * dq2.getQ());
                }
                if (!(reabs < 0.0)) continue;
                DrugQuantity bloodq = this.blood.findMatchingDrug(dq2);
                bloodq.moveTo(dq2, -reabs * bloodq.get() * this.flow.get() * this.elapsedTime / 60.0);
            }
            double excretedKetones = Math.max(this.blood.ketones.getError(), 0.0) * this.GFR.get() * 0.01 * this.elapsedTime / 60.0;
            this.blood.ketones.add(-excretedKetones / this.blood.volume.get());
            this.urKetQ = excretedKetones;
        }
        return duct;
    }

    protected Container doDist(Container dist) {
        if (this.doDist) {
            double aldo = Math.max(this.blood.Aldo.get() + this.blood.getDrugBinding("ALDOSTERONE_RECEPTOR"), 0.0);
            double pump = Math.min(aldo / 3.2E-10, 1.0) * Math.min(dist.Na.getQ() / 2.0, this.blood.K.getC() * this.flow.get() * this.elapsedTime / 60.0);
            dist.Na.moveTo(this.blood.Na, 2.0 * pump);
            this.blood.K.moveTo(dist.K, pump);
            double water = Math.max(0.0, dist.volume.get() - 0.013 * this.elapsedTime / 60.0);
            dist.increaseVolume(-water);
            this.blood.increaseVolume(water);
            this.HexcretionRate.set(Math.min(1.0E-12, Math.max(0.0, 8.0E-6 * this.blood.PHy.getError())));
            this.blood.H.moveTo(dist.H, this.HexcretionRate.get() * this.elapsedTime / 60.0);
            this.bicarbReabsRate.lowPass(Math.min(1.11, 1.0 - 2.0 * this.blood.pH.getError()), 2.0E-4);
            double reabsFrac = this.bicarbReabsRate.get();
            dist.bicarb.moveTo(this.blood.bicarb, Math.max(dist.bicarb.getQ() * reabsFrac, 0.0));
            this.blood.bicarb.addQ(5.0E-5 * Math.max(0.0, reabsFrac - 1.0) * this.elapsedTime / 60.0);
            dist.Na.moveTo(this.blood.Na, dist.Na.getQ() * 0.9 * this.angiotensinFraction * this.angiotensinFraction);
            dist.Na.moveTo(this.blood.Na, dist.Na.getQ() * 0.9 * this.angiotensinFraction * this.angiotensinFraction * this.angiotensinFraction);
            dist.K.moveTo(this.blood.K, (1.0 - Math.max(0.05, Math.min(aldo / 1.6E-10, 0.99))) * dist.K.getQ());
        }
        return dist;
    }

    protected Container doHenle(Container henle) {
        if (this.doHenle) {
            double loopFrac = Math.min(1.0, Math.max(0.0, 0.8 + this.blood.getDrugBinding("LOOP_REABSORPTION")));
            henle.Na.moveTo(this.blood.Na, (loopFrac *= this.tubularFunction.get()) * henle.Na.getQ());
            henle.K.moveTo(this.blood.K, loopFrac * henle.K.getQ());
            henle.K.moveTo(this.blood.K, 1.0 * loopFrac * henle.K.getQ());
            double waterReabs = Math.max(0.0, henle.volume.get() - 0.02 * this.elapsedTime / 60.0);
            henle.increaseVolume(-waterReabs);
            this.blood.increaseVolume(waterReabs);
            this.MacDn.set(henle.Na.getC());
        }
        return henle;
    }

    protected Container doProx(Container prox) {
        if (this.doProx) {
            prox.glucose.moveTo(this.blood.glucose, Math.min(0.00225 * this.elapsedTime / 60.0, prox.glucose.getQ()));
            double angiotensin = this.blood.getDrugBinding("ANGIOTENSIN_II_RECEPTOR") + this.blood.AngII.get();
            angiotensin = Math.max(angiotensin, 0.0);
            double fraction = Math.max(Math.min(angiotensin * 1.0E11, 1.0), 0.0);
            this.angiotensinFraction = fraction = Math.min(fraction, 0.99);
            double reabsorbVolume = (fraction *= this.tubularFunction.get()) * prox.volume.get();
            prox.withdrawFracII_overwrite(IDEAL_FLUID, fraction, this.proxAbsorbTemp);
            this.blood.add(this.proxAbsorbTemp);
        }
        return prox;
    }

    protected Container getGlom(Container renArtery) {
        double ap = this.body.CVS.APL.get();
        double tmp = this.body.CVS.VCT.get();
        double pglom = ap * ap / 0.069 * Math.max(this.resistance.get() - 0.02, 0.01) / this.resistance.get() / (1.0 + 0.4 * Math.max(0.0, tmp * tmp * tmp - 1.0));
        if (ap < 0.08) {
            pglom *= Math.max(0.0, (ap - 0.07) / 0.01);
        }
        double gfr = (pglom - this.body.CVS.PCOP.get()) * this.flow.get() * 1.8;
        gfr = Math.max(this.overallRenalFunction.get() * gfr, 0.0);
        renArtery.ultraFiltrate_overwrite(gfr / this.blood.AHct() * this.elapsedTime / 60.0, this.filtertmp);
        double leakVol = this.glomerularLeak.get();
        if (leakVol > 0.0) {
            Container leak = renArtery.withdrawVol(leakVol / this.blood.AHct() * this.elapsedTime / 60.0);
            renArtery.add(leak.filterSolids());
            this.filtertmp.add(leak);
        }
        this.GFR.set(gfr);
        return this.filtertmp;
    }

    public void reset() {
        this.glomerulus.empty();
        this.PCT.empty();
        this.Loop.empty();
        this.DCT.empty();
        this.urine.empty();
        this.bicarbReabsRate.set(0.986);
        this.HexcretionRate.set(1.0E-8);
        this.urinaryKetones.set(0.0);
        this.proxAbsorbTemp.empty();
        this.urineflowrate = 0.001;
    }
}

