/*
 * Decompiled with CFR 0.152.
 */
package phic;

import phic.Blood;
import phic.Current;
import phic.common.Container;
import phic.common.EventLog;
import phic.common.UnitConstants;
import phic.drug.DrugContainer;
import phic.gui.PhicApplication;

public class IntravenousInfusion
extends DrugContainer {
    protected Blood blood;
    public double rate = 0.002;
    private boolean running = false;
    public boolean empty = false;
    public boolean autoRefill = false;
    public int defaultStartVolume = 1;
    protected double startVolume = this.defaultStartVolume;
    protected DrugContainer sample;

    public IntravenousInfusion(Blood blood) {
        this.blood = blood;
    }

    public IntravenousInfusion(Blood blood, Container fluid, double rate) {
        this(blood);
        this.add(fluid);
        this.rate = rate;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void start() {
        if (!this.running) {
            PhicApplication.markEvent("IVI on");
        }
        this.running = true;
        this.startVolume = this.volume.get();
        if (this.startVolume > 0.0) {
            this.sample = (DrugContainer)this.withdrawVol(1.0E-4);
        }
    }

    public void stop() {
        if (this.running) {
            PhicApplication.markEvent("IVI off");
        }
        this.running = false;
        double infusedVolume = this.startVolume - this.volume.get();
        Current.body.eventLog.document(EventLog.FLUID_EVENT, "Infused", new Double(infusedVolume));
        Current.body.message("Infused " + UnitConstants.formatValue(infusedVolume, 4, false));
    }

    public void tick(double time) {
        if (this.volume.get() == 0.0) {
            if (this.autoRefill && this.sample != null) {
                this.stop();
                this.add(this.sample.createMore(this.defaultStartVolume));
                this.sample = null;
                this.start();
            } else {
                this.empty = true;
                this.running = false;
            }
        } else {
            Container c = this.withdrawVol(this.rate * time / 60.0);
            this.blood.addWithoutO2(c);
        }
    }

    public double getStartVolume() {
        return this.startVolume;
    }
}

