/*
 * Decompiled with CFR 0.152.
 */
package phic;

import phic.Chamber;
import phic.common.Curve;
import phic.common.PerfusedOrgan;
import phic.common.VDouble;
import phic.common.VDoubleReadOnly;

public final class Heart
extends PerfusedOrgan {
    public VDouble SV = new VDouble();
    public VDouble rate = new VDouble();
    public VDoubleReadOnly CO;
    public double phase;
    public VDouble ventricularForceDifference;
    public VDouble rvPOverload;
    public VDouble lvPOverload;
    public Curve.TwoGradients venousCompliance;
    public double accumulationConstant;
    public double lvsv;
    public double rvsv;
    public VDoubleReadOnly CI;
    double preVtHeartRate;
    boolean inVT;
    public VDouble pericVol;
    public double O2supply;
    public VDouble VO2;
    public VDouble mitralStenosis;
    public VDouble aorticStenosis;
    public VDouble aorticRegurg;
    public VDouble mitralRegurg;
    public VDoubleReadOnly ischaemia;
    public double pVE;
    public boolean isEctopic;
    public Chamber left;
    public Chamber right;
    public VDouble LVH;

    public Heart() {
        this.addEqn("CO", "SV \\cdot HR");
        this.CO = new VDoubleReadOnly(){

            public double get() {
                return Heart.this.SV.get() * Heart.this.rate.get();
            }
        };
        this.phase = 0.0;
        this.ventricularForceDifference = new VDouble();
        this.rvPOverload = new VDouble();
        this.lvPOverload = new VDouble();
        this.addEqn("RAP", "venousCompliance^{-1}\\left(\\Delta BV\\right)  \\cdot \\frac{3-Uprt}{2} \\left(1+\\frac{Symp}{2}\\right)  + 0.01 \\cdot \\Delta ITP + 100mmHg/L \\cdot \\left[\\Delta Peric\\right]^+ + 500\\cdot venoussmoothmuscle  - ventricularForceDifference");
        this.addEqn("ventricularForceDifference", "1.0 \\cdot \\left( RVSV-LVSV \\right)");
        this.addEqn("LAP", "venousCompliance^{-1}\\left(\\Delta BV\\right)  \\cdot \\frac{3-Uprt}{2} \\left(1+\\frac{Symp}{2}\\right)  + 0.005 \\cdot \\Delta ITP + 100mmHg \\cdot \\left[\\Delta Peric\\right]^+ + 500\\cdot venoussmoothmuscle + 10mmHg \\cdot MiR +ventricularForceDifference");
        this.addEqn("LVSP", "SysBP \\cdot \\frac{ 1 }{1.12 - AoS }");
        this.addEqn("LVEDV", "diaCompliance\\left(LAP+10mmHg\\cdot AR\\right) \\left(1-e^{-\\frac{60\\cdot 5 \\cdot  \\left( 1-MiS\\right) \\left(1+0.3\\cdot AoR\\right)}{HR\\cdot LVstiffness}} \\right)\\left(1.15-10\\cdot Peric\\right) ");
        this.addEqn("LVESV", "LVEDV+SV");
        this.addEqn("LVEDP", "diaCompliance^{-1}\\left(LVESV\\right)", "Minimum pressure generated during relaxation of the ventricle");
        this.addEqn("LVSW", "SV \\cdot \\left(AP-LVEDP\\right)");
        this.addEqn("LVEF", "\\frac{SV}{LVEDV}");
        this.addEqn("RVSP", "SPAP");
        this.addEqn("RVEDV", "diaCompliance\\left(RAP\\right) \\left(1-e^{-\\frac{60}{RVstiffness \\cdot HR}}\\right)");
        this.addEqn("RVESV", "RVEDV+SV");
        this.addEqn("RVEDP", "diaCompliance^{-1}\\left(RVESV\\right)", "Minimum pressure generated during relaxation of the ventricle");
        this.addEqn("RVSW", "SV \\cdot \\left(MPAP-RVEDP\\right)");
        this.addEqn("RVEF", "\\frac{SV}{RVEDV}");
        this.addEqn("SV", "\\frac{1}{2}\\left(\\left[  starling\\left(LVEDV\\right) + 15ml \\cdot Symp + betaadrenoceptor - 150ml\\left[ 6.9 -pH\\right]^+ - 1.5\\left[LVSP-220mmHg\\right]^+ \\right]_{5ml} \\cdot \\frac{2-AoR-miR}{2}+ \\left[ starling\\left(RVEDV\\right)+15ml\\cdot Symp+betaadrenoceptor-120ml\\cdot\\left[7-pH\\right]^+ - 1.4\\left[RVSP-50mmHg\\right]^+  \\right]_{5ml} \\right)");
        this.venousCompliance = new Curve.TwoGradients();
        this.accumulationConstant = 1.0;
        this.addEqn("CI", "\\frac{CO}{SA}");
        this.CI = new VDoubleReadOnly(){

            public double get() {
                return Heart.this.CO.get() / Heart.this.body.skin.area.get();
            }
        };
        this.preVtHeartRate = Double.NaN;
        this.inVT = false;
        this.pericVol = new VDouble();
        this.VO2 = new VDouble();
        this.mitralStenosis = new VDouble();
        this.aorticStenosis = new VDouble();
        this.aorticRegurg = new VDouble();
        this.mitralRegurg = new VDouble();
        this.addEqn("HtVO2", "0.048 \\cdot CO \\cdot \\left(AP-RAP\\right)");
        this.addEqn("HtIsc", "\\left[ HtVO2-HtFlo\\cdot AO2 \\cdot \\left(\\frac{72}{HR}\\right)^2\\right]^+", "Cardiac ischaemia is calculated by its oxygen usage minus its oxygen supply. The coronary filling varies with heart rate as well as blood pressure.");
        this.ischaemia = new VDoubleReadOnly(){

            public double get() {
                return Math.max(0.0, Heart.this.VO2.get() - Heart.this.O2supply);
            }
        };
        this.pVE = 0.0;
        this.left = new Chamber();
        this.right = new Chamber();
        this.LVH = new VDouble();
        this.resetCompliances();
    }

    public void tick() {
        this.calculatePerfusion();
        this.calculateValves();
        this.calculateSV();
        this.calculateHR();
        if (this.body.getClock().isSlowMode) {
            this.calculatePhase();
        }
        this.calculateRemodelling();
        this.waitMinutes(1.0);
    }

    void calculateSV() {
        double symp = this.body.brain.Symp.getError();
        this.lvsv = Math.max(0.005, this.left.starling.getValue(this.left.diaV.get()) + 0.015 * symp + this.body.blood.getDrugBinding("BETA_ADRENOCEPTOR") + 0.15 * Math.min(this.body.blood.pH.get() - 6.9, 0.0) - this.lvPOverload.get()) * Math.max(0.0, 1.0 - this.aorticRegurg.get() - this.mitralRegurg.get());
        this.rvsv = Math.max(0.005, this.right.starling.getValue(this.right.diaV.get()) + 0.015 * symp + this.body.blood.getDrugBinding("BETA_ADRENOCEPTOR") + 0.12 * Math.min(this.body.blood.pH.get() - 7.0, 0.0) - this.rvPOverload.get());
        this.lvPOverload.lowPass(1.5 * Math.max(this.left.sysP.get() - 0.22, 0.0), 0.01);
        this.rvPOverload.lowPass(1.4 * Math.max(this.right.sysP.get() - 0.05, 0.0), 0.01);
        double bvError = Math.max(this.body.blood.volume.getError(), -3.0);
        double ventForceDiff = this.ventricularForceDifference.get();
        double rap = this.venousCompliance.getInverse(bvError) * (1.5 - this.environment.Uprt.get() * 0.5) * (1.0 + symp * 0.5) + this.body.lungs.ITP.getError() * 0.01 + this.body.blood.getDrugBinding("VENOUS_SMOOTH_MUSCLE") * 500.0 + -ventForceDiff + 0.1 * Math.max(0.0, this.pericVol.getError());
        double lap = this.venousCompliance.getInverse(bvError) * (1.5 - this.environment.Uprt.get() * 0.5) * (1.0 + symp * 0.5) + this.body.lungs.ITP.getError() * 0.005 + this.body.blood.getDrugBinding("VENOUS_SMOOTH_MUSCLE") * 500.0 + ventForceDiff + 0.1 * Math.max(0.0, this.pericVol.getError()) + 0.01 * this.mitralRegurg.get();
        double ecfraction = 1.0 - this.pVE * 0.5;
        this.lvsv *= ecfraction;
        this.rvsv *= ecfraction;
        double sv = Math.max((this.lvsv + this.rvsv) / 2.0, 0.0);
        this.ventricularForceDifference.lowPass(this.accumulationConstant * (this.rvsv - this.lvsv) - 0.1 * ventForceDiff, this.fractionDecayPerMinute(0.05));
        this.right.atrialP.lowPass(Math.max(0.0, rap), this.fractionDecayPerMinute(0.4));
        this.left.atrialP.lowPass(Math.max(0.0, lap), this.fractionDecayPerMinute(0.4));
        this.SV.set(sv);
        this.left.setStrokeVolume(sv);
        this.left.sysP.set(this.body.CVS.SysBP.get() * (1.0 / (1.12 - this.aorticStenosis.get())));
        this.left.setMeanP(this.body.CVS.AP.get());
        this.left.tick();
        this.right.setStrokeVolume(sv);
        this.right.sysP.set(this.body.CVS.SysPAP.get());
        this.right.setMeanP(this.body.CVS.MPAP.get());
        this.right.tick();
    }

    void calculateHR() {
        if (this.pVE > 0.99) {
            if (!this.inVT) {
                this.preVtHeartRate = this.rate.get();
                this.rate.set(200.0);
                this.inVT = true;
            }
        } else if (this.inVT) {
            if (Double.isNaN(this.preVtHeartRate)) {
                this.preVtHeartRate = this.rate.initialValue;
            }
            if (this.preVtHeartRate < this.rate.minimum) {
                this.preVtHeartRate = this.rate.minimum;
            }
            if (this.preVtHeartRate > 150.0) {
                this.preVtHeartRate = 150.0;
            }
            this.rate.set(this.preVtHeartRate);
            this.preVtHeartRate = Double.NaN;
            this.inVT = false;
        }
        double r = this.rate.get();
        this.left.setRate(r);
        this.right.setRate(r);
    }

    public void reset() {
        super.reset();
        this.phase = 0.0;
        this.resetCompliances();
        this.left.reset();
        this.right.reset();
        this.lvsv = this.rvsv = this.SV.initialValue;
        this.ventricularForceDifference.set(0.0);
        this.O2supply = 0.039;
        this.preVtHeartRate = Double.NaN;
        this.pVE = 0.0;
        this.inVT = false;
    }

    public void resetCompliances() {
        this.venousCompliance.splitX = 0.0055;
        this.venousCompliance.splitY = 0.3;
        this.venousCompliance.lowerGradient = 600.0;
        this.venousCompliance.higherGradient = 77.0;
        this.venousCompliance.isSmooth = false;
        this.right.diaCompliance.higherGradient = 17.0;
        this.right.diaCompliance.splitY = 0.008;
        this.right.diaCompliance.splitX = 0.001;
        this.right.diaCompliance.lowerGradient = 1.0;
        this.right.diaCompliance.isSmooth = false;
        this.left.diaCompliance.higherGradient = 17.0;
        this.left.diaCompliance.splitY = 0.008;
        this.left.diaCompliance.splitX = 0.001;
        this.left.diaCompliance.lowerGradient = 1.0;
        this.left.diaCompliance.isSmooth = false;
        this.left.starling.maximalSV = 0.138;
        this.left.starling.optimumEDV = 0.154;
        this.left.starling.minimumEDV = 0.015;
        this.right.starling.maximalSV = 0.138;
        this.right.starling.optimumEDV = 0.154;
        this.right.starling.minimumEDV = 0.015;
        this.left.fillingCurve.decayConstant = 5.0;
        this.left.fillingCurve.maximalValue = 1.0;
        this.right.fillingCurve.decayConstant = 5.0;
        this.right.fillingCurve.maximalValue = 1.0;
    }

    void calculatePhase() {
        this.phase += this.elapsedTime / 60.0 * this.rate.get();
        if (this.phase >= 1.0) {
            this.phase -= (double)((int)this.phase);
            this.isEctopic = Math.random() < this.pVE;
        }
    }

    public void calculateValves() {
        this.left.fillingCurve.decayConstant = 5.0 * (1.0 - this.mitralStenosis.get()) * (1.0 + 0.3 * this.aorticRegurg.get());
        double peri = this.pericVol.get();
        this.left.fillingCurve.maximalValue = this.right.fillingCurve.maximalValue = Math.max(0.1, Math.min(1.0, 1.15 - peri * 10.0));
        this.left.diaCompliance.higherGradient = this.right.diaCompliance.higherGradient = 21.0 - Math.max(peri - 0.01, 0.0) * 300.0;
        this.left.extraFillingPressure = this.aorticRegurg.get() * 0.01;
    }

    void calculatePerfusion() {
        this.O2supply = this.flow.get() * this.body.blood.arterial.O2.get() * 72.0 / this.rate.get() * 72.0 / this.rate.get();
        double vo2 = this.CO.get() * (this.body.CVS.AP.get() - this.right.atrialP.get()) * 0.16 * 0.3;
        this.VO2.set(vo2);
        double isc = vo2 - this.O2supply;
        this.pVE = Math.max(0.0, Math.min(1.0, Math.max(isc - 0.001, 0.0) * 50.0 + Math.max(0.0, Math.min(1.0, (this.body.blood.K.getC() - 0.0085) * 2000.0))));
    }

    public boolean isEctopicBeat() {
        if (this.body.getClock().isSlowMode) {
            return this.isEctopic;
        }
        return Math.random() < this.pVE;
    }

    public void calculateRemodelling() {
        this.LVH.lowPass(this.left.sysP.get() * this.lvsv, 2.0E-6);
    }
}

