/*
 * Decompiled with CFR 0.152.
 */
package phic;

import phic.Blood;
import phic.Current;
import phic.common.Container;
import phic.common.Fluids;
import phic.common.FoodContainer;
import phic.common.Organ;
import phic.common.VDouble;
import phic.drug.DrugContainer;

public class GITract
extends Organ {
    DrugContainer portalVein = new DrugContainer();
    private final double acidSecretionRate = 3.0E-8;
    public double motilityRate = 0.01;
    public VDouble stomachCapacity = new VDouble();
    public double amylaseConcentration = 0.02;
    public double MAX_ABSORPTION_RATE;
    protected static final Container colonic_secretion_example = Fluids.get("ColonicSecretions", 1.0);
    public VDouble colonSecretion;
    private FoodContainer ileum;
    private FoodContainer abstmp;
    private FoodContainer abstemp2;
    private Container parietalCell_temp;
    private Container parietalCell_example;
    public FoodContainer stomach;
    public Container colon;
    public double baselineInsulin;
    public VDouble glucoseTolerance;

    public GITract() {
        this.addEqn("\\frac{d}{dt}StVol", "\\left(eating? Hung\\right) - 0.01 \\cdot StVol");
        this.addEqn("\\frac{d}{dt}BV", "-\\frac{d}{dt}StVol - Edema - UVol - SwR + RH2O+ ? \\cdot MBR");
        this.addEqn("\\frac{d}{dt}PGlu", "0.9/min\\cdot\\left(ExGlu\\right)\\frac{EH2O}{BV+EH2O} -StGlu\\frac{d}{dt}StVol - UVol\\cdot UGlu", "Plasma glucose is absorbed from the stomach, exchanged with the ECF, and may be lost in urine");
        this.addEqn("\\frac{d}{dt}PNa", "\\frac{ExNa-PNa}{BH2O} \\cdot 1L/min - StNa\\frac{d}{dt}StVol - UVol\\cdot UNa", "Plasma sodium is absorbed from the stomach, exchanged with the ECF, and excreted in urine");
        this.addEqn("\\frac{d}{dt}PK", "\\frac{ExK-PK}{BH2O} \\cdot 1L/min - StL\\frac{d}{dt}StVol - UVol\\cdot UK", "Plasma potassium is absorbed from the stomach, exchanged with the ECF, and excreted in urine");
        this.MAX_ABSORPTION_RATE = 0.01;
        this.colonSecretion = new VDouble();
        this.ileum = new FoodContainer();
        this.abstmp = new FoodContainer();
        this.abstemp2 = new FoodContainer();
        this.parietalCell_temp = new Container();
        this.parietalCell_example = Fluids.get("GastricSecretions", 1.0);
        this.stomach = new FoodContainer();
        this.colon = new DrugContainer();
        this.baselineInsulin = 0.00123;
        this.glucoseTolerance = new VDouble();
    }

    public void tick() {
        this.gut();
        this.pancreas();
        this.waitMinutes(1.0);
    }

    void gut() {
        double motilityPercent = this.fractionDecayPerMinute(this.motilityRate);
        this.stomach.digestFraction(this.fractionDecayPerMinute(this.amylaseConcentration));
        if (this.stomach.volume.get() > 0.005) {
            double volumeFromStomach = motilityPercent * this.stomach.volume.get();
            this.stomach.withdrawVol_overwrite(volumeFromStomach, this.ileum);
            this.ileum.H.moveTo(this.body.blood.H, 1.0 * (this.ileum.H.get() - 1.0E-7) * this.fractionDecayPerMinute(0.4));
            this.ileum.carbohydrate.moveTo(this.stomach.carbohydrate);
            this.abstmp.empty();
            this.ileum.withdrawFrac_overwrite(this.motilityRate, this.abstmp);
            this.ileum.filterSolidsInto(this.abstmp);
            this.colon.addAndDiscardExtras(this.abstmp);
            GITract.colonic_secretion_example.volume.set(this.colonSecretion.get() * this.elapsedTime / 60.0);
            this.body.blood.withdrawVolExample_overwrite(colonic_secretion_example, this.abstmp);
            this.colon.add(this.abstmp);
            double ileumOverload = this.ileum.volume.get() - this.MAX_ABSORPTION_RATE * this.elapsedTime / 60.0;
            if (ileumOverload > 0.0) {
                this.ileum.withdrawVol_overwrite(ileumOverload, this.abstemp2);
                this.colon.add(this.abstemp2);
            }
            this.portalVein.add(this.ileum);
        }
        this.secreteAcid();
    }

    protected void secreteAcid() {
        this.parietalCell_example.volume.set(0.0017 * this.elapsedTime / 60.0);
        this.body.blood.withdrawVolExample_overwrite(this.parietalCell_example, this.parietalCell_temp);
        this.stomach.add(this.parietalCell_temp);
    }

    void pancreas() {
        Blood b = Current.body.blood;
        b.Insul.multiplyBy(this.fractionPerMinute(0.9));
        double gluTol = this.glucoseTolerance.get();
        double ecfgluerr = this.body.ecf.glucose.getError();
        if (gluTol > 0.0) {
            double secretedInsulinPerMinute = ((ecfgluerr > 0.001 ? ecfgluerr * 0.2 + (ecfgluerr - 0.001) * ecfgluerr * 1000.0 : (ecfgluerr > 0.0 ? ecfgluerr * 0.2 : (ecfgluerr > -0.001 ? ecfgluerr * 1.0 : ecfgluerr * 1.0 + Math.abs(ecfgluerr + 0.001) * ecfgluerr * 1000.0))) + (ecfgluerr < -0.003 ? 0.0 : Math.max(0.0, Math.min(0.006, this.stomach.glucose.getQ() + this.stomach.carbohydrate.getQ() * 0.005555555555555556 - 0.4)) * 0.014 + this.baselineInsulin)) * Math.pow(gluTol, 3.0);
            double secretedInsulin = secretedInsulinPerMinute * this.elapsedTime / 60.0;
            b.Insul.addQuantity(secretedInsulin * 2.4E-9);
        }
    }

    public void reset() {
        this.stomach.empty();
        this.colon.empty();
        this.portalVein.empty();
        this.motilityRate = 0.01;
    }
}

