/*
 * Decompiled with CFR 0.152.
 */
package phic;

import java.util.Vector;
import phic.common.PerfusedOrgan;
import phic.common.VDouble;
import phic.drug.DrugContainer;
import phic.drug.DrugQuantity;

public class Fat
extends PerfusedOrgan {
    private DrugContainer theDrugs;
    private final double DENSITY = 0.8;
    public VDouble mass;

    public Fat() {
        this.addEqn("FaFlo", "\\frac{AP}{FaRes \\cdot Visc}");
        this.theDrugs = new DrugContainer();
        this.DENSITY = 0.8;
        this.mass = new VDouble(){

            public double get() {
                return ((Fat)Fat.this).theDrugs.volume.get() * 0.8 * 1000.0;
            }

            public void set(double m) {
                ((Fat)Fat.this).theDrugs.volume.set(m / 0.8 / 1000.0);
            }

            public void add(double m) {
                ((Fat)Fat.this).theDrugs.volume.add(m / 0.8 / 1000.0);
            }
        };
    }

    public void tick() {
        this.equilibrateDrugs();
    }

    public final double getDrugBinding(Object property) {
        return this.theDrugs.getDrugBinding(property);
    }

    void equilibrateDrugs() {
        Vector bds = this.body.blood.drugqs;
        int i = 0;
        while (i < bds.size()) {
            DrugQuantity bd = (DrugQuantity)bds.get(i);
            DrugQuantity fd = this.theDrugs.findOrCreateMatchingDrug(bd);
            this.equilibrate(bd, fd);
            ++i;
        }
    }

    void equilibrate(DrugQuantity bQ, DrugQuantity fQ) {
        if (!bQ.isSameDrug(fQ)) {
            throw new IllegalArgumentException("Cannot equilibrate two different drugs " + bQ + " and " + fQ);
        }
        double sol = bQ.getProperty("LIPID_SOLUBILITY");
        if (sol == 0.0) {
            return;
        }
        double transferRate = this.flow.get() * (bQ.getC() - fQ.getC() / sol);
        double tx = transferRate * this.fractionDecayPerMinute(0.8);
        bQ.addQ(-tx);
        fQ.addQ(tx);
    }

    public void reset() {
        this.theDrugs = new DrugContainer();
    }

    public DrugContainer getDrugContainer() {
        return this.theDrugs;
    }

    public void addDrugs(DrugContainer dc) {
        this.theDrugs.add(dc);
    }
}

