/*
 * Decompiled with CFR 0.152.
 */
package phic;

import java.io.Serializable;
import java.util.Vector;
import phic.BasicActions;
import phic.Body;
import phic.Current;
import phic.IntravenousInfusion;
import phic.common.Container;
import phic.common.Fluids;
import phic.common.FoodContainer;
import phic.common.Gas;
import phic.common.LifeSupport;
import phic.common.Table;
import phic.common.VDouble;
import phic.gui.PhicApplication;

public class Environment
implements Serializable {
    private static Table SVPTable = new Table("SVP.txt", 1);
    public VDouble Temp = new VDouble();
    public VDouble Hum = new VDouble();
    public VDouble BarP = new VDouble();
    public VDouble Uprt = new VDouble();
    public VDouble Togs = new VDouble();
    public VDouble Exer = new VDouble();
    public VDouble H2OX = new VDouble();
    public VDouble Hyperv = new VDouble();
    public Gas.WithCO air = new Gas.WithCO();
    public Gas airP = new Gas();
    public boolean BrHld;
    public boolean starve;
    public boolean NBM;
    public VDouble bleedingRate;
    public Container urine;
    public FoodContainer stool;
    public Container rubbish;
    public Container vomit;
    public BasicActions actions;
    protected Vector infusions;
    private Container hmrg_temp;
    protected LifeSupport variableClamps;
    public VDouble pain;
    public FoodContainer food;
    double foodFractionCarb;

    public Environment() {
        this.airP.O2 = new VDouble(){

            public double get() {
                return Environment.this.air.O2.get() * Environment.this.BarP.get();
            }

            public void set(double d) {
                Environment.this.air.O2.set(d / Environment.this.BarP.get());
            }
        };
        this.airP.CO2 = new VDouble(){

            public double get() {
                return Environment.this.air.CO2.get() * Environment.this.BarP.get();
            }

            public void set(double d) {
                Environment.this.air.CO2.set(d / Environment.this.BarP.get());
            }
        };
        this.bleedingRate = new VDouble();
        this.urine = new Container();
        this.stool = new FoodContainer();
        this.rubbish = new FoodContainer();
        this.infusions = new Vector();
        this.hmrg_temp = new Container();
        this.pain = new VDouble();
        this.food = new FoodContainer();
        this.foodFractionCarb = 0.95;
    }

    public static double getSVP(double temperature) {
        int n = Environment.SVPTable.nRows - 1;
        int d = 100 / n;
        double T = temperature < 0.0 ? 0.0 : (temperature > 99.0 ? 99.0 : temperature);
        int r = (int)(T / (double)d);
        double f = SVPTable.getDouble(r, 0);
        double S = f + (SVPTable.getDouble(r + 1, 0) - f) * (T - (double)(d * r)) / (double)d;
        return S * 0.001;
    }

    public void setBody(Body b) {
        this.actions = new BasicActions(b);
        this.variableClamps = new LifeSupport();
        this.variableClamps.setBody(b);
    }

    public void addInfusion(IntravenousInfusion i) {
        this.infusions.add(i);
    }

    public IntravenousInfusion createInfusion(Container container, double rate) {
        IntravenousInfusion i = new IntravenousInfusion(Current.body.blood, container, rate);
        this.addInfusion(i);
        i.start();
        return i;
    }

    protected void doIntravenousInfusions(double time) {
        int i = 0;
        while (i < this.infusions.size()) {
            IntravenousInfusion n = (IntravenousInfusion)this.infusions.get(i);
            if (n.isRunning()) {
                n.tick(time);
            }
            if (n.empty) {
                n.stop();
                if (PhicApplication.frame != null) {
                    PhicApplication.frame.finishDrip(n);
                }
                this.infusions.remove(i--);
            }
            ++i;
        }
        double hmrg = this.bleedingRate.get();
        if (hmrg > 0.0) {
            Current.body.blood.withdrawVol_overwrite(hmrg * time / 60.0, this.hmrg_temp);
            this.rubbish.add(this.hmrg_temp);
        }
    }

    public LifeSupport getVariableClamps() {
        return this.variableClamps;
    }

    public void resetAll() {
        this.NBM = false;
        this.starve = false;
        this.BrHld = false;
        this.vomit.empty();
        this.rubbish.empty();
        this.urine.empty();
        this.stool.empty();
        this.initialiseFood();
        this.variableClamps.reset();
    }

    private void initialiseFood() {
        this.food.empty();
        this.food.add(Fluids.get("Food", 1.0));
        double cgluc = this.food.glucose.getC();
        this.food.glucose.multiplyBy(1.0 - this.foodFractionCarb);
        this.food.carbohydrate.set(cgluc * this.foodFractionCarb / 0.005555555555555556);
    }
}

