/*
 * Decompiled with CFR 0.152.
 */
package phic;

import phic.common.Curve;
import phic.common.HasContent;
import phic.common.VDouble;
import phic.common.VDoubleReadOnly;

public class Chamber
implements HasContent {
    public VDouble sysP = new VDouble(6);
    public VDouble diaP = new VDouble(6);
    public VDouble sysV = new VDouble(4);
    public VDouble diaV = new VDouble(4);
    public VDouble atrialP = new VDouble(6);
    protected double strokeVolume;
    protected double map;
    protected double rate;
    public double fillingFraction;
    public Curve.ExponentialApproach fillingCurve = new Curve.ExponentialApproach();
    public Curve.TwoGradients diaCompliance = new Curve.TwoGradients();
    protected double extraFillingPressure = 0.0;
    public VDoubleReadOnly power = new VDoubleReadOnly(){

        public double get() {
            return Chamber.this.map * 133322.36841 * Chamber.this.strokeVolume * Chamber.this.rate / 60000.0;
        }
    };
    public VDoubleReadOnly SW = new VDoubleReadOnly(){

        public double get() {
            return Chamber.this.strokeVolume * (Chamber.this.map - Chamber.this.diaP.get()) * 133322.36841 / 1000.0;
        }
    };
    public VDoubleReadOnly EF = new VDoubleReadOnly(){

        public double get() {
            return (Chamber.this.diaV.get() - Chamber.this.sysV.get()) / Chamber.this.diaV.get();
        }
    };
    public Curve.Starling starling = new Curve.Starling();

    public void setStrokeVolume(double vol) {
        this.strokeVolume = vol;
    }

    public void setRate(double rate) {
        this.rate = rate;
    }

    public void setMeanP(double meanP) {
        this.map = meanP;
    }

    public void reset() {
        this.map = 0.0;
        this.rate = 72.0;
        this.strokeVolume = 0.065;
        this.fillingFraction = 1.0;
    }

    public void tick() {
        this.fillingFraction = this.fillingCurve.getValue(60.0 / this.rate);
        double diav = this.fillingFraction * this.diaCompliance.getValue(this.atrialP.get() + this.extraFillingPressure);
        this.diaV.set(diav);
        double sysv = Math.max(0.0, diav - this.strokeVolume);
        this.sysV.set(sysv);
        this.diaP.set(this.diaCompliance.getInverse(sysv));
    }

    protected double suctionPressure() {
        return this.atrialP.initialValue - this.diaCompliance.getInverse(this.sysV.get());
    }
}

