/*
 * Decompiled with CFR 0.152.
 */
package phic;

import phic.Blood;
import phic.Body;
import phic.Current;
import phic.Heart;
import phic.common.Container;
import phic.common.Gas;
import phic.common.GasConc;
import phic.common.Organ;
import phic.common.VDouble;
import phic.common.VDoubleReadOnly;
import phic.drug.DrugContainer;

public class CVS
extends Organ {
    public Heart heart;
    public VDoubleReadOnly DiaBP;
    public VDoubleReadOnly SysBP;
    public VDouble Pcap;
    public Gas InterstitialP;
    protected double interstitialGasDiffusion;
    public VDouble PVR;
    public VDouble MPAP;
    static final double osm2p = 19.02;
    public VDouble ICOP;
    public VDouble PCOP;
    public VDouble Oedema;
    public VDouble VCT;
    public VDouble Hard;
    public PulsatileVariable AP;
    public VDouble APL;
    public VDouble pulsePressure;
    public VDoubleReadOnly PR;
    public VDoubleReadOnly SysPAP;
    public VDouble DiaPAP;
    public VDouble lymphaticPressure;
    public double capillaryPressureFraction;
    public double capillaryPermeability;
    private DrugContainer filter_temp;
    private DrugContainer filter_temp2;
    public VDouble KinfluxRate;
    public VDouble Venoconstriction;

    public CVS() {
        this.addEqn("AHct", "100- Hct ");
        this.addEqn("Hct", "\\frac{RCM}{BV}", "The haematocrit is the ratio of red cell volume to blood volume. Since red cell mass is fairly stable (except in haemorrhage), haematocrit depends mainly on plasma volume");
        this.addEqn("Hb", "\\frac{Hct \\cdot MeanCellHaemoglobin}{MeanCellVolume}");
        this.addEqn("H2CO3", " 0.0301 \\( VPCO2 \\)");
        this.addEqn("\\frac{d PHy}{dt}", "\\frac{1}{2} ABC");
        this.addEqn("ABC", "- \\left( PBic+PHy+K -\\sqrt{ \\left( PBic+PHy+K \\right)^2-4 \\left( PBic \\cdot PHy - K \\cdot H2CO3 \\right) } \\right)");
        this.addEqn("\\frac{d PBic}{dt}", "\\frac{1}{2} ABC");
        this.addEqn("BE", "PBic - PHy - 24.27 mmol/L - 10^{-7.41}");
        this.addEqn("BUN", "\\frac{PUN}{AHct}");
        this.addEqn("Glu", "\\frac{PGlu}{AHct}");
        this.addEqn("BNa", "\\frac{PNa}{AHct}");
        this.addEqn("BK", "\\frac{PK}{AHct}");
        this.heart = new Heart();
        this.addEqn("DiaBP", "AP-\\frac{1}{3}PulP");
        this.addEqn("SysBP", "AP+\\frac{2}{3}PulP");
        this.DiaBP = new VDoubleReadOnly(){

            public double get() {
                return CVS.this.AP.getStaticValue() - CVS.this.pulsePressure.get() / 3.0;
            }
        };
        this.SysBP = new VDoubleReadOnly(){

            public double get() {
                return CVS.this.AP.getStaticValue() + CVS.this.pulsePressure.get() * 2.0 / 3.0;
            }
        };
        this.Pcap = new VDouble();
        this.InterstitialP = new Gas();
        this.interstitialGasDiffusion = 0.3;
        this.addEqn("IPO2", "VPO2-0.3\\cdot \\left(APO2-VPO2\\right)");
        this.addEqn("IPCO2", "VPCO2+0.3\\cdot \\left(VPCO2-APCO2\\right)");
        this.InterstitialP.O2 = new VDoubleReadOnly(){

            public double get() {
                GasConc a = CVS.this.body.blood.arterial;
                GasConc v = CVS.this.body.blood.venous;
                double apo2 = a.PO2.get();
                double vpo2 = v.PO2.get();
                return vpo2 - CVS.this.interstitialGasDiffusion * (apo2 - vpo2);
            }
        };
        this.InterstitialP.CO2 = new VDoubleReadOnly(){

            public double get() {
                GasConc a = CVS.this.body.blood.arterial;
                GasConc v = CVS.this.body.blood.venous;
                double apco2 = a.PCO2.get();
                double vpco2 = v.PCO2.get();
                return vpco2 + CVS.this.interstitialGasDiffusion * (vpco2 - apco2);
            }
        };
        this.PVR = new VDouble();
        this.MPAP = new VDouble();
        this.addEqn("ICOP", "19.02 Osm/M \\cdot ExPr", "Osmolarity of each mole of protein");
        this.ICOP = new VDouble(){

            public double get() {
                return CVS.this.body.ecf.prot.getC() * 19.02;
            }

            public void set(double d) {
                CVS.this.body.ecf.prot.setC(d / 19.02);
            }
        };
        this.addEqn("PCOP", "19.02 Osm/M \\cdot PPr", "Osmolarity of each mole of protein");
        this.PCOP = new VDouble(){

            public double get() {
                return CVS.this.body.blood.PPr.get() * 19.02;
            }

            public void set(double d) {
                CVS.this.body.blood.setPlasma(CVS.this.body.blood.prot, d / 19.02);
            }
        };
        this.Oedema = new VDouble();
        this.VCT = new VDouble();
        this.Hard = new VDouble();
        this.AP = new PulsatileVariable();
        this.APL = new VDouble();
        this.pulsePressure = new VDouble();
        this.addEqn("PR", "\\frac{Visc}{\\frac{1}{ReRes}+\\frac{1}{MuRes}+\\frac{1}{SkRes}+\\frac{1}{BrRes}+\\frac{1}{ViRes}+\\frac{1}{HtRes}+\\frac{1}{FaRes}}");
        this.PR = new VDoubleReadOnly(){

            public double get() {
                Body b = CVS.this.body;
                return b.blood.Visc.get() / (1.0 / b.kidney.resistance.get() + 1.0 / b.muscle.resistance.get() + 1.0 / b.skin.resistance.get() + 1.0 / b.brain.resistance.get() + 1.0 / b.viscera.resistance.get() + 1.0 / b.CVS.heart.resistance.get() + 1.0 / b.Fat.resistance.get());
            }
        };
        this.addEqn("AP", "PR\\cdot CO");
        this.addEqn("PulP", "Hard \\left(SV+125ml\\right) \\cdot \\frac{AP}{100mmHg}\\left(1-0.7\\cdot AoS\\right)\\cdot\\left(1+1.6\\cdot AoR\\right)");
        this.addEqn("MPAP", "PVR\\cdot CO");
        this.addEqn("SysPAP", "1.8 \\cdot MPAP");
        this.addEqn("DiaPAP", "0.25 \\cdot MPAP + LAP");
        this.SysPAP = new VDoubleReadOnly(){

            public double get() {
                return CVS.this.MPAP.get() * 1.8;
            }
        };
        this.DiaPAP = new VDoubleReadOnly(){

            public double get() {
                double m = CVS.this.MPAP.get();
                return m * 0.25 + CVS.this.heart.left.atrialP.get();
            }
        };
        this.lymphaticPressure = new VDouble();
        this.capillaryPressureFraction = 0.145;
        this.capillaryPermeability = 1.2;
        this.addEqn("Pcap", "RAP+0.145 \\cdot \\left(AP-RAP\\right)", "Capilliary pressure is a fixed fraction of arterial pressure");
        this.addEqn("LymP", "\\frac{\\Delta EH2O}{20ml} \\cdot \\left(\\frac{Exer}{500J/min}+0.2\\right)-2mmHg");
        this.addEqn("Edema", "\\left(capilliaryPermeability \\approx 1.2 ml/mmHg \\right) \\cdot \\left[ICOP-PCOP+Pcap\\left[\\frac{45\\%}{Hct}\\right]^1  - LymP \\right]_{-10mmHx}");
        this.addEqn("\\frac{d}{dt}EH2O", "Oedema - \\left[ 10 L/Osm \\cdot DOsm \\right]_{-0.2\\cdot IH2O}^{0.2\\cdot EH2O}");
        this.addEqn("\\frac{d}{dt}ExNa", "\\frac{PNa-ExNa}{EH2O} \\cdot 1L/min", "Rapid exchange across capillaries");
        this.addEqn("\\frac{d}{dt}ExK", "\\frac{PK-ExK}{EH2O} \\cdot 1L/min - \\frac{d}{dt}IK", "Rapid exchange across capillaries and osmosis");
        this.filter_temp = new DrugContainer();
        this.filter_temp2 = new DrugContainer();
        this.KinfluxRate = new VDouble();
        this.addEqn("\\frac{d}{dt}IH2O", "\\left[ 10 L/Osm \\cdot DOsm \\right]_{-0.2\\cdot IH2O}^{0.2\\cdot EH2O}", "Osmosis into cells");
        this.addEqn("\\frac{d}{dt}IK \\rightarrow_{0.3/min}", "0.008 \\left( \\frac{Insul}{2.4\\times10^{-9}} + betaAdrenoreceptor - 0.002 \\right) - 0.3\\left(IK\\cdot IH2O - 3.375mol\\right) \\cdot");
        this.addEqn("Visc", "1+1.3\\cdot\\left[Hct-50\\%\\right]^+");
        this.Venoconstriction = new VDouble();
    }

    public void tick() {
        this.calculateP();
        this.calculateCapillaries();
        this.calculateIntracellular();
        this.environment.doIntravenousInfusions(this.elapsedTime);
        this.environment.getVariableClamps().tick();
        this.erythropoiesis();
        this.calculateVenousReturn();
        this.waitMinutes(1.0);
    }

    protected void calculateP() {
        double ap = this.PR.get() * this.heart.CO.get();
        this.AP.set(ap);
        this.APL.lowPass(ap, this.fractionDecayPerMinute(0.1));
        this.pulsePressure.set((this.heart.SV.get() + 0.125) * this.Hard.get() * ap * 10.0 * (1.0 - 0.7 * this.heart.aorticStenosis.get()) * (1.0 + 1.6 * this.heart.aorticRegurg.get()));
        this.MPAP.set(this.PVR.get() * this.heart.CO.get());
    }

    protected void calculateCapillaries() {
        Blood blood = this.body.blood;
        Container ECF = this.body.ecf;
        double rap = this.heart.right.atrialP.get();
        double pcap = rap + this.capillaryPressureFraction * (this.AP.get() - rap);
        this.Pcap.set(pcap);
        double mobility = this.environment.Exer.get() / 500.0 + 0.2;
        double ecfp = Math.max(0.0, ECF.volume.getError() * 0.05 * mobility - 0.002);
        this.lymphaticPressure.set(ecfp);
        double correctedPcap = pcap * Math.min(0.45 / blood.Hct.get(), 1.0);
        double dP = this.ICOP.get() - this.PCOP.get() + correctedPcap - ecfp;
        if (dP < -0.01 && ecfp > 0.01) {
            dP = Math.max(dP, -0.01);
        }
        double extravasation = dP * this.capillaryPermeability;
        this.Oedema.set(extravasation);
        double tmins = this.elapsedTime / 60.0;
        criticalPeriod.enter();
        blood.ultraFiltrate_overwrite(1.0 * tmins, this.filter_temp);
        double volumeOut = this.filter_temp.volume.get();
        ECF.add(this.filter_temp);
        double volumeIn = volumeOut - extravasation * this.elapsedTime / 60.0;
        volumeIn = Math.max(0.0, volumeIn);
        ECF.ultraFiltrate_overwrite(2.0 * tmins, this.filter_temp);
        this.filter_temp.withdrawVol_overwrite(volumeIn, this.filter_temp2);
        blood.add(this.filter_temp2);
        ECF.add(this.filter_temp);
        criticalPeriod.exit();
    }

    protected void calculateIntracellular() {
        this.body.ecf.urea.equilibrateConcentration(this.body.ecf.urea, this.fractionDecayPerMinute(0.3));
        double volume = 10.0 * this.body.DOsm.get() * this.elapsedTime / 60.0;
        volume = Math.max(-this.body.icf.volume.get() * 0.2, Math.min(volume, this.body.ecf.volume.get() * 0.2));
        criticalPeriod.enter();
        this.body.ecf.addWater(-volume);
        this.body.icf.addWater(volume);
        criticalPeriod.exit();
        double Keffect = (this.body.blood.Insul.get() + this.body.blood.getDrugBinding("INSULIN_EFFECT")) / 2.4E-9 - 0.002 + 1.0 * this.body.blood.getDrugBinding("BETA_ADRENOCEPTOR");
        double IKerror = this.body.icf.K.Q.get() - this.body.icf.K.initialValue * this.body.icf.volume.initialValue;
        this.KinfluxRate.lowPass(0.008 * Keffect + this.body.ecf.K.getError() - IKerror * 0.3, this.fractionDecayPerMinute(0.3));
        this.body.ecf.K.moveTo(this.body.icf.K, this.KinfluxRate.get() * this.elapsedTime / 60.0);
    }

    protected void erythropoiesis() {
        if (this.body.blood.Hct.get() > 0.9) {
            this.body.brain.feel(3, "has died of dehydration");
        }
        this.body.blood.Visc.set(1.0 + 1.3 * Math.max(this.body.blood.Hct.get() - 0.5, 0.0));
    }

    public double O2delivery() {
        return this.heart.CO.get() * this.body.blood.arterial.O2.get();
    }

    public void reset() {
        this.body.ecf.solids.set(0.0);
        this.KinfluxRate.set(0.0);
        this.pulsePressure.set(0.05);
        this.body.blood.CarbonicProduction.set(0.0);
        this.capillaryPermeability = 1.2;
        this.capillaryPressureFraction = 0.158;
    }

    public static final double getPulsePressureWaveform() {
        double p = Current.body.CVS.heart.phase;
        return p * Math.exp(-p * 4.0) - 0.075;
    }

    public void calculateVenousReturn() {
        this.heart.venousCompliance.lowerGradient = this.Venoconstriction.get();
    }

    public class PulsatileVariable
    extends VDouble {
        double p;

        public void set(double v) {
            super.set(v);
            this.p = v;
        }

        public double get() {
            if (!CVS.this.body.getClock().isSlowMode) {
                return super.get();
            }
            double ph = CVS.this.heart.phase;
            return (ph * Math.exp(-ph * 4.0) - 0.075) * CVS.this.pulsePressure.get() + super.get();
        }

        public double getStaticValue() {
            return super.get();
        }
    }
}

