/*
 * Decompiled with CFR 0.152.
 */
package phic;

import phic.Blood;
import phic.Current;
import phic.Lung;
import phic.common.ConsciousLevelOptions;
import phic.common.PerfusedOrgan;
import phic.common.Quantity;
import phic.common.VDouble;
import phic.common.VDoubleReadOnly;

public class Brain
extends PerfusedOrgan {
    public static final int WELL = 0;
    public static final int ILL = 1;
    public static final int UNCONSCIOUS = 2;
    public static final int DEAD = 3;
    private int feeling = 0;
    private boolean asleep;
    public VDouble hunger = new VDouble();
    public VDouble thirst = new VDouble();
    public VDouble nausea = new VDouble();
    public VDouble sedation = new VDouble();
    public VDouble pain = new VDouble();
    public VDouble Symp = new VDouble();
    final double maxColonVol = 0.5;
    final double maxBladderVol = 0.5;
    public VDouble greed = new VDouble();
    public VDouble thirstiness = new VDouble();
    protected double opiateBinding;
    private String predicate = null;
    private int newFeeling = 0;
    double cardiacIsch = 0.0;
    protected int N_MESSAGES;
    protected int N_CYCLES;
    public double gainThresholdWhenAsleep;
    public VDouble Consc;
    public double preferredEatVolume;
    public double preferredDrinkVolume;
    public VDouble respiratoryDrive;
    public VDouble CO2drive;
    public VDouble pHdrive;
    public VDouble O2drive;
    public VDouble O2Supply;
    public VDouble hypoxia;
    public VDouble fever;
    private boolean previousVoluntaryOverride;
    public boolean diabetesInsipidus;
    public VDouble ICP;
    public ConsciousLevelOptions conscious;

    public Brain() {
        this.addEqn("Sedn", "2.7 \\cdot opiatereceptor + gabareceptor + 0.02 \\cdot \\left[APCO2-50mmHg\\right]^{+}0.1 \\cdot Hypox + 10 \\cdot PNH3");
        this.addEqn("Seizure\\ threshold", "100 \\cdot \\left[PNa-110mM\\right]^+ + 1000 \\cdot \\left[Calc-2mM \\right]^+ + 2200 \\cdot \\left[Calc-2.5mM\\right]^+ + Sedn");
        this.addEqn("Naus", "\\left[StVol-StCap\\right]^+ + \\left[StNa-0.5M\\right]^+  + 100 \\cdot opiatereceptor  + \\left[100 \\cdot \\left(BUN-35mM\\right) \\right]^{1}_{0}");
        this.N_MESSAGES = 0;
        this.N_CYCLES = 0;
        this.gainThresholdWhenAsleep = 1.5;
        this.Consc = new VDouble();
        this.preferredEatVolume = 0.6;
        this.preferredDrinkVolume = 0.3;
        this.addEqn("Consc", "1 - (Asleep\\ or\\ Unconscious) + Pain - Sedn");
        this.addEqn("\\frac{d}{dt} Hung", " \\left( 2mL/min \\left[ 2.5 mM - \\Delta ExGlu \\right]^4_0 + \\left[-40\\cdot \\Delta BNa \\right]^4_0  + 8mL/min \\cdot \\left( StVol < 10mL \\right) \\\\  + 0.6 \\cdot \\left[\\Delta Insul \\right]^-  - Naus \\right) \\cdot Greed");
        this.addEqn("\\frac{d}{dt} Thir", " \\left( 1mL/min \\cdot \\left[6L-BV\\right]^6_0  + 0.05mL/min \\cdot \\left[POsm - 295mOsm\\right]^+  \\right) \\cdot Thstn");
        this.respiratoryDrive = new VDouble();
        this.CO2drive = new VDouble();
        this.pHdrive = new VDouble();
        this.O2drive = new VDouble();
        this.addEqn("RespR", "\\left[ 13 \\cdot RespDr \\cdot \\left( 1+4\\cdot Pain \\right)  \\right]_0^{60}");
        this.addEqn("RespDr", "\\left[CO2Drv\\right]_{0.55}^\\infty \\left[O2Drv^2\\right]_1^\\infty  \\left[pHDrv\\right]_1^\\infty \\left(1-1500\\cdot opiatereceptor\\right)");
        this.addEqn("CO2Drv", "\\left( \\Delta APCO2 >0\\right) \\cdot \\left( \\frac{APCO2-37.5mmHg}{2.5mmHg} \\right)^2  + \\left( \\Delta APCO2 \\le 0 \\right)  \\cdot \\left[ \\frac{APCO2}{40mmHg} \\right]^1_0 \\cdot 0.1 + 0.9");
        this.O2Supply = new VDouble();
        this.hypoxia = new VDouble();
        this.fever = new VDouble();
        this.previousVoluntaryOverride = false;
        this.addEqn("Hypox", "max\\left(35mL/min - AO2 \\cdot BrFlo, 55mmHg-APO2\\right)", "Hypoxia can occur with too little flow of oxygen, or due to insufficient 'oxygen tension' (partial pressure of oxygen)");
        this.diabetesInsipidus = false;
        this.addEqn("\\frac{d}{dt}ADH", "1 \\times 10^{-15} \\cdot \\left[  -0.3 - \\Delta BV \\right]+ - 5\\%/min \\cdot ADH");
        this.addEqn("Pain", "EPain - 10\\cdot opiatereceptor + HtIsc");
        this.addEqn("BrFlo", "\\frac{AP-ICP}{BrRes \\cdot Visc}");
        this.flow = new VDoubleReadOnly(){

            public double get() {
                return (Brain.this.body.CVS.AP.get() - Brain.this.ICP.getError()) / Brain.this.resistance.get() / Brain.this.body.blood.Visc.get();
            }
        };
        this.ICP = new VDouble();
        this.conscious = new ConsciousLevelOptions(Current.person);
    }

    public void tick() {
        this.opiateBinding = this.body.blood.getDrugBinding("MU_OPIATE_RECEPTOR");
        this.breathing();
        this.sympathetics();
        this.pituitary();
        this.checkPain();
        this.checkFeelings();
        this.checkDesires();
        this.waitMinutes(1.0);
        this.conscious.tick(this.elapsedTime);
    }

    boolean checkFeelings() {
        boolean changed;
        double pO2;
        double O2req;
        double o2;
        double ap;
        double icfVol;
        int oldfeeling = this.feeling;
        String lastpredicate = this.predicate;
        this.predicate = null;
        this.newFeeling = 0;
        if (Current.thread.completedCycles < 3) {
            return false;
        }
        double bodyTemp = this.body.Temp.get();
        if (bodyTemp < 22.0) {
            this.feel(3, "has died of hypothermia");
        } else if (bodyTemp < 28.0) {
            this.feel(2);
        } else if (bodyTemp < 29.0) {
            this.feel(1, "is drowsy");
        } else if (!(bodyTemp < 40.0)) {
            if (bodyTemp < 44.0) {
                this.feel(1, "is delirious");
            } else if (bodyTemp >= 44.0) {
                this.feel(3, "has died of hyperthermia");
            } else {
                this.feel(3);
            }
        }
        double co2 = this.body.blood.arterial.PCO2.get();
        double pH = this.body.blood.pH.get();
        if (co2 > 0.13) {
            this.feel(2);
        } else if (co2 > 0.08 && pH < 7.2) {
            this.feel(1, "is confused");
        }
        if (co2 < 0.02 && pH > 7.5) {
            this.feel(1, "is feeling light-headed");
        }
        if ((icfVol = this.body.icf.volume.get()) > 35.0) {
            this.feel(1, "is confused");
        }
        if (icfVol > 45.0) {
            this.feel(3, "has died of cerebral oedema");
        }
        if ((ap = this.body.CVS.AP.get()) > 0.15) {
            this.feel(1, "has a headache");
        }
        if (ap < 0.07) {
            this.feel(1, "is feeling faint");
        }
        if (ap < 0.05) {
            this.feel(2, "has fainted and is unconscious");
        }
        if (ap > 0.2) {
            this.feel(3, "has died of a brain haemorrhage");
        }
        if ((o2 = this.O2Supply.get()) < 1.0 * (O2req = 0.065 * Math.min(1.0, Math.max(0.4, 1.0 + 0.2 * (this.body.Temp.get() - 33.0))))) {
            this.feel(1, "is drowsy");
        }
        if (o2 < 0.9 * O2req) {
            this.feel(2, "has become unconscious");
        }
        if (o2 < 0.8 * O2req) {
            double rap = this.body.CVS.heart.right.atrialP.get();
            double lap = this.body.CVS.heart.left.atrialP.get();
            if (rap > 0.009 && lap > 0.009) {
                this.feel(3, "has died of cerebral hypoxia due to congestive cardiac failure");
            } else if (rap > 0.009) {
                this.feel(3, "has died of right ventricular failure");
            } else if (lap > 0.009) {
                this.feel(3, "has died of left ventricular failure");
            } else if (rap < 0.002) {
                this.feel(3, "has died of cerebral hypoxia due to hypovolaemia");
            } else {
                this.feel(3, "has died of cerebral hypoxia");
            }
        }
        if ((pO2 = this.body.blood.arterial.PO2.get()) < 0.038) {
            this.feel(2);
        } else if (pO2 < 0.03) {
            this.feel(3, "has died of cerebral hypoxia");
        }
        if (this.body.blood.glucose.getC() < 0.003) {
            this.feel(1, "is feeling faint");
        }
        if (this.body.blood.glucose.getC() > 0.02) {
            this.feel(1, "is feeling bloated");
        }
        if (this.body.blood.glucose.getC() < 0.002) {
            this.feel(2);
        }
        if (this.body.blood.glucose.getC() < 2.0E-4) {
            this.feel(3, "has died of cerebral hypoglycaemia");
        }
        double naus = Math.max(0.0, this.body.gitract.stomach.volume.get() - this.body.gitract.stomachCapacity.get()) + Math.max(0.0, this.body.gitract.stomach.Na.getQ() - 0.5) + 100.0 * this.opiateBinding + Math.min(1.0, Math.max(0.0, (this.body.blood.urea.get() - 0.035) * 100.0));
        this.nausea.lowPass(naus, this.fractionDecayPerMinute(0.003));
        naus = this.nausea.get();
        if (naus > 0.1) {
            this.feel(1, "feels nauseated");
        }
        if (naus > 0.4) {
            Current.body.vomit();
        }
        if (this.body.blood.Hct.get() < 0.3) {
            this.feel(1, "has an anaemic complexion");
        }
        if (this.body.blood.Hct.get() < 0.35) {
            this.feel(1, "is feeling tired");
        }
        if (this.body.blood.Hct.get() > 0.8) {
            this.feel(3, "has died of thrombosis");
        }
        if (this.body.blood.PK.get() > 0.009) {
            this.feel(3, "has died from a fatal arrhythmia");
        }
        if (this.body.blood.PK.get() < 0.002) {
            this.feel(1, "is feeling weak");
        }
        if (this.body.blood.PK.get() < 0.0015) {
            this.feel(3, "has died from fatal arrhythmia");
        }
        if (oldfeeling == 2 && this.predicate == null) {
            this.feel(0, "has regained consciousness");
        }
        double sedn = this.opiateBinding * 2.7 + this.body.blood.getDrugBinding("GABA_RECEPTOR") * 1.0 + Math.max(0.0, co2 - 0.05) * 0.02 + this.hypoxia.get() * 0.1 + this.body.blood.NH3.get() * 10.0;
        this.sedation.set(sedn);
        if (sedn > 0.0013) {
            this.feel(2, "has become unconscious");
        } else if (sedn > 0.001) {
            this.feel(1, "is feeling drowsy");
        }
        double pna = this.body.blood.PNa.get();
        double ca = this.body.blood.Ca.get();
        double szthresh = Math.min(0.0, pna - 0.11) * 100.0 + Math.min(0.0, ca - 0.002) * 1000.0 + Math.max(0.0, ca - 0.0025) * 2200.0 + sedn * 100.0;
        if (szthresh < -0.5) {
            this.feel(2, "Has had a seizure");
        }
        if (pna < 0.108) {
            this.feel(1, "is confused");
        }
        this.cardiacIsch = this.body.CVS.heart.ischaemia.get();
        if (this.cardiacIsch > 0.01) {
            this.feel(1, "has chest pain");
        }
        if (this.cardiacIsch > 0.015) {
            this.feel(3, "has died of a heart attack");
        }
        this.feeling = this.newFeeling;
        if (this.feeling == 3 && oldfeeling < 3) {
            return true;
        }
        boolean bl = changed = oldfeeling != this.feeling;
        if ((changed || lastpredicate != this.predicate) && this.predicate != null) {
            ++this.N_MESSAGES;
            if (this.N_MESSAGES < 20) {
                this.body.message(String.valueOf(this.body.getName()) + " " + this.predicate);
            } else {
                this.N_CYCLES = Math.max(0, this.N_CYCLES - 20);
            }
        }
        if (++this.N_CYCLES > 30) {
            this.N_MESSAGES = 0;
            this.N_CYCLES = 0;
        }
        return changed;
    }

    public final int getFeeling() {
        return this.feeling;
    }

    void checkDesires() {
        double bladvol;
        double colvol;
        double effectiveInsulin;
        this.Consc.lowPass(Math.min(Math.max((double)((this.asleep ? 0 : 1) * (this.feeling == 2 ? 0 : 1)) + this.pain.get() - this.sedation.get(), 0.0), 1.0), 0.5);
        double stomachVolume = this.body.gitract.stomach.volume.get();
        double v = 0.002 * (Math.max(Math.min(2.5 - 1000.0 * this.body.ecf.glucose.getError(), 4.0), 0.0) + Math.max(0.0, Math.min(4.0, -40.0 * this.body.blood.Na.getError())));
        if (stomachVolume < 0.01) {
            v += 0.008;
        }
        if ((effectiveInsulin = (this.body.blood.Insul.getError() + this.body.blood.getDrugBinding("INSULIN_EFFECT")) / 2.4E-9) < 0.0) {
            v -= 0.6 * effectiveInsulin;
        }
        v *= 0.6;
        v = Math.max(0.0, v - this.nausea.get());
        this.hunger.set(Math.min(1.5, this.hunger.get() + v * this.greed.get() * this.elapsedTime / 60.0));
        int dvol = Math.max(Math.min(6 - (int)this.body.blood.volume.get(), 6), 0);
        double w = 0.001 * (double)dvol;
        w += Math.max(0.0, (this.body.blood.POsm.get() - 0.295) * 0.001 / 0.02);
        this.thirst.set(Math.min(2.0, this.thirst.get() + (w *= 0.7) * this.thirstiness.get() * this.elapsedTime / 60.0));
        if (this.hunger.get() > this.preferredEatVolume && !this.environment.starve && !this.environment.NBM && (this.feeling != 2 && !this.asleep || this.conscious.eat) && this.randomEventOccurs(0.025)) {
            this.body.eat(Math.max(0.0, Math.min(this.hunger.get(), this.body.gitract.stomachCapacity.get() - stomachVolume)));
        }
        if (this.thirst.get() > this.preferredDrinkVolume && !this.environment.NBM && (this.feeling != 2 && !this.asleep || this.conscious.drink) && this.randomEventOccurs(0.025)) {
            this.body.drink(Math.max(0.0, Math.min(this.thirst.get(), 1.5 - stomachVolume)));
        }
        if (((colvol = this.body.gitract.colon.volume.get()) > 0.5 && !this.asleep || colvol > 0.5 * this.gainThresholdWhenAsleep) && this.randomEventOccurs(0.025)) {
            this.body.defaecate();
        }
        if (((bladvol = this.body.bladder.volume.get()) > 0.5 && !this.asleep || bladvol > 0.5 * this.gainThresholdWhenAsleep) && this.randomEventOccurs(0.025)) {
            this.body.urinate();
        }
    }

    public void feel(int nfeeling) {
        String p = "";
        if (nfeeling == 2) {
            p = "has fainted and is unconscious";
        }
        if (nfeeling == 3) {
            p = "has died under mysterious circumstances";
        }
        if (nfeeling < 2 && this.feeling >= 2) {
            p = "has regained consciousness";
        }
        this.feel(nfeeling, p);
    }

    public void feel(int nfeeling, String npredicate) {
        if (nfeeling > this.newFeeling) {
            this.predicate = npredicate;
        }
        this.newFeeling = Math.max(nfeeling, this.newFeeling);
        if (nfeeling == 3 && this.feeling < 2) {
            this.conscious.becomeUnconscious();
            this.newFeeling = 2;
            this.predicate = "is unconscious and about to die";
            return;
        }
        if (nfeeling == 3 && this.feeling != 3) {
            this.conscious.goingToDie(String.valueOf(this.body.getName()) + " " + npredicate);
            this.body.die();
            this.body.message(String.valueOf(this.body.getName()) + " " + this.predicate);
        } else if (this.asleep && this.feeling < 1 && this.newFeeling == 1) {
            this.wakeUp();
        } else if (this.conscious.isExercising() && this.conscious.mobile && nfeeling < 1 & this.newFeeling == 1) {
            this.conscious.stopExercising();
        } else if (nfeeling == 2 && this.feeling < 2) {
            this.conscious.becomeUnconscious();
        } else if (nfeeling < 2 && this.feeling == 2) {
            this.conscious.recoverConsciousness();
        }
    }

    public void reset() {
        this.feeling = 0;
        this.newFeeling = 0;
        this.conscious.reset();
        this.environment.Uprt.initialise();
        this.asleep = false;
        this.N_MESSAGES = 0;
        this.N_CYCLES = 0;
        this.opiateBinding = 0.0;
        this.cardiacIsch = 0.0;
    }

    void breathing() {
        double co2drive;
        Blood blood = this.body.blood;
        this.previousVoluntaryOverride = this.environment.BrHld | this.environment.Hyperv.get() > 0.0;
        double respiratoryRate = Math.max(Math.min(13.0 * (1.0 + this.pain.get() * 4.0) * this.respiratoryDrive.get(), 60.0), 0.0);
        Lung lung = this.body.lungs;
        lung.RespR.set(respiratoryRate);
        double tmp = this.O2drive.get();
        double targetDrive = Math.max(this.CO2drive.get(), 0.55) * Math.max(tmp * tmp, 1.0) * Math.max(this.pHdrive.get(), 1.0) * (1.0 - 1500.0 * this.opiateBinding);
        double apCO2 = blood.arterial.PCO2.get();
        double d = co2drive = apCO2 > 0.04 ? (apCO2 - 0.0375) / 0.0025 : Math.max(0.0, Math.min(1.0, apCO2 / 0.04)) / 10.0 + 0.9;
        if (co2drive > 1.0) {
            co2drive *= co2drive;
        }
        this.CO2drive.set(co2drive);
        if (this.environment.BrHld) {
            this.respiratoryDrive.set(0.0);
        } else if (this.environment.Hyperv.get() != 0.0) {
            this.respiratoryDrive.set(1.0 + 2.0 * this.environment.Hyperv.get());
        } else if (this.previousVoluntaryOverride) {
            this.respiratoryDrive.set(targetDrive);
        } else {
            this.respiratoryDrive.lowPass(targetDrive, this.fractionDecayPerMinute(0.1));
        }
        if (this.verbose) {
            this.inform("drive:pH:" + this.pHdrive.formatValue(true, false) + ", O2:" + this.O2drive.formatValue(true, false) + ", CO2:" + this.CO2drive.formatValue(true, false));
        }
    }

    void sympathetics() {
        double dO2 = this.body.blood.arterial.O2.get() * this.flow.get();
        double pO2 = this.body.blood.arterial.PO2.get();
        this.O2Supply.set(dO2);
        double hypox = Math.max(0.035 - dO2, 0.0);
        hypox = Math.max(0.055 - pO2, hypox);
        this.hypoxia.set(hypox);
        double excessO2 = Math.max(dO2 - 0.04, 0.0);
        if (this.verbose) {
            this.inform("Symp tone " + Quantity.toString(this.Symp.get()));
        }
    }

    void pituitary() {
        if (!this.diabetesInsipidus) {
            this.body.blood.ADH.add(Math.max(0.0, -0.3 - this.body.blood.volume.getError()) * 1.0E-15 * this.elapsedTime / 60.0);
        } else {
            this.body.blood.ADH.lowPass(0.0, this.fractionDecayPerMinute(0.05));
        }
    }

    void checkPain() {
        this.pain.set(Math.min(1.0, Math.max(0.0, this.environment.pain.get() - 10.0 * this.opiateBinding + this.cardiacIsch)));
    }

    public void setAsleep(boolean asleep) {
        if (this.asleep == asleep) {
            return;
        }
        this.asleep = asleep;
        if (asleep) {
            if (this.body.isLogging()) {
                this.body.message(String.valueOf(this.body.getName()) + " has fallen asleep");
            }
            this.conscious.becomeUnconscious();
        } else {
            if (this.body.isLogging()) {
                this.body.message(String.valueOf(this.body.getName()) + " has woken up");
            }
            boolean tmp = this.conscious.revertPreviousPosture;
            this.conscious.revertPreviousPosture = true;
            this.conscious.recoverConsciousness();
            this.conscious.revertPreviousPosture = tmp;
        }
    }

    public void fallAsleep() {
        this.setAsleep(true);
    }

    public void wakeUp() {
        this.setAsleep(false);
    }

    public boolean isAsleep() {
        return this.asleep;
    }

    public ConsciousLevelOptions getUnconscious() {
        return this.conscious;
    }
}

