/*
 * Decompiled with CFR 0.152.
 */
package phic;

import evaluator.MathException;
import evaluator.StackException;
import java.io.Serializable;
import java.util.Iterator;
import phic.Blood;
import phic.Brain;
import phic.CVS;
import phic.Current;
import phic.Environment;
import phic.Fat;
import phic.GITract;
import phic.Kidney;
import phic.Liver;
import phic.Lung;
import phic.Muscle;
import phic.Ovary;
import phic.Skin;
import phic.common.Clock;
import phic.common.CommonThread;
import phic.common.Container;
import phic.common.EventLog;
import phic.common.Fluids;
import phic.common.Organ;
import phic.common.PerfusedOrgan;
import phic.common.TextReceiver;
import phic.common.UnitConstants;
import phic.common.VDouble;
import phic.common.VDoubleReadOnly;
import phic.drug.DrugContainer;
import phic.gui.PhicApplication;
import phic.gui.Variables;
import phic.modifiable.ControllerList;
import phic.modifiable.Eqn;
import phic.modifiable.EqnList;
import phic.modifiable.Script;

public class Body
implements Serializable {
    public transient TextReceiver receiver;
    public transient EqnList eqnList = new EqnList();
    public VDouble Temp = new VDouble();
    public VDoubleReadOnly DOsm;
    public VDouble RQ;
    public VDoubleReadOnly H2O;
    public VDoubleReadOnly Mass;
    public double dryMuscleMass;
    public double dryBoneMass;
    public VDoubleReadOnly NMO2Use;
    public VDouble O2Use;
    public VDoubleReadOnly CO2Production;
    public VDoubleReadOnly BMR;
    public VDoubleReadOnly MBR;
    public VDoubleReadOnly Cals;
    public VDoubleReadOnly NaQ;
    public VDoubleReadOnly KQ;
    public VDouble Glycogen;
    public Fat Fat;
    public Blood blood;
    public Container ecf;
    public Container icf;
    public Container bladder;
    public Clock clock;
    public GITract gitract;
    public Liver liver;
    public Kidney kidney;
    public CVS CVS;
    public Lung lungs;
    public Skin skin;
    public Muscle muscle;
    public Brain brain;
    public Ovary gonads;
    public PerfusedOrgan viscera;
    static final String controllersFile = "Controllers.txt";
    public transient ControllerList controllers;
    static final double MAX_SPEED_FOR_LOGGING = 0.27;
    protected boolean logRoutineEventsIfFast;
    public EventLog eventLog;
    private Environment environment;
    public Script startupScript;

    public void message(String s) {
        s = this.clock.getSecond() < 0.05 ? String.valueOf(this.clock.getTimeString(3)) + " " + this.clock.getHourString() + ": " + s : String.valueOf(this.clock.getTimeString(2)) + ": " + s;
        System.out.println(s);
        if (this.receiver != null) {
            this.receiver.message(s);
        }
    }

    public void error(String s) {
        System.out.println(s);
        if (this.receiver != null) {
            this.receiver.error(s);
        }
    }

    public String getName() {
        return Current.person.name;
    }

    public Body() {
        this.addEqn("DOsm", "IOsm-ExOsm");
        this.DOsm = new VDoubleReadOnly(){

            public double get() {
                return Body.this.icf.Osm.get() - Body.this.ecf.Osm.get();
            }

            public void set(double d) {
                this.cannotSet();
            }
        };
        this.RQ = new VDouble();
        this.addEqn("H2O", "BV+ExH2O+IH2O");
        this.H2O = new VDoubleReadOnly(){

            public double get() {
                return Body.this.blood.volume.get() + Body.this.ecf.volume.get() + Body.this.icf.volume.get();
            }
        };
        this.addEqn("Mass", "StVol + H2O + Fat + 0.058 \\cdot NaQ + Gly + drymass \\approx 15kg");
        this.Mass = new VDoubleReadOnly(){

            public double get() {
                return (Body.this.gitract.stomach.volume.get() + Body.this.gitract.colon.volume.get() + Body.this.bladder.volume.get() + Body.this.H2O.get()) * 1000.0 + Body.this.Fat.mass.get() + Body.this.Glycogen.get() + Body.this.dryMuscleMass + Body.this.dryBoneMass;
            }
        };
        this.dryMuscleMass = 10000.0;
        this.dryBoneMass = 5000.0;
        this.addEqn("NMO2U", "125 \\times 10^{-9} \\cdot BMR");
        this.NMO2Use = new VDoubleReadOnly(){

            public double get() {
                return Body.this.BMR.get() / 8000000.0;
            }
        };
        this.O2Use = new VDouble();
        this.addEqn("CO2V", "O2V \\cdot RQ");
        this.CO2Production = new VDoubleReadOnly(){

            public double get() {
                return Body.this.O2Use.get() * Body.this.RQ.get();
            }
        };
        this.addEqn("\\Delta BMR", "10^{17} \\cdot \\Delta Thyr+5\\times 10^{4} \\cdot \\left( \\Delta Temp + \\Delta SkTmp \\right+5000 \\Delta IH2O + 5 \\Delta Fat + 5 \\left( \\Delta drymass-15kg \\right)");
        this.BMR = new VDoubleReadOnly(){

            public double get() {
                return Math.max(0.0, this.initialValue + 1.0E17 * Body.this.blood.Thyr.getError() + 50000.0 * Body.this.Temp.getError() + 50000.0 * Body.this.skin.Temp.getError() + 5000.0 * Body.this.icf.volume.getError() + 5.0 * Body.this.Fat.mass.getError() + 5.0 * (Body.this.dryMuscleMass + Body.this.dryBoneMass - 15000.0));
            }
        };
        this.addEqn("MBR", "1440 \\cdot MuCal + BMR \\cdot \\left( 1+Fever \\right)");
        this.MBR = new VDoubleReadOnly(){

            public double get() {
                return 1440.0 * Body.this.muscle.Cal.get() + (1.0 + 0.5 * Body.this.brain.fever.get()) * Body.this.BMR.get();
            }
        };
        this.addEqn("Cals", "\\frac{MBR}{1440}", "Conversion of metabolic rate to calories per minute");
        this.Cals = new VDoubleReadOnly(){

            public double get() {
                return Body.this.MBR.get() / 1440.0;
            }
        };
        this.addEqn("NaQ", "BNa \\cdot BV + ExNa \\cdot EH2O + INa \\cdot IH2O");
        this.NaQ = new VDoubleReadOnly(){

            public double get() {
                return Body.this.blood.Na.getQ() + Body.this.ecf.Na.getQ() + Body.this.icf.Na.getQ();
            }
        };
        this.addEqn("KQ", "BK \\cdot BV + ExK \\cdot EH2O + IK \\cdot IH2O");
        this.KQ = new VDoubleReadOnly(){

            public double get() {
                return Body.this.blood.K.getQ() + Body.this.ecf.K.getQ() + Body.this.icf.K.getQ();
            }
        };
        this.Glycogen = new VDouble();
        this.Fat = new Fat();
        this.clock = new Clock();
        this.viscera = new PerfusedOrgan(){

            public void tick() {
                Body.this.controllers.calculateAll(this.elapsedTime);
                this.waitMinutes(1.0);
            }
        };
        this.logRoutineEventsIfFast = false;
        this.eventLog = new EventLog(this);
        this.startupScript = null;
        this.initialiseContainers();
        this.initialiseOrgans();
    }

    void initialiseContainers() {
        this.ecf = new DrugContainer();
        this.icf = new Container();
        Current.environment.vomit = new DrugContainer();
        this.bladder = new DrugContainer();
        this.blood = new Blood();
    }

    void resetContainers() {
        this.environment.vomit.empty();
        this.bladder.empty();
        Current.environment.rubbish.empty();
        this.blood.empty();
        this.ecf.empty();
        this.icf.empty();
    }

    void resetOrgans() {
        Iterator e = Organ.getList().iterator();
        while (e.hasNext()) {
            ((Organ)e.next()).reset();
        }
        Organ.resetRandom();
    }

    public ControllerList getControllerList() {
        return this.controllers;
    }

    void initialiseOrgans() {
        this.skin = new Skin();
        this.brain = new Brain();
        this.muscle = new Muscle();
        this.lungs = new Lung();
        this.kidney = new Kidney();
        this.CVS = new CVS();
        this.gitract = new GITract();
        this.liver = new Liver();
        this.gonads = new Ovary();
        Organ.setBody(this);
    }

    public void urinate() {
        Container wee = Current.environment.urine;
        this.environment.rubbish.add(wee);
        wee.add(this.bladder);
        double volume = wee.volume.get();
        this.eventLog.document(EventLog.FLUID_EVENT, "Urinated ", new Double(-volume));
        if (this.isLogging()) {
            this.message("Urinated " + UnitConstants.formatValue(volume, 4, false));
        }
    }

    public void defaecate() {
        this.environment.rubbish.add(Current.environment.stool);
        this.environment.stool.add(this.gitract.colon);
        double volume = this.environment.stool.volume.get();
        this.eventLog.document(EventLog.FLUID_EVENT, "Defaecated ", new Double(-volume * (1.0 - this.environment.stool.solids.get())));
        if (this.isLogging()) {
            this.message("Defaecated");
        }
    }

    public void vomit() {
        this.environment.rubbish.add(this.environment.vomit);
        this.environment.vomit.addAndDiscardExtras(this.gitract.stomach.withdrawFrac(0.8));
        double volume = this.environment.vomit.volume.get();
        this.message("Vomited " + UnitConstants.formatValue(volume, 4, false));
        this.eventLog.document(EventLog.FLUID_EVENT, "Vomited ", new Double(-volume));
        PhicApplication.markEvent("V");
        this.brain.nausea.set(0.0);
    }

    public void eat(double volume) {
        Container food = this.environment.food.createMore(volume);
        double fluid = volume * (1.0 - food.solids.get());
        this.gitract.stomach.add(food);
        this.brain.hunger.add(-volume);
        this.brain.thirst.set(Math.max(0.0, this.brain.thirst.get() - volume / 6.0));
        if (this.isLogging()) {
            this.message("Eaten " + UnitConstants.formatValue(volume, 4, false));
        }
        this.eventLog.document(EventLog.FLUID_EVENT, "Eaten ", new Double(fluid));
        PhicApplication.markEvent("E");
    }

    public void setLogRoutineEventsIfFast(boolean b) {
        this.logRoutineEventsIfFast = b;
    }

    public boolean getLogRoutineEventsIfFast() {
        return this.logRoutineEventsIfFast;
    }

    protected final boolean isLogging() {
        return this.logRoutineEventsIfFast || this.clock.getSecond() > 0.27;
    }

    public void drink(double volume) {
        this.gitract.stomach.add(Fluids.get("Water", volume));
        this.brain.thirst.add(-volume);
        if (this.isLogging()) {
            this.message("Drank " + UnitConstants.formatValue(volume, 4, false));
        }
        this.eventLog.document(EventLog.FLUID_EVENT, "Drank ", new Double(volume));
        PhicApplication.markEvent("D");
    }

    public void die() {
        if (!this.brain.getUnconscious().disableDeath) {
            this.clock.stop();
            this.message("Dead.");
        }
    }

    public void die(String reason) {
        this.clock.stop();
        this.message("Dead: " + reason);
    }

    public void setRunning(boolean r) {
        if (r) {
            if (!Current.thread.isAlive()) {
                try {
                    Current.thread.start();
                }
                catch (IllegalThreadStateException e) {
                    System.out.println("Main calculation thread unexpectedly died - restarting...");
                    Current.thread = new CommonThread();
                    Current.thread.start();
                }
            }
            this.clock.start();
        } else {
            this.clock.stop();
        }
    }

    public Clock getClock() {
        return this.clock;
    }

    public void resetBodyValues() {
        this.resetOrgans();
        this.resetContainers();
        Variables.initialiseBodyValues();
        this.clock.resetTime();
        Current.thread.completedCycles = 0;
        this.eventLog = new EventLog(this);
        this.controllers.replaceAllVariables();
        if (this.startupScript != null) {
            try {
                this.startupScript.executeOnce();
            }
            catch (StackException ex) {
                ex.printStackTrace();
            }
            catch (MathException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void resetAllValues() {
        this.resetOrgans();
        this.resetContainers();
        this.environment.resetAll();
        Variables.initialise();
        this.clock.resetTime();
        Current.thread.completedCycles = 0;
        this.eventLog = new EventLog(this);
        this.setupControllers();
        if (this.startupScript != null) {
            try {
                this.startupScript.executeOnce();
            }
            catch (StackException ex) {
                ex.printStackTrace();
            }
            catch (MathException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void setEnvironment(Environment e) {
        this.environment = e;
    }

    public void setupControllers() {
        this.controllers = new ControllerList(controllersFile);
    }

    public void addEqn(Eqn eqn) {
        this.eqnList.add(eqn);
    }

    public void addEqn(String lhs, String rhs) {
        this.eqnList.add(new Eqn(lhs, rhs));
    }

    public void addEqn(String lhs, String rhs, String desc) {
        this.eqnList.add(new Eqn(lhs, rhs, desc));
    }
}

