/*
 * Decompiled with CFR 0.152.
 */
package phic;

import phic.Current;
import phic.common.Container;
import phic.common.Curve;
import phic.common.GasConc;
import phic.common.Organ;
import phic.common.Quantity;
import phic.common.VDouble;
import phic.common.VDoubleReadOnly;
import phic.drug.DrugContainer;

public class Blood
extends DrugContainer {
    public VDouble Eryth = new VDouble();
    public VDouble Insul = new VDouble();
    public VDouble ADH = new VDouble();
    public VDouble AngII = new VDouble();
    public VDouble Aldo = new VDouble();
    public VDouble Thyr = new VDouble();
    public VDouble oestrogen = new VDouble();
    public VDouble progesterone = new VDouble();
    public VDouble inhibin = new VDouble();
    public VDouble LH = new VDouble();
    public VDouble FSH = new VDouble();
    public VDouble ketones = new VDouble();
    public VDouble NH3 = new VDouble();
    public GasConc arterial = new GasConc(this);
    public GasConc venous = new GasConc(this);
    public VDouble Hct = new VDouble(this){

        public double get() {
            return Blood.this.solids.get();
        }

        public void set(double d) {
            Blood.this.solids.set(d);
        }
    };
    public VDouble SatO2 = new VDoubleReadOnly(){

        public double get() {
            if (Current.body.getClock().isSlowMode) {
                double p = Current.body.CVS.heart.phase;
                return (1.0 + (p * Math.exp(-4.0 * p) - 0.075) * 0.05) * Blood.this.arterial.SatO2.get();
            }
            return Blood.this.arterial.SatO2.get();
        }
    };
    final double satFluct = 0.05;
    public double MCH = 3.0E-11;
    public double MCV = 8.8E-14;
    public double anisocytosis = 0.1;
    public VDouble Visc = new VDouble();
    public VDouble Ca = new VDouble();
    public VDouble CO = new VDouble();
    public VDouble Hb = new VDouble(){

        public double get() {
            return Blood.this.solids.get() * Blood.this.MCH / Blood.this.MCV;
        }

        public void set(double d) {
            Blood.this.solids.set(d * Blood.this.MCV / Blood.this.MCH);
        }
    };
    public Quantity lactate = new Quantity(this);
    public VDouble CarbonicProduction = new VDouble();
    public VDoubleReadOnly baseExcess = new VDoubleReadOnly(){

        public double get() {
            double oH = Math.pow(10.0, -7.4);
            double oCO2 = 0.001204;
            return Blood.this.PBic.get() + oH - Blood.this.PHy.get() - 0.024266;
        }
    };
    public VDouble PHy = new VDouble(){

        public double get() {
            return Blood.this.getPlasma(Blood.this.H);
        }

        public void set(double value) {
            Blood.this.setPlasma(Blood.this.H, value);
        }
    };
    public VDouble PBic = new VDouble(){

        public double get() {
            return Blood.this.getPlasma(Blood.this.bicarb);
        }

        public void set(double value) {
            Blood.this.setPlasma(Blood.this.bicarb, value);
        }
    };
    public VDouble PK = new VDouble(){

        public double get() {
            return Blood.this.getPlasma(Blood.this.K);
        }

        public void set(double value) {
            Blood.this.setPlasma(Blood.this.K, value);
        }
    };
    public VDouble PNa = new VDouble(){

        public double get() {
            return Blood.this.getPlasma(Blood.this.Na);
        }

        public void set(double value) {
            Blood.this.setPlasma(Blood.this.Na, value);
        }
    };
    public VDouble POsm = new VDoubleReadOnly(){

        public double get() {
            return Blood.this.PHy.get() + Blood.this.glucose.getC() + Blood.this.PUN.get() + Blood.this.PPr.get() + 2.0 * Blood.this.PNa.get() + 2.0 * Blood.this.PK.get();
        }
    };
    public VDouble PGlu = new VDouble(){

        public double get() {
            return Blood.this.getPlasma(Blood.this.glucose);
        }

        public void set(double value) {
            Blood.this.setPlasma(Blood.this.glucose, value);
        }
    };
    public VDouble PPr = new VDouble(){

        public double get() {
            return Blood.this.getPlasma(Blood.this.prot);
        }

        public void set(double value) {
            Blood.this.setPlasma(Blood.this.prot, value);
        }
    };
    public VDouble PAlb = new VDouble(){

        public double get() {
            return Blood.this.getPlasma(Blood.this.prot) * 32300.0;
        }

        public void set(double value) {
            Blood.this.setPlasma(Blood.this.prot, value / 32300.0);
        }
    };
    public VDouble PUN = new VDouble(){

        public double get() {
            return Blood.this.getPlasma(Blood.this.urea);
        }

        public void set(double value) {
            Blood.this.setPlasma(Blood.this.urea, value);
        }
    };
    public VDouble PCreat = new VDouble(){

        public double get() {
            return Blood.this.getPlasma(Blood.this.creat);
        }

        public void set(double value) {
            Blood.this.setPlasma(Blood.this.creat, value);
        }
    };
    public VDouble PV = new VDoubleReadOnly(){

        public double get() {
            return Blood.this.volume.get() * Blood.this.AHct();
        }
    };
    public VDouble PCl = new VDoubleReadOnly(){

        public double get() {
            return Blood.this.Cl.get() / Blood.this.AHct();
        }
    };
    public VDouble RCM = new VDouble(){

        public double get() {
            return Blood.this.solids.getQ();
        }

        public void set(double value) {
            Blood.this.volume.set(Blood.this.volume.get() * (1.0 - Blood.this.solids.getC()) + value);
            Blood.this.solids.setQ(value);
        }
    };
    public Curve HbO2DissocArt;

    public Blood() {
        this.HbO2DissocArt = this.arterial.O2Dissociation;
    }

    public double AHct() {
        return 1.0 - this.solids.getC();
    }

    public double redCellCount() {
        return this.RCM.get() / this.MCV;
    }

    void acidbase(double elapsedSeconds) {
        double carbonicAcid = 0.0301 * this.venous.PCO2.get();
        this.H2CO3.setC(carbonicAcid);
        double pbic = this.PBic.get();
        double phy = this.PHy.get();
        this.ABC = this.bufferConcentrationChange(this.H2CO3, this.PBic, 7.95E-7);
        double concChange = 1.0 * this.ABC * Organ.fractionDecayPerMinute(0.2, elapsedSeconds * 60.0);
        this.H.addC(concChange);
        this.bicarb.addC(concChange);
        this.CarbonicProduction.set(-this.ABC / 0.0301);
    }

    protected double bufferConcentrationChange(VDouble acid, VDouble base, double k) {
        double h = this.PHy.get();
        double b = base.get();
        double c = acid.get();
        return 0.5 * (-b - h - k + Math.sqrt((b + h + k) * (b + h + k) - 4.0 * (b * h - c * k)));
    }

    public double getPlasma(Quantity substance) {
        return substance.get() * 1.0 / this.AHct();
    }

    public void setPlasma(Quantity substance, double value) {
        substance.set(value * this.AHct());
    }

    public void addWithoutO2(Container c) {
        double volratio = this.vol;
        super.add(c);
        this.arterial.O2.multiplyBy(volratio /= this.vol);
        this.venous.O2.multiplyBy(volratio);
    }
}

