/*
 * Decompiled with CFR 0.152.
 */
package phic;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import phic.Body;
import phic.Current;
import phic.common.Container;
import phic.common.EventLog;
import phic.common.Fluids;
import phic.common.FoodContainer;
import phic.common.HasContent;
import phic.common.UnitConstants;
import phic.common.VDouble;
import phic.doctor.DrugParser;
import phic.drug.NoSuchDrugException;
import phic.drug.Pharmacy;
import phic.gui.PhicApplication;
import phic.gui.Variables;
import phic.gui.VisibleVariable;

public class BasicActions
implements HasContent {
    protected Body body;
    public VDouble fright = new VDouble();
    public VDouble amountAmylNitrite = new VDouble();
    public VDouble drinkVolume = new VDouble();
    public transient ActionSet saline = new ActionSet("Saline bolus", new String[]{"50ml", "200ml", "500ml"}){

        void action(int n) {
            double[] volume = new double[]{0.05, 0.2, 0.5};
            BasicActions.this.ivBolus("Saline", Fluids.get("Saline", volume[n]));
        }
    };
    public transient ActionSet fluid100ml = new ActionSet("100ml IV bolus", new String[]{"Dextrose", "Saline", "Colloid", "Blood"}){

        void action(int n) {
            BasicActions.this.ivBolus(this.names[n], Fluids.get(this.names[n], 0.1));
        }
    };
    public transient ActionValue frightenBy = new ActionValue("Frighten", "Fright"){

        void action(double v) {
            BasicActions.this.fright.set(v);
            BasicActions.this.frighten();
        }
    };
    public transient ActionValue amylNitriteAmt = new ActionValue("Amyl nitrite", "AmylNitrite"){

        void action(double v) {
            BasicActions.this.amountAmylNitrite.set(v);
            BasicActions.this.amylNitrite();
        }
    };
    public transient ActionSet diuretics = new ActionSet("Frusemide", new String[]{"10mg", "40mg", "120mg"}){

        void action(int n) {
            double[] amt = new double[]{0.01, 0.04, 0.12};
            try {
                BasicActions.this.ivBolus("Frusemide " + this.names[n], Pharmacy.dispenseAmpoule("Frusemide", amt[n]));
            }
            catch (NoSuchDrugException e) {
                e.printStackTrace();
            }
        }
    };

    public BasicActions(Body body) {
        this.body = body;
    }

    public void frighten() {
        try {
            this.body.blood.add(Pharmacy.dispenseAmpoule("Adrenaline", 0.001 * this.fright.get()));
        }
        catch (NoSuchDrugException e) {
            e.printStackTrace();
        }
    }

    public void amylNitrite() {
        this.body.CVS.VCT.add(-this.amountAmylNitrite.get());
    }

    public void glycerylTrinitrate() {
        try {
            this.ivBolus("GTN", Pharmacy.dispenseAmpoule("Glyceryl trinitrate", 1.0E-4));
        }
        catch (NoSuchDrugException x) {
            x.printStackTrace();
        }
    }

    public void drinkWater() {
        this.drink("Water", Fluids.get("Water", this.drinkVolume.get()));
    }

    public void drinkAlkali() {
        this.drink("Alkali", Fluids.get("Alkali", this.drinkVolume.get()));
    }

    public void drinkAcid() {
        Container acid = Fluids.get("Water", this.drinkVolume.get());
        acid.pH.set(3.5);
        this.drink("Acid", acid);
    }

    public void drinkSeawater() {
        this.drink("Seawater", Fluids.get("Seawater", this.drinkVolume.get()));
    }

    public void eatMeal() {
        Current.body.eat(0.5);
    }

    public void eatChocolateBar() {
        try {
            this.drink("Chocolate bar", Pharmacy.dispenseSubstance("Water 0.050 + glucose 0.600"));
        }
        catch (NoSuchDrugException noSuchDrugException) {
            // empty catch block
        }
    }

    public void eatBread() {
        try {
            FoodContainer f = new FoodContainer();
            f.add(Pharmacy.dispenseSubstance("Water 0.010 + prot 0.100 + Na 0.080"));
            f.carbohydrate.setQ(800.0);
            this.drink("Starch", f);
        }
        catch (NoSuchDrugException noSuchDrugException) {
            // empty catch block
        }
    }

    public void salineBolus() {
        this.ivBolus("Saline", Fluids.get("Saline", 0.5));
    }

    public void dextroseBolus() {
        this.ivBolus("Dextrose", Fluids.get("Dextrose", 0.5));
    }

    public void colloidBolus() {
        this.ivBolus("Colloid", Fluids.get("Colloid", 0.5));
    }

    public void frusemideBolus() {
        try {
            this.ivBolus("Frusemide 40mg", Pharmacy.dispenseAmpoule("Frusemide", 0.04));
        }
        catch (NoSuchDrugException e) {
            e.printStackTrace();
        }
    }

    public void insulinBolus() {
        this.body.blood.Insul.add(9.0E-10);
    }

    public void erythropoietinBolus() {
        this.body.blood.Eryth.add(0.5);
    }

    public void transfuse() {
        this.ivBolus("Blood", Fluids.get("PackedCells", 0.47));
    }

    public void potassiumBolus() throws NoSuchDrugException {
        this.ivBolus("5 mmol K+", DrugParser.createSubstance("Water 0.010 + K 0.005"));
    }

    public void drink(String fluidName, Container c) {
        double vol = c.volume.get();
        this.body.gitract.stomach.add(c);
        this.body.message("Consumed " + UnitConstants.formatValue(vol, 4, false) + " of " + fluidName);
        this.body.eventLog.document(EventLog.FLUID_EVENT, "Drank " + fluidName, new Double(vol));
        PhicApplication.markEvent("D " + fluidName);
    }

    public void ivBolus(String fluidName, Container c) {
        double vol = c.volume.get();
        this.body.blood.addWithoutO2(c);
        this.body.message(String.valueOf(UnitConstants.formatValue(vol, 4, false)) + " of " + fluidName + " as IV bolus");
        this.body.eventLog.document(EventLog.FLUID_EVENT, "IV " + fluidName + " bolus", new Double(vol));
        PhicApplication.markEvent("IV " + fluidName);
    }

    public void drinkBeer() {
        try {
            this.drink("Beer", Pharmacy.dispenseSubstance("Water 0.568 + glucose 0.140 + Alcohol 0.025"));
        }
        catch (NoSuchDrugException x) {
            x.printStackTrace();
        }
    }

    public void interferon() {
        try {
            this.drink("Interferon", Pharmacy.dispenseAmpoule("Interferon", 0.01));
        }
        catch (NoSuchDrugException x) {
            x.printStackTrace();
        }
    }

    public void startGradualChange(String variable, double target, double fractionPerMinute) {
        VisibleVariable v = Variables.forName(variable);
        Current.body.brain.conscious.invokeGradualChange((VDouble)v.node.objectGetVal(), target, fractionPerMinute);
    }

    public static abstract class ActionSet
    implements ComplexAction {
        public String[] names;
        public String groupName;

        ActionSet(String groupName, String[] names) {
            this.groupName = groupName;
            this.names = names;
        }

        public Action[] getActions() {
            Action[] a = new Action[this.names.length];
            int i = 0;
            while (i < this.names.length) {
                final int u = i;
                a[i] = new AbstractAction(this.names[i]){

                    public void actionPerformed(ActionEvent e) {
                        ActionSet.this.action(u);
                    }
                };
                ++i;
            }
            return a;
        }

        abstract void action(int var1);

        public int size() {
            return this.names.length;
        }
    }

    public static abstract class ActionValue
    extends AbstractAction
    implements ComplexAction {
        public String name;
        public double value;
        private VisibleVariable quantityFormatter = null;
        String formatterName;

        ActionValue(String name, String formatVar) {
            this.name = name;
            this.formatterName = formatVar;
        }

        public VisibleVariable getFormatter() {
            if (this.quantityFormatter == null) {
                this.quantityFormatter = Variables.forName(this.formatterName);
            }
            return this.quantityFormatter;
        }

        public void actionPerformed(ActionEvent e) {
            this.action(this.value);
        }

        abstract void action(double var1);
    }

    public static interface ComplexAction {
    }
}

