/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.scilab.forge.jlatexmath.ResourceParseException;
import org.scilab.forge.jlatexmath.SymbolAtom;
import org.scilab.forge.jlatexmath.XMLResourceParseException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TeXSymbolParser {
    public static final String RESOURCE_NAME = "TeXSymbols.xml";
    public static final String DELIMITER_ATTR = "del";
    public static final String TYPE_ATTR = "type";
    private static Map<String, Integer> typeMappings = new HashMap<String, Integer>();
    private Element root;

    public TeXSymbolParser() throws ResourceParseException {
        this(TeXSymbolParser.class.getResourceAsStream(RESOURCE_NAME), RESOURCE_NAME);
    }

    public TeXSymbolParser(InputStream file, String name) throws ResourceParseException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringElementContentWhitespace(true);
            factory.setIgnoringComments(true);
            this.root = factory.newDocumentBuilder().parse(file).getDocumentElement();
            this.setTypeMappings();
        }
        catch (Exception e) {
            throw new XMLResourceParseException(name, e);
        }
    }

    public Map<String, SymbolAtom> readSymbols() throws ResourceParseException {
        HashMap<String, SymbolAtom> res = new HashMap<String, SymbolAtom>();
        NodeList list = this.root.getElementsByTagName("Symbol");
        int i = 0;
        while (i < list.getLength()) {
            Element symbol = (Element)list.item(i);
            String name = TeXSymbolParser.getAttrValueAndCheckIfNotNull("name", symbol);
            String type = TeXSymbolParser.getAttrValueAndCheckIfNotNull(TYPE_ATTR, symbol);
            String del = symbol.getAttribute(DELIMITER_ATTR);
            boolean isDelimiter = del != null && del.equals("true");
            Integer typeVal = typeMappings.get(type);
            if (typeVal == null) {
                throw new XMLResourceParseException(RESOURCE_NAME, "Symbol", TYPE_ATTR, "has an unknown value '" + type + "'!");
            }
            res.put(name, new SymbolAtom(name, typeVal, isDelimiter));
            ++i;
        }
        return res;
    }

    private void setTypeMappings() {
        typeMappings.put("ord", 0);
        typeMappings.put("op", 1);
        typeMappings.put("bin", 2);
        typeMappings.put("rel", 3);
        typeMappings.put("open", 4);
        typeMappings.put("close", 5);
        typeMappings.put("punct", 6);
        typeMappings.put("acc", 10);
    }

    private static String getAttrValueAndCheckIfNotNull(String attrName, Element element) throws ResourceParseException {
        String attrValue = element.getAttribute(attrName);
        if (attrValue.equals("")) {
            throw new XMLResourceParseException(RESOURCE_NAME, element.getTagName(), attrName, null);
        }
        return attrValue;
    }
}

