/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.util.BitSet;
import java.util.LinkedList;
import java.util.ListIterator;
import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.CharFont;
import org.scilab.forge.jlatexmath.CharSymbol;
import org.scilab.forge.jlatexmath.Dummy;
import org.scilab.forge.jlatexmath.FixedCharAtom;
import org.scilab.forge.jlatexmath.Glue;
import org.scilab.forge.jlatexmath.HorizontalBox;
import org.scilab.forge.jlatexmath.Row;
import org.scilab.forge.jlatexmath.SpaceAtom;
import org.scilab.forge.jlatexmath.StrutBox;
import org.scilab.forge.jlatexmath.TeXEnvironment;
import org.scilab.forge.jlatexmath.TeXFont;
import org.scilab.forge.jlatexmath.dynamic.DynamicAtom;

public class RowAtom
extends Atom
implements Row {
    protected LinkedList<Atom> elements = new LinkedList();
    public boolean lookAtLastAtom = false;
    private Dummy previousAtom = null;
    private static BitSet binSet = new BitSet(16);
    private static BitSet ligKernSet;

    static {
        binSet.set(2);
        binSet.set(1);
        binSet.set(3);
        binSet.set(4);
        binSet.set(6);
        ligKernSet = new BitSet(16);
        ligKernSet.set(0);
        ligKernSet.set(1);
        ligKernSet.set(2);
        ligKernSet.set(3);
        ligKernSet.set(4);
        ligKernSet.set(5);
        ligKernSet.set(6);
    }

    protected RowAtom() {
    }

    public RowAtom(Atom el) {
        if (el != null) {
            if (el instanceof RowAtom) {
                this.elements.addAll(((RowAtom)el).elements);
            } else {
                this.elements.add(el);
            }
        }
    }

    public Atom getLastAtom() {
        if (this.elements.size() != 0) {
            return this.elements.removeLast();
        }
        return new SpaceAtom(3, 0.0f, 0.0f, 0.0f);
    }

    public final void add(Atom el) {
        if (el != null) {
            this.elements.add(el);
        }
    }

    private void changeToOrd(Dummy cur, Dummy prev, Atom next) {
        int nextType;
        int type = cur.getLeftType();
        if (type == 2 && (prev == null || binSet.get(prev.getRightType()) || next == null)) {
            cur.setType(0);
        } else if (next != null && cur.getRightType() == 2 && ((nextType = next.getLeftType()) == 3 || nextType == 5 || nextType == 6)) {
            cur.setType(0);
        }
    }

    public Box createBox(TeXEnvironment env) {
        TeXFont tf = env.getTeXFont();
        HorizontalBox hBox = new HorizontalBox(env.getColor(), env.getBackground());
        int position = 0;
        env.reset();
        ListIterator<Object> it = this.elements.listIterator();
        while (it.hasNext()) {
            Atom at = (Atom)it.next();
            ++position;
            if (at instanceof DynamicAtom && ((DynamicAtom)at).getInsertMode()) {
                Atom a = ((DynamicAtom)at).getAtom();
                if (a instanceof RowAtom) {
                    this.elements.remove(position - 1);
                    this.elements.addAll(position - 1, ((RowAtom)a).elements);
                    it = this.elements.listIterator(position - 1);
                    at = (Atom)it.next();
                } else {
                    at = a;
                }
            }
            Dummy atom = new Dummy(at);
            Atom nextAtom = null;
            if (it.hasNext()) {
                nextAtom = (Atom)it.next();
                it.previous();
            }
            this.changeToOrd(atom, this.previousAtom, nextAtom);
            float kern = 0.0f;
            while (it.hasNext() && atom.getRightType() == 0 && atom.isCharSymbol()) {
                Atom next = (Atom)it.next();
                ++position;
                if (next instanceof CharSymbol && ligKernSet.get(next.getLeftType())) {
                    atom.markAsTextSymbol();
                    CharFont l = atom.getCharFont(tf);
                    CharFont r = ((CharSymbol)next).getCharFont(tf);
                    CharFont lig = tf.getLigature(l, r);
                    if (lig == null) {
                        kern = tf.getKern(l, r, env.getStyle());
                        it.previous();
                        --position;
                        break;
                    }
                    atom.changeAtom(new FixedCharAtom(lig));
                    continue;
                }
                it.previous();
                --position;
                break;
            }
            if (it.previousIndex() != 0 && this.previousAtom != null && !this.previousAtom.isKern() && !atom.isKern()) {
                hBox.add(Glue.get(this.previousAtom.getRightType(), atom.getLeftType(), env));
            }
            atom.setPreviousAtom(this.previousAtom);
            Box b = atom.createBox(env);
            hBox.add(b);
            env.setLastFontId(b.getLastFontId());
            if (Math.abs(kern) > 1.0E-7f) {
                hBox.add(new StrutBox(kern, 0.0f, 0.0f, 0.0f));
            }
            if (atom.isKern()) continue;
            this.previousAtom = atom;
        }
        this.previousAtom = null;
        return hBox;
    }

    public void setPreviousAtom(Dummy prev) {
        this.previousAtom = prev;
    }

    public int getLeftType() {
        if (this.elements.size() == 0) {
            return 0;
        }
        return this.elements.get(0).getLeftType();
    }

    public int getRightType() {
        if (this.elements.size() == 0) {
            return 0;
        }
        return this.elements.get(this.elements.size() - 1).getRightType();
    }
}

