/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import org.scilab.forge.jlatexmath.Box;

public class RotateBox
extends Box {
    public static final int BL = 0;
    public static final int BC = 1;
    public static final int BR = 2;
    public static final int TL = 3;
    public static final int TC = 4;
    public static final int TR = 5;
    public static final int BBL = 6;
    public static final int BBR = 7;
    public static final int BBC = 8;
    public static final int CL = 9;
    public static final int CC = 10;
    public static final int CR = 11;
    protected double angle = 0.0;
    private Box box;
    private float xmax;
    private float xmin;
    private float ymax;
    private float ymin;
    private int option;
    private float shiftX;
    private float shiftY;

    public RotateBox(Box b, double angle, float x, float y) {
        this.box = b;
        this.angle = angle * Math.PI / 180.0;
        this.height = b.height;
        this.depth = b.depth;
        this.width = b.width;
        double s = Math.sin(this.angle);
        double c = Math.cos(this.angle);
        this.shiftX = (float)((double)x * (1.0 - c) + (double)y * s);
        this.shiftY = (float)((double)y * (1.0 - c) - (double)x * s);
        this.xmax = (float)Math.max((double)(-this.height) * s, Math.max((double)this.depth * s, Math.max((double)this.width * c + (double)this.depth * s, (double)this.width * c - (double)this.height * s))) + this.shiftX;
        this.xmin = (float)Math.min((double)(-this.height) * s, Math.min((double)this.depth * s, Math.min((double)this.width * c + (double)this.depth * s, (double)this.width * c - (double)this.height * s))) + this.shiftX;
        this.ymax = (float)Math.max((double)this.height * c, Math.max((double)(-this.depth) * c, Math.max((double)this.width * s - (double)this.depth * c, (double)this.width * s + (double)this.height * c)));
        this.ymin = (float)Math.min((double)this.height * c, Math.min((double)(-this.depth) * c, Math.min((double)this.width * s - (double)this.depth * c, (double)this.width * s + (double)this.height * c)));
        this.width = this.xmax - this.xmin;
        this.height = this.ymax + this.shiftY;
        this.depth = -this.ymin - this.shiftY;
    }

    public RotateBox(Box b, double angle, Point2D.Float origin) {
        this(b, angle, origin.x, origin.y);
    }

    public RotateBox(Box b, double angle, int option) {
        this(b, angle, RotateBox.calculateShift(b, option));
    }

    public static int getOrigin(String option) {
        if (option == null || option.length() == 0) {
            return 6;
        }
        if (option.length() == 1) {
            option = String.valueOf(option) + "c";
        }
        if (option.equals("bl") || option.equals("lb")) {
            return 0;
        }
        if (option.equals("bc") || option.equals("cb")) {
            return 1;
        }
        if (option.equals("br") || option.equals("rb")) {
            return 2;
        }
        if (option.equals("cl") || option.equals("lc")) {
            return 9;
        }
        if (option.equals("cc")) {
            return 10;
        }
        if (option.equals("cr") || option.equals("cr")) {
            return 11;
        }
        if (option.equals("tl") || option.equals("lt")) {
            return 3;
        }
        if (option.equals("tc") || option.equals("ct")) {
            return 4;
        }
        if (option.equals("tr") || option.equals("rt")) {
            return 5;
        }
        if (option.equals("Bl") || option.equals("lB")) {
            return 6;
        }
        if (option.equals("Bc") || option.equals("cB")) {
            return 8;
        }
        if (option.equals("Br") || option.equals("rB")) {
            return 7;
        }
        return 6;
    }

    private static Point2D.Float calculateShift(Box b, int option) {
        Point2D.Float p = new Point2D.Float(0.0f, -b.depth);
        switch (option) {
            case 0: {
                p.x = 0.0f;
                p.y = -b.depth;
                break;
            }
            case 2: {
                p.x = b.width;
                p.y = -b.depth;
                break;
            }
            case 1: {
                p.x = b.width / 2.0f;
                p.y = -b.depth;
                break;
            }
            case 3: {
                p.x = 0.0f;
                p.y = b.height;
                break;
            }
            case 5: {
                p.x = b.width;
                p.y = b.height;
                break;
            }
            case 4: {
                p.x = b.width / 2.0f;
                p.y = b.height;
                break;
            }
            case 6: {
                p.x = 0.0f;
                p.y = 0.0f;
                break;
            }
            case 7: {
                p.x = b.width;
                p.y = 0.0f;
                break;
            }
            case 8: {
                p.x = b.width / 2.0f;
                p.y = 0.0f;
                break;
            }
            case 9: {
                p.x = 0.0f;
                p.y = (b.height - b.depth) / 2.0f;
                break;
            }
            case 11: {
                p.x = b.width;
                p.y = (b.height - b.depth) / 2.0f;
                break;
            }
            case 10: {
                p.x = b.width / 2.0f;
                p.y = (b.height - b.depth) / 2.0f;
            }
        }
        return p;
    }

    public void draw(Graphics2D g2, float x, float y) {
        this.drawDebug(g2, x, y);
        this.box.drawDebug(g2, x, y, true);
        g2.rotate(-this.angle, x += this.shiftX - this.xmin, y -= this.shiftY);
        this.box.draw(g2, x, y);
        this.box.drawDebug(g2, x, y, true);
        g2.rotate(this.angle, x, y);
    }

    public int getLastFontId() {
        return this.box.getLastFontId();
    }
}

