/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.util.HashMap;
import java.util.regex.Matcher;
import org.scilab.forge.jlatexmath.MacroInfo;
import org.scilab.forge.jlatexmath.ParseException;
import org.scilab.forge.jlatexmath.TeXParser;

public class NewCommandMacro {
    protected static HashMap<String, String> macrocode = new HashMap();
    protected static HashMap<String, String> macroreplacement = new HashMap();

    public static void addNewCommand(String name, String code, int nbargs) throws ParseException {
        macrocode.put(name, code);
        MacroInfo.Commands.put(name, new MacroInfo("org.scilab.forge.jlatexmath.NewCommandMacro", "executeMacro", (float)nbargs));
    }

    public static void addNewCommand(String name, String code, int nbargs, String def) throws ParseException {
        if (macrocode.get(name) != null) {
            throw new ParseException("Command " + name + " already exists ! Use renewcommand instead ...");
        }
        macrocode.put(name, code);
        macroreplacement.put(name, def);
        MacroInfo.Commands.put(name, new MacroInfo("org.scilab.forge.jlatexmath.NewCommandMacro", "executeMacro", (float)nbargs, 1.0f));
    }

    public static boolean isMacro(String name) {
        return macrocode.containsKey(name);
    }

    public static void addReNewCommand(String name, String code, int nbargs) {
        if (macrocode.get(name) == null) {
            throw new ParseException("Command " + name + " is not defined ! Use newcommand instead ...");
        }
        macrocode.put(name, code);
        MacroInfo.Commands.put(name, new MacroInfo("org.scilab.forge.jlatexmath.NewCommandMacro", "executeMacro", (float)nbargs));
    }

    public String executeMacro(TeXParser tp, String[] args) {
        String rep;
        String code = macrocode.get(args[0]);
        int nbargs = args.length - 11;
        int dec = 0;
        if (args[nbargs + 1] != null) {
            dec = 1;
            rep = Matcher.quoteReplacement(args[nbargs + 1]);
            code = code.replaceAll("#1", rep);
        } else if (macroreplacement.get(args[0]) != null) {
            dec = 1;
            rep = Matcher.quoteReplacement(macroreplacement.get(args[0]));
            code = code.replaceAll("#1", rep);
        }
        int i = 1;
        while (i <= nbargs) {
            rep = Matcher.quoteReplacement(args[i]);
            code = code.replaceAll("#" + (i + dec), rep);
            ++i;
        }
        return code;
    }
}

