/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.scilab.forge.jlatexmath.ParseException;
import org.scilab.forge.jlatexmath.TeXParser;

public class MacroInfo {
    public static HashMap<String, MacroInfo> Commands = new HashMap(300);
    public static HashMap<String, Object> Packages = new HashMap();
    public Object pack;
    public Method macro;
    public int nbArgs;
    public boolean hasOptions = false;
    public int posOpts;

    public MacroInfo(Object pack, Method macro, int nbArgs) {
        this.pack = pack;
        this.macro = macro;
        this.nbArgs = nbArgs;
    }

    public MacroInfo(Object pack, Method macro, int nbArgs, int posOpts) {
        this(pack, macro, nbArgs);
        this.hasOptions = true;
        this.posOpts = posOpts;
    }

    public MacroInfo(int nbArgs, int posOpts) {
        this((Object)null, null, nbArgs);
        this.hasOptions = true;
        this.posOpts = posOpts;
    }

    public MacroInfo(int nbArgs) {
        this((Object)null, null, nbArgs);
    }

    public MacroInfo(String className, String methodName, float nbArgs) {
        int nba = (int)nbArgs;
        Class[] args = new Class[]{TeXParser.class, String[].class};
        try {
            Object pack = Packages.get(className);
            if (pack == null) {
                Class<?> cl = Class.forName(className);
                pack = cl.getConstructor(new Class[0]).newInstance(new Object[0]);
                Packages.put(className, pack);
            }
            this.pack = pack;
            this.macro = pack.getClass().getDeclaredMethod(methodName, args);
            this.nbArgs = nba;
        }
        catch (Exception e) {
            System.err.println("Cannot load package " + className + ":");
            System.err.println(e.toString());
        }
    }

    public MacroInfo(String className, String methodName, float nbArgs, float posOpts) {
        int nba = (int)nbArgs;
        Class[] args = new Class[]{TeXParser.class, String[].class};
        try {
            Object pack = Packages.get(className);
            if (pack == null) {
                Class<?> cl = Class.forName(className);
                pack = cl.getConstructor(new Class[0]).newInstance(new Object[0]);
                Packages.put(className, pack);
            }
            this.pack = pack;
            this.macro = pack.getClass().getDeclaredMethod(methodName, args);
            this.nbArgs = nba;
            this.hasOptions = true;
            this.posOpts = (int)posOpts;
        }
        catch (Exception e) {
            System.err.println("Cannot load package " + className + ":");
            System.err.println(e.toString());
        }
    }

    public Object invoke(TeXParser tp, String[] args) throws ParseException {
        Object[] argsMethod = new Object[]{tp, args};
        try {
            return this.macro.invoke(this.pack, argsMethod);
        }
        catch (IllegalAccessException e) {
            throw new ParseException("Problem with command " + args[0] + " at position " + tp.getLine() + ":" + tp.getCol() + "\n", e);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException("Problem with command " + args[0] + " at position " + tp.getLine() + ":" + tp.getCol() + "\n", e);
        }
        catch (InvocationTargetException e) {
            Throwable th = e.getCause();
            throw new ParseException("Problem with command " + args[0] + " at position " + tp.getLine() + ":" + tp.getCol() + "\n" + th.getMessage());
        }
    }
}

