/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.Color;
import java.util.HashMap;
import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.Dummy;
import org.scilab.forge.jlatexmath.Row;
import org.scilab.forge.jlatexmath.RowAtom;
import org.scilab.forge.jlatexmath.TeXEnvironment;

public class ColorAtom
extends Atom
implements Row {
    public static HashMap<String, Color> Colors = new HashMap();
    private final Color background;
    private final Color color;
    private final RowAtom elements;

    static {
        ColorAtom.initColors();
    }

    public ColorAtom(Atom atom, Color bg, Color c) {
        this.elements = new RowAtom(atom);
        this.background = bg;
        this.color = c;
    }

    public ColorAtom(Color bg, Color c, ColorAtom old) {
        this.elements = new RowAtom(old.elements);
        this.background = bg == null ? old.background : bg;
        this.color = c == null ? old.color : c;
    }

    public Box createBox(TeXEnvironment env) {
        env.isColored = true;
        TeXEnvironment copy = env.copy();
        if (this.background != null) {
            copy.setBackground(this.background);
        }
        if (this.color != null) {
            copy.setColor(this.color);
        }
        return this.elements.createBox(copy);
    }

    public int getLeftType() {
        return this.elements.getLeftType();
    }

    public int getRightType() {
        return this.elements.getRightType();
    }

    public void setPreviousAtom(Dummy prev) {
        this.elements.setPreviousAtom(prev);
    }

    private static void initColors() {
        Colors.put("black", Color.black);
        Colors.put("white", Color.white);
        Colors.put("red", Color.red);
        Colors.put("green", Color.green);
        Colors.put("blue", Color.blue);
        Colors.put("cyan", Color.cyan);
        Colors.put("magenta", Color.magenta);
        Colors.put("yellow", Color.yellow);
        Colors.put("GreenYellow", ColorAtom.convColor(0.15f, 0.0f, 0.69f, 0.0f));
        Colors.put("Yellow", ColorAtom.convColor(0.0f, 0.0f, 1.0f, 0.0f));
        Colors.put("Goldenrod", ColorAtom.convColor(0.0f, 0.1f, 0.84f, 0.0f));
        Colors.put("Dandelion", ColorAtom.convColor(0.0f, 0.29f, 0.84f, 0.0f));
        Colors.put("Apricot", ColorAtom.convColor(0.0f, 0.32f, 0.52f, 0.0f));
        Colors.put("Peach", ColorAtom.convColor(0.0f, 0.5f, 0.7f, 0.0f));
        Colors.put("Melon", ColorAtom.convColor(0.0f, 0.46f, 0.5f, 0.0f));
        Colors.put("YellowOrange", ColorAtom.convColor(0.0f, 0.42f, 1.0f, 0.0f));
        Colors.put("Orange", ColorAtom.convColor(0.0f, 0.61f, 0.87f, 0.0f));
        Colors.put("BurntOrange", ColorAtom.convColor(0.0f, 0.51f, 1.0f, 0.0f));
        Colors.put("Bittersweet", ColorAtom.convColor(0.0f, 0.75f, 1.0f, 0.24f));
        Colors.put("RedOrange", ColorAtom.convColor(0.0f, 0.77f, 0.87f, 0.0f));
        Colors.put("Mahogany", ColorAtom.convColor(0.0f, 0.85f, 0.87f, 0.35f));
        Colors.put("Maroon", ColorAtom.convColor(0.0f, 0.87f, 0.68f, 0.32f));
        Colors.put("BrickRed", ColorAtom.convColor(0.0f, 0.89f, 0.94f, 0.28f));
        Colors.put("Red", ColorAtom.convColor(0.0f, 1.0f, 1.0f, 0.0f));
        Colors.put("OrangeRed", ColorAtom.convColor(0.0f, 1.0f, 0.5f, 0.0f));
        Colors.put("RubineRed", ColorAtom.convColor(0.0f, 1.0f, 0.13f, 0.0f));
        Colors.put("WildStrawberry", ColorAtom.convColor(0.0f, 0.96f, 0.39f, 0.0f));
        Colors.put("Salmon", ColorAtom.convColor(0.0f, 0.53f, 0.38f, 0.0f));
        Colors.put("CarnationPink", ColorAtom.convColor(0.0f, 0.63f, 0.0f, 0.0f));
        Colors.put("Magenta", ColorAtom.convColor(0.0f, 1.0f, 0.0f, 0.0f));
        Colors.put("VioletRed", ColorAtom.convColor(0.0f, 0.81f, 0.0f, 0.0f));
        Colors.put("Rhodamine", ColorAtom.convColor(0.0f, 0.82f, 0.0f, 0.0f));
        Colors.put("Mulberry", ColorAtom.convColor(0.34f, 0.9f, 0.0f, 0.02f));
        Colors.put("RedViolet", ColorAtom.convColor(0.07f, 0.9f, 0.0f, 0.34f));
        Colors.put("Fuchsia", ColorAtom.convColor(0.47f, 0.91f, 0.0f, 0.08f));
        Colors.put("Lavender", ColorAtom.convColor(0.0f, 0.48f, 0.0f, 0.0f));
        Colors.put("Thistle", ColorAtom.convColor(0.12f, 0.59f, 0.0f, 0.0f));
        Colors.put("Orchid", ColorAtom.convColor(0.32f, 0.64f, 0.0f, 0.0f));
        Colors.put("DarkOrchid", ColorAtom.convColor(0.4f, 0.8f, 0.2f, 0.0f));
        Colors.put("Purple", ColorAtom.convColor(0.45f, 0.86f, 0.0f, 0.0f));
        Colors.put("Plum", ColorAtom.convColor(0.5f, 1.0f, 0.0f, 0.0f));
        Colors.put("Violet", ColorAtom.convColor(0.79f, 0.88f, 0.0f, 0.0f));
        Colors.put("RoyalPurple", ColorAtom.convColor(0.75f, 0.9f, 0.0f, 0.0f));
        Colors.put("BlueViolet", ColorAtom.convColor(0.86f, 0.91f, 0.0f, 0.04f));
        Colors.put("Periwinkle", ColorAtom.convColor(0.57f, 0.55f, 0.0f, 0.0f));
        Colors.put("CadetBlue", ColorAtom.convColor(0.62f, 0.57f, 0.23f, 0.0f));
        Colors.put("CornflowerBlue", ColorAtom.convColor(0.65f, 0.13f, 0.0f, 0.0f));
        Colors.put("MidnightBlue", ColorAtom.convColor(0.98f, 0.13f, 0.0f, 0.43f));
        Colors.put("NavyBlue", ColorAtom.convColor(0.94f, 0.54f, 0.0f, 0.0f));
        Colors.put("RoyalBlue", ColorAtom.convColor(1.0f, 0.5f, 0.0f, 0.0f));
        Colors.put("Blue", ColorAtom.convColor(1.0f, 1.0f, 0.0f, 0.0f));
        Colors.put("Cerulean", ColorAtom.convColor(0.94f, 0.11f, 0.0f, 0.0f));
        Colors.put("Cyan", ColorAtom.convColor(1.0f, 0.0f, 0.0f, 0.0f));
        Colors.put("ProcessBlue", ColorAtom.convColor(0.96f, 0.0f, 0.0f, 0.0f));
        Colors.put("SkyBlue", ColorAtom.convColor(0.62f, 0.0f, 0.12f, 0.0f));
        Colors.put("Turquoise", ColorAtom.convColor(0.85f, 0.0f, 0.2f, 0.0f));
        Colors.put("TealBlue", ColorAtom.convColor(0.86f, 0.0f, 0.34f, 0.02f));
        Colors.put("Aquamarine", ColorAtom.convColor(0.82f, 0.0f, 0.3f, 0.0f));
        Colors.put("BlueGreen", ColorAtom.convColor(0.85f, 0.0f, 0.33f, 0.0f));
        Colors.put("Emerald", ColorAtom.convColor(1.0f, 0.0f, 0.5f, 0.0f));
        Colors.put("JungleGreen", ColorAtom.convColor(0.99f, 0.0f, 0.52f, 0.0f));
        Colors.put("SeaGreen", ColorAtom.convColor(0.69f, 0.0f, 0.5f, 0.0f));
        Colors.put("Green", ColorAtom.convColor(1.0f, 0.0f, 1.0f, 0.0f));
        Colors.put("ForestGreen", ColorAtom.convColor(0.91f, 0.0f, 0.88f, 0.12f));
        Colors.put("PineGreen", ColorAtom.convColor(0.92f, 0.0f, 0.59f, 0.25f));
        Colors.put("LimeGreen", ColorAtom.convColor(0.5f, 0.0f, 1.0f, 0.0f));
        Colors.put("YellowGreen", ColorAtom.convColor(0.44f, 0.0f, 0.74f, 0.0f));
        Colors.put("SpringGreen", ColorAtom.convColor(0.26f, 0.0f, 0.76f, 0.0f));
        Colors.put("OliveGreen", ColorAtom.convColor(0.64f, 0.0f, 0.95f, 0.4f));
        Colors.put("RawSienna", ColorAtom.convColor(0.0f, 0.72f, 1.0f, 0.45f));
        Colors.put("Sepia", ColorAtom.convColor(0.0f, 0.83f, 1.0f, 0.7f));
        Colors.put("Brown", ColorAtom.convColor(0.0f, 0.81f, 1.0f, 0.6f));
        Colors.put("Tan", ColorAtom.convColor(0.14f, 0.42f, 0.56f, 0.0f));
        Colors.put("Gray", ColorAtom.convColor(0.0f, 0.0f, 0.0f, 0.5f));
        Colors.put("Black", ColorAtom.convColor(0.0f, 0.0f, 0.0f, 1.0f));
        Colors.put("White", ColorAtom.convColor(0.0f, 0.0f, 0.0f, 0.0f));
    }

    private static Color convColor(float c, float m, float y, float k) {
        k = 1.0f - k;
        return new Color(k * (1.0f - c), k * (1.0f - m), k * (1.0f - y));
    }
}

