/*
 * Decompiled with CFR 0.152.
 */
package medicine.visual;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import medicine.Entity;
import medicine.visual.AdjustDiagramDialog;
import medicine.visual.GraphicPane;
import medicine.visual.VisualiserPane_dirbutton_actionAdapter;

public class VisualiserPane
extends JPanel
implements ActionListener {
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    JRadioButton causation = new JRadioButton();
    JRadioButton jRadioButton2 = new JRadioButton();
    ButtonGroup bg1 = new ButtonGroup();
    GraphicPane graphicPane = new GraphicPane();
    JScrollBar depthscroll = new JScrollBar();
    JLabel depthtext = new JLabel();
    JButton jButton1 = new JButton();
    JButton dirbutton = new JButton();
    int dirbuttonstate = 1;
    private static final String[] dirnames = new String[]{"Causes", "Effects", "Both", "Superclasses", "Subtypes", "Both"};

    public VisualiserPane() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void updatedirbutton() {
        if (this.causation.isSelected()) {
            this.dirbutton.setText(dirnames[this.dirbuttonstate - 1]);
        } else {
            this.dirbutton.setText(dirnames[this.dirbuttonstate + 2]);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.causation.setText("Causation");
        this.jRadioButton2.setText("Hierarchy");
        this.depthscroll.setVisibleAmount(1);
        this.depthscroll.setValue(1);
        this.depthscroll.setOrientation(0);
        this.depthscroll.setMaximum(6);
        this.depthscroll.setBlockIncrement(1);
        this.depthscroll.setToolTipText("Depth of tree to be shown");
        this.depthscroll.setPreferredSize(new Dimension(50, 16));
        this.depthscroll.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                VisualiserPane.this.depthscroll_adjustmentValueChanged(e);
            }
        });
        this.depthtext.setFont(new Font("Dialog", 1, 12));
        this.depthtext.setPreferredSize(new Dimension(30, 17));
        this.depthtext.setText("0");
        this.jButton1.setToolTipText("");
        this.jButton1.setText("Adjust...");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VisualiserPane.this.jButton1_actionPerformed(e);
            }
        });
        this.dirbutton.setText("Direction");
        this.dirbutton.addActionListener(new VisualiserPane_dirbutton_actionAdapter(this));
        this.add((Component)this.jPanel1, "North");
        this.bg1.add(this.causation);
        this.bg1.add(this.jRadioButton2);
        this.causation.addActionListener(this);
        this.jRadioButton2.addActionListener(this);
        this.jPanel1.add((Component)this.causation, null);
        this.jPanel1.add((Component)this.jRadioButton2, null);
        this.jPanel1.add((Component)this.depthscroll, null);
        this.jPanel1.add((Component)this.depthtext, null);
        this.jPanel1.add((Component)this.dirbutton, null);
        this.jPanel1.add((Component)this.jButton1, null);
        this.causation.setSelected(true);
        this.add((Component)this.graphicPane, "Center");
    }

    public Entity getEntity() {
        return this.graphicPane.getEntity();
    }

    public void setEntity(Entity e) {
        this.graphicPane.setEntity(e);
    }

    public void actionPerformed(ActionEvent e) {
        this.changeGraphic();
    }

    void changeGraphic() {
        int depth = this.depthscroll.getValue();
        if (this.causation.isSelected()) {
            this.graphicPane.setRange(depth, 0);
        } else {
            this.graphicPane.setRange(0, depth);
        }
    }

    void depthscroll_adjustmentValueChanged(AdjustmentEvent e) {
        this.depthtext.setText(String.valueOf(this.depthscroll.getValue()));
        this.changeGraphic();
    }

    void jButton1_actionPerformed(ActionEvent e) {
        new AdjustDiagramDialog(this.graphicPane).show();
    }

    void dirbutton_actionPerformed(ActionEvent e) {
        this.dirbuttonstate = 1 + this.dirbuttonstate % 3;
        this.updatedirbutton();
        this.graphicPane.setDirection(this.dirbuttonstate % 2 > 0, this.dirbuttonstate >> 1 > 0);
    }
}

