/*
 * Decompiled with CFR 0.152.
 */
package medicine.visual;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import medicine.Entity;

public class Node {
    public Entity entity;
    String string;
    public double x;
    public double y;
    public double vx;
    public double vy;
    boolean anchored;
    Rectangle rectangle = new Rectangle();
    public Vector connections = new Vector();
    public Vector rconnections = new Vector();
    Color colbox = Color.blue;
    Color colline = Color.cyan;
    Color coltext = Color.white;
    int distscale = 100;
    int axisc = 0;
    int axish = 0;

    public Node(Entity entity, double x, double y) {
        this.entity = entity;
        this.x = x;
        this.y = y;
        this.string = entity.toString();
    }

    public void paint(Graphics g_) {
        Graphics2D g = (Graphics2D)g_;
        Rectangle2D rect = g.getFont().getStringBounds(this.string, 0, this.string.length(), g.getFontRenderContext());
        int w = (int)rect.getWidth();
        int h = (int)rect.getHeight();
        int tx = (int)(this.x - (double)(w / 2));
        int ty = (int)(this.y - (double)(h / 2));
        this.rectangle = new Rectangle(tx, ty, w, h);
        g.setColor(this.colbox);
        g.fill(this.rectangle);
        g.setColor(this.colline);
        g.draw(this.rectangle);
        g.setColor(this.coltext);
        g.drawString(this.string, tx, ty + h - 3);
        int i = 0;
        while (i < this.connections.size()) {
            Node n = (Node)this.connections.get(i);
            this.drawconnectionto(g, n);
            ++i;
        }
    }

    void drawconnectionto(Graphics g, Node n) {
        if (this.rectangle.x + this.rectangle.width < n.rectangle.x) {
            this.drawArrow(g, this.rectangle.x + this.rectangle.width, this.y, n.rectangle.x, n.y);
        } else if (this.rectangle.x > n.rectangle.x + n.rectangle.width) {
            this.drawArrow(g, this.rectangle.x, this.y, n.rectangle.x + n.rectangle.width, n.y);
        } else if (this.y > n.y) {
            this.drawArrow(g, this.x, this.rectangle.y, n.x, n.rectangle.y + n.rectangle.height);
        } else if (this.y <= n.y) {
            this.drawArrow(g, this.x, this.rectangle.y + this.rectangle.height, n.x, n.rectangle.y);
        }
    }

    public void drawArrow(Graphics g, double x1, double y1, double x2, double y2) {
        g.drawLine((int)x1, (int)y1, (int)x2, (int)y2);
        g.fillOval((int)x2, (int)y2, 6, 6);
    }

    public boolean contains(Point p) {
        if (this.rectangle != null) {
            return this.rectangle.contains(p);
        }
        return false;
    }

    public Vector createBranches(int relation, int[] direction) {
        Vector ents = this.entity.listOf(relation);
        Vector<Node> nodes = new Vector<Node>();
        int imax = ents.size();
        int i = 0;
        while (i < imax) {
            Entity e = (Entity)ents.get(i);
            boolean alreadyexists = false;
            int j = 0;
            while (j < nodes.size()) {
                Node n = (Node)nodes.get(j);
                if (n.entity.equals(e)) {
                    n.rconnections.add(this);
                    alreadyexists = true;
                }
                ++j;
            }
            if (!alreadyexists) {
                double nx = (double)direction[0] + (double)i / (double)imax * (double)direction[1];
                double ny = (double)direction[1] + (double)i / (double)imax * (double)direction[0];
                Node newnode = new Node(e, this.x + nx * (double)this.distscale, this.y + ny * (double)this.distscale);
                newnode.rconnections.add(this);
                nodes.add(newnode);
                newnode.setAxis(this.axisc + (relation == 4 ? -1 : (relation == 8 ? 1 : 0)), this.axish + (relation == 1 ? -1 : (relation == 2 ? 1 : 0)));
            }
            ++i;
        }
        this.connections.addAll(nodes);
        this.rconnections.addAll(nodes);
        return nodes;
    }

    void setAxis(int c, int h) {
        this.axisc = c;
        this.axish = h;
        int p = Math.abs(c) + Math.abs(h);
        int r = 42 * p;
        int g = c > 0 || h > 0 ? 42 * p : 0;
        int b = 42 * (6 - p);
        this.colbox = new Color(r, g, b);
    }
}

