/*
 * Decompiled with CFR 0.152.
 */
package medicine.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JList;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.basic.BasicListUI;

class SList
extends JList {
    int caret = -1;
    static int dw = 0;
    Color caretColor = this.getSelectionBackground();

    public String getToolTipText(MouseEvent e) {
        int ix = this.locationToIndex(e.getPoint());
        if (ix >= 0 && ix < this.getModel().getSize()) {
            Object o = this.getModel().getElementAt(ix);
            return o.toString();
        }
        return super.getToolTipText(e);
    }

    public void setSelectionBackground(Color c) {
        super.setSelectionBackground(c);
        this.caretColor = c != null ? new Color(c.getRed() / 2, c.getGreen() / 2, c.getBlue() / 2) : Color.gray;
    }

    public void setCaretIndex(int ci) {
        this.caret = ci;
        if (this.caret >= 0) {
            this.ensureIndexIsVisible(this.caret);
        }
        this.repaint();
    }

    public int getCaretIndex() {
        return this.caret;
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.caret < 0) {
            return;
        }
        Point p = this.indexToLocation(this.caret);
        if (p == null) {
            p = new Point();
        }
        if (this.caret == this.getModel().getSize()) {
            if (this.caret == 0) {
                p.y = 1;
            } else {
                p = this.indexToLocation(this.caret - 1);
                int h = (int)this.getCellRenderer().getListCellRendererComponent(this, this.getModel().getElementAt(this.caret - 1), this.caret - 1, false, false).getPreferredSize().getHeight();
                p.y += h;
            }
        }
        g.setColor(this.caretColor);
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(new BasicStroke(3.0f));
        g.drawLine(dw, p.y, this.getWidth() - dw, p.y);
    }

    public SList() {
        this.setUI(new SListUI());
    }

    class SListUI
    extends BasicListUI {
        SListUI() {
        }

        protected MouseInputListener createMouseInputListener() {
            return new MyMouseInputHandler();
        }

        public class MyMouseInputHandler
        extends BasicListUI.MouseInputHandler {
            public MyMouseInputHandler() {
                super(SListUI.this);
            }

            public void mouseDragged(MouseEvent e) {
            }
        }
    }
}

