/*
 * Decompiled with CFR 0.152.
 */
package medicine.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import medicine.Entity;
import medicine.EntitySearcher;
import medicine.MainApplication;

public class QuickAddDialog
extends JDialog
implements ActionListener {
    Entity entity;
    Entity startNode;
    JPanel jPanel1 = new JPanel();
    JButton jButton1 = new JButton();
    JButton jButton2 = new JButton();
    JPanel jPanel2 = new JPanel();
    JComboBox combo = new JComboBox();
    JTextField textfield;
    EntitySearcher es;
    boolean createdNewEntity = false;
    DefaultComboBoxModel model = new DefaultComboBoxModel();
    boolean clearList = false;
    String oldstring;

    public QuickAddDialog(Entity startNode) {
        this.startNode = startNode;
        this.init();
    }

    public QuickAddDialog() {
        this.init();
    }

    void init() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setModal(true);
        this.setSize(230, 300);
        Component c = this.combo.getEditor().getEditorComponent();
        if (c instanceof JTextField) {
            this.textfield = (JTextField)c;
        }
        MainApplication.centreWindow(this);
    }

    private void jbInit() throws Exception {
        this.jButton1.setText("Cancel");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                QuickAddDialog.this.jButton1_actionPerformed(e);
            }
        });
        this.jButton2.setText("OK");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                QuickAddDialog.this.jButton2_actionPerformed(e);
            }
        });
        this.combo.setPreferredSize(new Dimension(200, 21));
        this.combo.setEditable(true);
        this.combo.setModel(this.model);
        this.jPanel2.add((Component)this.combo, null);
        this.jPanel1.add((Component)this.jButton1, null);
        this.jPanel1.add((Component)this.jButton2, null);
        this.getContentPane().add((Component)this.jPanel2, "Center");
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.combo.getEditor().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                QuickAddDialog.this.editChange();
            }
        });
    }

    void jButton1_actionPerformed(ActionEvent e) {
        this.entity = null;
        this.exit();
    }

    void editChange() {
        this.keypressed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void keypressed() {
        String string = this.combo.getEditor().getItem().toString();
        if (string.equals(this.oldstring)) {
            this.OK();
            return;
        }
        this.oldstring = string;
        if (string.length() < 3) {
            return;
        }
        QuickAddDialog quickAddDialog = this;
        synchronized (quickAddDialog) {
            if (this.es != null) {
                this.es.stop();
            }
            this.clearList = true;
            this.es = new EntitySearcher(string, this.startNode, this);
            this.es.start();
        }
    }

    void emptyList() {
        this.model = new DefaultComboBoxModel();
        this.combo.setModel(this.model);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof Entity) {
            Object selection = this.combo.getEditor().getItem();
            if (this.clearList) {
                this.emptyList();
                this.clearList = false;
            }
            Entity f = (Entity)e.getSource();
            this.combo.hidePopup();
            this.model.addElement(f);
            this.combo.setMaximumRowCount(this.model.getSize());
            this.combo.showPopup();
            this.combo.getEditor().setItem(selection);
        }
    }

    void jButton2_actionPerformed(ActionEvent e) {
        this.OK();
    }

    void OK() {
        Object o = this.combo.getSelectedItem();
        Entity sel = null;
        if (o instanceof Entity) {
            sel = (Entity)o;
        }
        if (sel == null && o instanceof String) {
            String name = (String)o;
            int i = 0;
            while (i < this.model.getSize()) {
                Entity test;
                Object ob = this.model.getElementAt(i);
                if (ob instanceof Entity && (test = (Entity)ob).equalsIgnoreCase(name)) {
                    sel = test;
                }
                ++i;
            }
        }
        if (sel == null) {
            String str = this.combo.getEditor().getItem().toString();
            if (JOptionPane.showConfirmDialog(this, "Create new entity '" + str + "' ?", "No entity selected", 0) == 0) {
                this.entity = new Entity(null, -1);
                this.entity.name = str;
                this.createdNewEntity = true;
                this.exit();
            } else {
                this.entity = null;
                this.exit();
            }
        } else {
            this.entity = sel;
            this.createdNewEntity = false;
            this.exit();
        }
    }

    void exit() {
        if (this.es != null) {
            this.es.stop();
        }
        this.hide();
    }
}

