/*
 * Decompiled with CFR 0.152.
 */
package medicine.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import medicine.Entities;
import medicine.Entity;
import medicine.TransferableEntity;
import medicine.gui.EntityChooser;
import medicine.gui.EntityPanel;
import medicine.gui.FindDialog;
import medicine.gui.QuickAddDialog;
import medicine.gui.SList;

public class NavigatorPanel
extends JPanel
implements ActionListener {
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel superpanel = new JPanel();
    JLabel jLabel1 = new JLabel();
    JScrollPane jScrollPane1 = new JScrollPane();
    JList superlist = new SList();
    BorderLayout borderLayout2 = new BorderLayout();
    JScrollPane jScrollPane2 = new JScrollPane();
    JPanel subpanel = new JPanel();
    BorderLayout borderLayout3 = new BorderLayout();
    JList sublist = new SList();
    JLabel jLabel2 = new JLabel();
    EntityPanel entitypanel = new EntityPanel();
    JPanel causepanel = new JPanel();
    JLabel jLabel3 = new JLabel();
    JScrollPane jScrollPane3 = new JScrollPane();
    JList causelist = new SList();
    BorderLayout borderLayout4 = new BorderLayout();
    JPanel effectspanel = new JPanel();
    JLabel jLabel4 = new JLabel();
    JScrollPane jScrollPane4 = new JScrollPane();
    JList effectlist = new SList();
    BorderLayout borderLayout5 = new BorderLayout();
    JMenu jMenu1 = new JMenu();
    JMenuItem jMenuItem9 = new JMenuItem();
    JMenuItem jMenuItem8 = new JMenuItem();
    JPopupMenu listEditPopup = new JPopupMenu();
    JMenuItem jMenuItem6 = new JMenuItem();
    JMenuItem jMenuItem10 = new JMenuItem();
    Entity entity;
    public boolean canMove = true;
    boolean canEdit = true;
    MouseListener dcl = new MouseAdapter(){

        public void mouseClicked(MouseEvent e) {
            JList list;
            Entity ent;
            Component c;
            if (NavigatorPanel.this.canMove && e.getClickCount() == 2 && ((c = (Component)e.getSource()) == NavigatorPanel.this.sublist || c == NavigatorPanel.this.superlist || c == NavigatorPanel.this.causelist || c == NavigatorPanel.this.effectlist) && (ent = (Entity)(list = (JList)c).getSelectedValue()) != null) {
                NavigatorPanel.this.setEntity(ent);
            }
        }
    };
    Action copyaction = new AbstractAction("Copy"){

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof JList) {
                JList l = (JList)e.getSource();
                Object[] o = l.getSelectedValues();
                if (o.length == 1) {
                    Entity f = (Entity)l.getSelectedValue();
                    if (f != null) {
                        NavigatorPanel.this.setClipboard(f);
                    }
                } else if (o.length > 1) {
                    NavigatorPanel.this.setClipboard(Arrays.asList(o));
                }
            }
        }
    };
    Action pasteaction = new AbstractAction("Paste"){

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof JList) {
                JList l = (JList)e.getSource();
                int rel = NavigatorPanel.this.relationFromList(l);
                Object o = NavigatorPanel.this.getClipboard();
                if (o instanceof Entity) {
                    NavigatorPanel.this.entity.connect((Entity)o, rel);
                } else if (o instanceof List) {
                    Iterator i = ((List)o).iterator();
                    while (i.hasNext()) {
                        NavigatorPanel.this.entity.connect((Entity)i.next(), rel);
                    }
                }
                NavigatorPanel.this.redisplay();
            }
        }
    };
    Object tmp = null;
    JList popupSource = null;
    MouseListener mcl = new MouseAdapter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseReleased(MouseEvent e) {
            if (NavigatorPanel.this.canEdit && e.getModifiers() == 4) {
                NavigatorPanel.this.listEditPopup.show((Component)e.getSource(), e.getX(), e.getY());
                NavigatorPanel.this.popupSource = (JList)e.getSource();
            }
            if (NavigatorPanel.this.moving != null) {
                if (NavigatorPanel.this.currentdroplist != null) {
                    Vector from = NavigatorPanel.this.entity.listOf(NavigatorPanel.this.relationFromList(NavigatorPanel.this.currentdraglist));
                    Vector to = NavigatorPanel.this.entity.listOf(NavigatorPanel.this.relationFromList(NavigatorPanel.this.currentdroplist));
                    Entity entity = NavigatorPanel.this.moving;
                    synchronized (entity) {
                        int ifrom = from.indexOf(NavigatorPanel.this.moving);
                        int dest = NavigatorPanel.this.currentdroplist.getCaretIndex();
                        if (to == from && ifrom < dest) {
                            --dest;
                        }
                        if (from != to) {
                            if (Entities.numConnections(NavigatorPanel.this.entity) > 1) {
                                NavigatorPanel.this.entity.disconnect(NavigatorPanel.this.moving, NavigatorPanel.this.relationFromList(NavigatorPanel.this.currentdraglist));
                            } else {
                                from.remove(NavigatorPanel.this.moving);
                                NavigatorPanel.this.moving.listOf(Entity.inverseOf(NavigatorPanel.this.relationFromList(NavigatorPanel.this.currentdraglist))).remove(NavigatorPanel.this.entity);
                            }
                            NavigatorPanel.this.entity.connect(NavigatorPanel.this.moving, NavigatorPanel.this.relationFromList(NavigatorPanel.this.currentdroplist));
                        }
                        to.remove(NavigatorPanel.this.moving);
                        to.insertElementAt(NavigatorPanel.this.moving, dest);
                        NavigatorPanel.this.moving = null;
                    }
                    NavigatorPanel.this.currentdroplist.setCaretIndex(-1);
                    NavigatorPanel.this.redisplay();
                } else {
                    NavigatorPanel.this.moving = null;
                }
            }
        }
    };
    Entity moving;
    SList currentdraglist;
    SList currentdroplist;
    MouseMotionListener mml = new MouseMotionAdapter(){

        public void mouseDragged(MouseEvent e) {
            if (NavigatorPanel.this.moving == null) {
                NavigatorPanel.this.currentdraglist = (SList)e.getSource();
            }
            NavigatorPanel.this.moving = (Entity)NavigatorPanel.this.currentdraglist.getSelectedValue();
            if (NavigatorPanel.this.moving != null) {
                int y;
                Point oo = ((Component)e.getSource()).getLocationOnScreen();
                Point no = NavigatorPanel.this.getLocationOnScreen();
                int x = e.getX() + oo.x - no.x;
                Component c = NavigatorPanel.this.findComponentAt(x, y = e.getY() + oo.y - no.y);
                if (c instanceof SList) {
                    int yy;
                    SList list = (SList)c;
                    Point mo = list.getLocationOnScreen();
                    int xx = e.getX() + oo.x - mo.x;
                    int ix = list.locationToIndex(new Point(xx, yy = e.getY() + oo.y - mo.y));
                    if (ix < 0) {
                        ix = list.getModel().getSize();
                    }
                    if (list.getCaretIndex() != ix || list != NavigatorPanel.this.currentdroplist) {
                        if (NavigatorPanel.this.currentdroplist != null) {
                            NavigatorPanel.this.currentdroplist.setCaretIndex(-1);
                        }
                        list.setCaretIndex(ix);
                        NavigatorPanel.this.currentdroplist = list;
                    }
                } else if (NavigatorPanel.this.currentdroplist != null) {
                    NavigatorPanel.this.currentdroplist.setCaretIndex(-1);
                    NavigatorPanel.this.currentdroplist = null;
                }
            }
        }
    };
    JMenuItem jMenuItem1 = new JMenuItem();

    public NavigatorPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JList[] lists = new JList[]{this.superlist, this.sublist, this.causelist, this.effectlist};
        int i = 0;
        while (i < lists.length) {
            lists[i].addMouseListener(this.dcl);
            lists[i].addMouseListener(this.mcl);
            lists[i].addMouseMotionListener(this.mml);
            lists[i].registerKeyboardAction(this, "Delete", KeyStroke.getKeyStroke(127, 0), 1);
            lists[i].getInputMap().put(KeyStroke.getKeyStroke(67, 2), this.copyaction);
            lists[i].getInputMap().put(KeyStroke.getKeyStroke(86, 2), this.pasteaction);
            lists[i].getActionMap().put(this.copyaction, this.copyaction);
            lists[i].getActionMap().put(this.pasteaction, this.pasteaction);
            ++i;
        }
        this.addComponentListener(new ComponentAdapter(){

            public synchronized void componentResized(ComponentEvent e) {
                NavigatorPanel.this.setPanelSizes();
            }
        });
        this.registerKeyboardAction(this, "Find", KeyStroke.getKeyStroke(70, 2), 1);
    }

    public void setEntity(Entity e) {
        this.entity = e;
        this.init();
    }

    public Entity getEntity() {
        return this.entity;
    }

    public void init() {
        if (this.entity != null) {
            this.superlist.setListData(this.entity.parents);
            this.sublist.setListData(this.entity.children);
            this.causelist.setListData(this.entity.causes);
            this.effectlist.setListData(this.entity.effects);
        } else {
            Vector nullv = new Vector();
            this.superlist.setListData(nullv);
            this.sublist.setListData(nullv);
            this.causelist.setListData(nullv);
            this.effectlist.setListData(nullv);
        }
        this.entitypanel.setEntity(this.entity);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.jLabel1.setFont(new Font("Dialog", 1, 12));
        this.jLabel1.setText("Superclasses");
        this.superpanel.setLayout(this.borderLayout2);
        this.subpanel.setLayout(this.borderLayout3);
        this.jLabel2.setFont(new Font("Dialog", 1, 12));
        this.jLabel2.setText("Subtypes");
        this.jLabel3.setFont(new Font("Dialog", 1, 12));
        this.jLabel3.setText("Causes");
        this.causepanel.setLayout(this.borderLayout4);
        this.jScrollPane3.setPreferredSize(new Dimension(100, 150));
        this.jLabel4.setFont(new Font("Dialog", 1, 12));
        this.jLabel4.setText("Effects");
        this.effectspanel.setLayout(this.borderLayout5);
        this.jScrollPane4.setPreferredSize(new Dimension(100, 150));
        this.jMenu1.setText("Add");
        this.jMenuItem9.setText("Delete");
        this.jMenuItem9.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NavigatorPanel.this.menuDelete(e);
            }
        });
        this.jMenuItem8.setText("New item");
        this.jMenuItem8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NavigatorPanel.this.addNewItem(e);
            }
        });
        this.jMenuItem6.setFont(new Font("Dialog", 1, 12));
        this.jMenuItem6.setText("Go to");
        this.jMenuItem6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NavigatorPanel.this.menuGoto(e);
            }
        });
        this.jMenuItem10.setText("Existing item");
        this.jMenuItem10.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NavigatorPanel.this.menuAddExist(e);
            }
        });
        this.causelist.setBackground(new Color(216, 225, 255));
        this.causelist.setToolTipText("List of causes");
        this.causelist.setSelectionBackground(Color.blue);
        this.effectlist.setBackground(new Color(255, 215, 225));
        this.effectlist.setToolTipText("List of consequences");
        this.effectlist.setSelectionBackground(Color.red);
        this.superlist.setToolTipText("List of superclasses");
        this.sublist.setToolTipText("List of subclasses");
        this.superpanel.setPreferredSize(new Dimension(337, 60));
        this.subpanel.setPreferredSize(new Dimension(311, 60));
        this.entitypanel.setEditable(true);
        this.jMenuItem1.setText("Quick add...");
        this.jMenuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NavigatorPanel.this.menuQuickAdd(e);
            }
        });
        this.add((Component)this.superpanel, "North");
        this.superpanel.add((Component)this.jLabel1, "West");
        this.superpanel.add((Component)this.jScrollPane1, "Center");
        this.add((Component)this.subpanel, "South");
        this.subpanel.add((Component)this.jLabel2, "West");
        this.subpanel.add((Component)this.jScrollPane2, "Center");
        this.add((Component)this.entitypanel, "Center");
        this.add((Component)this.causepanel, "West");
        this.causepanel.add((Component)this.jLabel3, "North");
        this.causepanel.add((Component)this.jScrollPane3, "Center");
        this.add((Component)this.effectspanel, "East");
        this.effectspanel.add((Component)this.jLabel4, "North");
        this.effectspanel.add((Component)this.jScrollPane4, "Center");
        this.jScrollPane4.getViewport().add((Component)this.effectlist, null);
        this.jScrollPane3.getViewport().add((Component)this.causelist, null);
        this.jScrollPane2.getViewport().add((Component)this.sublist, null);
        this.jScrollPane1.getViewport().add((Component)this.superlist, null);
        this.jMenu1.add(this.jMenuItem1);
        this.jMenu1.add(this.jMenuItem8);
        this.jMenu1.add(this.jMenuItem10);
        this.listEditPopup.add(this.jMenuItem6);
        this.listEditPopup.addSeparator();
        this.listEditPopup.add(this.jMenu1);
        this.listEditPopup.add(this.jMenuItem9);
    }

    public void setEditable(boolean t) {
        this.canEdit = t;
        this.entitypanel.setEditable(t);
    }

    public boolean isEditable() {
        return this.canEdit;
    }

    void find() {
        FindDialog fd = new FindDialog(this.entity);
        fd.setModal(true);
        fd.show();
        if (fd.entity != null) {
            this.setEntity(fd.entity);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        if (this.canMove && s.equals("Find")) {
            this.find();
        } else if (this.canEdit && s.equals("Delete") && e.getSource() instanceof JList) {
            JList list = (JList)e.getSource();
            this.deleteSelectedItem(list);
        }
    }

    public void setClipboard(Object o) {
        this.tmp = o;
        TransferableEntity.listener.actionPerformed(new ActionEvent(o, 0, "ClipboardChanged"));
    }

    public Object getClipboard() {
        return this.tmp;
    }

    public void setPanelSizes() {
        int w = this.getWidth();
        int h = this.getHeight();
        this.causepanel.setPreferredSize(new Dimension(w / 4, 100));
        this.effectspanel.setPreferredSize(new Dimension(w / 4, 100));
        this.subpanel.setPreferredSize(new Dimension(100, h / 4));
        this.superpanel.setPreferredSize(new Dimension(100, h / 4));
        this.invalidate();
        this.validateTree();
        this.repaint();
    }

    void menuGoto(ActionEvent e) {
        Entity ent = (Entity)this.popupSource.getSelectedValue();
        if (ent != null) {
            this.setEntity(ent);
        }
    }

    void addNewItem(ActionEvent e) {
        int conn = Entity.inverseOf(this.relationFromList(this.popupSource));
        Entity ne = new Entity(this.entity, conn);
        this.setEntity(ne);
        JTextField t = this.entitypanel.namepanel;
        t.requestFocus();
        t.setSelectionStart(0);
        t.setSelectionEnd(t.getText().length());
    }

    int relationFromList(JList list) {
        if (list == this.superlist) {
            return 1;
        }
        if (list == this.sublist) {
            return 2;
        }
        if (list == this.causelist) {
            return 4;
        }
        if (list == this.effectlist) {
            return 8;
        }
        return -1;
    }

    void menuDelete(ActionEvent e) {
        this.deleteSelectedItem(this.popupSource);
    }

    void deleteSelectedItem(JList list) {
        Object[] o = list.getSelectedValues();
        boolean changed = false;
        int i = 0;
        while (i < o.length) {
            Entity ent = (Entity)o[i];
            if (ent != null) {
                this.entity.disconnect(ent, this.relationFromList(list));
                changed = true;
            }
            ++i;
        }
        if (changed) {
            this.redisplay();
        }
    }

    void menuQuickAdd(ActionEvent e) {
        QuickAddDialog q = new QuickAddDialog(this.entity);
        q.show();
        if (q.entity != null) {
            this.entity.connect(q.entity, this.relationFromList(this.popupSource));
            if (q.createdNewEntity) {
                this.setEntity(q.entity);
            }
        }
        this.redisplay();
    }

    void menuAddExist(ActionEvent e) {
        EntityChooser ec = new EntityChooser();
        ec.setModal(true);
        ec.navigator.setEntity(this.entity);
        ec.show();
        if (ec.entity != null) {
            this.entity.connect(ec.entity, this.relationFromList(this.popupSource));
        }
        this.redisplay();
    }

    public void redisplay() {
        this.setEntity(this.entity);
    }

    public JList getFocusedList() {
        if (this.superlist.hasFocus()) {
            return this.superlist;
        }
        if (this.sublist.hasFocus()) {
            return this.sublist;
        }
        if (this.causelist.hasFocus()) {
            return this.causelist;
        }
        if (this.effectlist.hasFocus()) {
            return this.effectlist;
        }
        return null;
    }
}

