/*
 * Decompiled with CFR 0.152.
 */
package medicine.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.text.ParseException;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import medicine.Entities;
import medicine.Entity;
import medicine.gui.EntityChooserComboBox;
import medicine.gui.FindFilter_regexCheck_actionAdapter;

public class FindFilter
extends JPanel {
    Entity entity;
    protected static final String[] standardStrings = new String[]{"Disease", "Pathology", "Investigation", "Sign", "Symptom", "Substance", "Treatment", "Lifestyle"};
    protected Pattern regex = null;
    protected String matchLC = null;
    boolean isSelected = false;
    BorderLayout borderLayout1 = new BorderLayout();
    JTabbedPane tabbedPane = new JTabbedPane();
    JPanel jPanel1 = new JPanel();
    JRadioButton includeRadio = new JRadioButton();
    JRadioButton excludeRadio = new JRadioButton();
    JCheckBox orCheckbox = new JCheckBox();
    ButtonGroup bg1 = new ButtonGroup();
    JPanel textPane = new JPanel();
    JPanel isaPane = new JPanel();
    JPanel jPanel2 = new JPanel();
    JCheckBox synonymCheck = new JCheckBox();
    JCheckBox descriptionCheck = new JCheckBox();
    JCheckBox ignoreCaseCheck = new JCheckBox();
    JCheckBox matchingRulesCheck = new JCheckBox();
    JCheckBox exactCheck = new JCheckBox();
    FlowLayout flowLayout1 = new FlowLayout();
    JPanel jPanel3 = new JPanel();
    JPanel jPanel4 = new JPanel();
    JRadioButton causeRadio = new JRadioButton();
    JRadioButton effectRadio = new JRadioButton();
    JRadioButton parentRadio = new JRadioButton();
    JRadioButton childRadio = new JRadioButton();
    JPanel jPanel5 = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JLabel jLabel1 = new JLabel();
    GridLayout gridLayout3 = new GridLayout();
    JPanel jPanel6 = new JPanel();
    JRadioButton standarEntityRadio = new JRadioButton();
    FlowLayout flowLayout2 = new FlowLayout();
    JComboBox standardsCombo = new JComboBox();
    JRadioButton currentEntityRadio = new JRadioButton();
    JLabel currentEntity = new JLabel();
    JPanel jPanel8 = new JPanel();
    JRadioButton selectEntityRadio = new JRadioButton();
    FlowLayout flowLayout4 = new FlowLayout();
    EntityChooserComboBox entityChooserComboBox1 = new EntityChooserComboBox();
    JPanel jPanel9 = new JPanel();
    FlowLayout flowLayout5 = new FlowLayout();
    JCheckBox includeSuperCheck = new JCheckBox();
    JLabel label = new JLabel();
    JCheckBox regexCheck = new JCheckBox();
    ButtonGroup bg2 = new ButtonGroup();
    ButtonGroup bg3 = new ButtonGroup();
    DefaultComboBoxModel standardsModel = new DefaultComboBoxModel();
    BorderLayout borderLayout3 = new BorderLayout();
    FlowLayout flowLayout6 = new FlowLayout();
    Border border1;
    Border border2;
    Border border3;
    Border border4;
    JSpinner recursionSpin = new JSpinner();
    JLabel jLabel2 = new JLabel();
    SpinnerNumberModel recursionNumberModel = new SpinnerNumberModel(4, 1, 12, 1);
    BorderLayout borderLayout4 = new BorderLayout();
    JScrollPane jScrollPane1 = new JScrollPane();
    JTextPane searchText = new JTextPane();

    public FindFilter(Entity any) {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int i = 0;
        while (i < standardStrings.length) {
            this.standardsModel.addElement(Entities.getSpecificNamedEntity(standardStrings[i], any));
            ++i;
        }
        this.entity = any;
        this.currentEntity.setText(this.entity.name);
        this.entityChooserComboBox1.setEntity(this.entity);
    }

    public void filterEnitities(Vector list) {
    }

    public Vector getFilteredItems(Vector items) throws ParseException {
        if (this.regexCheck.isSelected()) {
            try {
                this.regex = Pattern.compile(this.searchText.getText());
            }
            catch (PatternSyntaxException e) {
                throw new ParseException(this.searchText.getText(), 0);
            }
        }
        if (this.ignoreCaseCheck.isSelected()) {
            this.matchLC = this.searchText.getText();
        }
        Vector<Entity> result = new Vector<Entity>();
        int i = 0;
        while (i < items.size()) {
            Entity e = (Entity)items.get(i);
            if (this.satisfiedBy(e)) {
                result.add(e);
            }
            ++i;
        }
        return result;
    }

    private boolean satisfiedBy(Entity e) {
        boolean satisfies = false;
        if (this.tabbedPane.getSelectedComponent() == this.textPane) {
            String s = this.searchText.getText();
            if (this.textMatch(s, e.name)) {
                return true;
            }
            if (this.synonymCheck.isSelected()) {
                int i = 0;
                while (i < e.synonyms.size()) {
                    if (this.textMatch(s, (String)e.synonyms.get(i))) {
                        satisfies = true;
                    }
                    ++i;
                }
            }
            if (this.descriptionCheck.isSelected() && this.textMatch(s, e.description)) {
                satisfies = true;
            }
            this.matchingRulesCheck.isSelected();
        } else {
            int rel = Entity.inverseOf(this.getSelectedRelation());
            Entity e2 = this.getSelectedEntity();
            int recursion = this.recursionNumberModel.getNumber().intValue();
            satisfies = Entities.isRelativeOf(e, e2, rel, this.includeSuperCheck.isSelected(), false, recursion);
        }
        return this.includeRadio.isSelected() ? satisfies : !satisfies;
    }

    int getSelectedRelation() {
        if (this.parentRadio.isSelected()) {
            return 1;
        }
        if (this.childRadio.isSelected()) {
            return 2;
        }
        if (this.causeRadio.isSelected()) {
            return 4;
        }
        if (this.effectRadio.isSelected()) {
            return 8;
        }
        throw new IllegalStateException("No relation selected");
    }

    Entity getSelectedEntity() {
        if (this.currentEntityRadio.isSelected()) {
            return this.entity;
        }
        if (this.selectEntityRadio.isSelected()) {
            return this.entityChooserComboBox1.getSelectedValue();
        }
        if (this.standarEntityRadio.isSelected()) {
            return (Entity)this.standardsCombo.getSelectedItem();
        }
        throw new IllegalStateException("No selected entity");
    }

    boolean textMatch(String pattern, String str) {
        if (this.regexCheck.isSelected()) {
            return this.regex.matcher(str).matches();
        }
        if (this.ignoreCaseCheck.isSelected()) {
            if (this.exactCheck.isSelected()) {
                return pattern.equalsIgnoreCase(str);
            }
            return str.toLowerCase().indexOf(this.matchLC) >= 0;
        }
        if (this.exactCheck.isSelected()) {
            return pattern.equals(str);
        }
        return str.indexOf(pattern) >= 0;
    }

    public boolean isOrFilter() {
        return this.orCheckbox.isSelected();
    }

    public void setSelected(boolean b) {
        this.isSelected = b;
        this.label.setBackground(b ? Color.red : Color.lightGray);
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createEmptyBorder();
        this.border2 = BorderFactory.createEmptyBorder();
        this.border3 = BorderFactory.createEmptyBorder();
        this.border4 = BorderFactory.createEmptyBorder();
        this.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.setLayout(this.borderLayout1);
        this.includeRadio.setPreferredSize(new Dimension(91, 23));
        this.includeRadio.setSelected(true);
        this.includeRadio.setText("Include");
        this.excludeRadio.setText("Exclude");
        this.orCheckbox.setText("Or");
        this.textPane.setLayout(this.borderLayout4);
        this.synonymCheck.setSelected(true);
        this.synonymCheck.setText("Include synonyms");
        this.descriptionCheck.setSelected(true);
        this.descriptionCheck.setText("Include description");
        this.ignoreCaseCheck.setSelected(true);
        this.ignoreCaseCheck.setText("Ignore case");
        this.matchingRulesCheck.setSelected(true);
        this.matchingRulesCheck.setText("US matching rules");
        this.exactCheck.setText("Exact text");
        this.jPanel2.setLayout(this.flowLayout1);
        this.flowLayout1.setAlignment(0);
        this.isaPane.setLayout(this.borderLayout3);
        this.causeRadio.setText("Cause");
        this.effectRadio.setSelected(false);
        this.effectRadio.setText("Effect");
        this.parentRadio.setText("Superclass");
        this.childRadio.setSelected(true);
        this.childRadio.setText("Subtype");
        this.jPanel4.setLayout(this.borderLayout2);
        this.jLabel1.setText("  of   ");
        this.jPanel5.setLayout(this.gridLayout3);
        this.gridLayout3.setColumns(1);
        this.gridLayout3.setRows(3);
        this.standarEntityRadio.setSelected(true);
        this.standarEntityRadio.setText("");
        this.jPanel6.setLayout(this.flowLayout2);
        this.flowLayout2.setAlignment(0);
        this.currentEntity.setText("None");
        this.selectEntityRadio.setText("Select:");
        this.jPanel8.setLayout(this.flowLayout4);
        this.flowLayout4.setAlignment(0);
        this.jPanel9.setLayout(this.flowLayout5);
        this.flowLayout5.setAlignment(0);
        this.includeSuperCheck.setText("Search superclasses");
        this.jPanel1.setOpaque(false);
        this.label.setOpaque(true);
        this.label.setText("Filter");
        this.regexCheck.setText("Regular expression");
        this.regexCheck.addActionListener(new FindFilter_regexCheck_actionAdapter(this));
        this.jPanel3.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel3.setPreferredSize(new Dimension(150, 33));
        this.jPanel3.setLayout(this.flowLayout6);
        this.flowLayout6.setAlignment(0);
        this.jPanel6.setBorder(this.border1);
        this.jPanel8.setBorder(this.border1);
        this.jPanel9.setBorder(this.border1);
        this.entityChooserComboBox1.setMaximumRowCount(20);
        this.jLabel2.setText("recursions");
        this.recursionSpin.setModel(this.recursionNumberModel);
        this.recursionSpin.setEnabled(true);
        this.recursionSpin.setPreferredSize(new Dimension(40, 18));
        this.searchText.setFont(new Font("DialogInput", 0, 11));
        this.searchText.setVerifyInputWhenFocusTarget(true);
        this.searchText.setText("");
        this.currentEntityRadio.setText("");
        this.jPanel5.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel2.add((Component)this.descriptionCheck, null);
        this.add((Component)this.tabbedPane, "Center");
        this.tabbedPane.add((Component)this.textPane, "Text");
        this.textPane.add((Component)this.jPanel2, "Center");
        this.jPanel2.add((Component)this.synonymCheck, null);
        this.jPanel2.add((Component)this.regexCheck, null);
        this.jPanel2.add((Component)this.ignoreCaseCheck, null);
        this.jPanel2.add((Component)this.matchingRulesCheck, null);
        this.jPanel2.add((Component)this.exactCheck, null);
        this.textPane.add((Component)this.jScrollPane1, "North");
        this.jScrollPane1.getViewport().add((Component)this.searchText, null);
        this.tabbedPane.add((Component)this.isaPane, "Is a");
        this.isaPane.add((Component)this.jPanel3, "West");
        this.jPanel3.add((Component)this.childRadio, null);
        this.jPanel3.add((Component)this.parentRadio, null);
        this.jPanel3.add((Component)this.causeRadio, null);
        this.jPanel3.add((Component)this.effectRadio, null);
        this.isaPane.add((Component)this.jPanel4, "Center");
        this.add((Component)this.jPanel1, "North");
        this.jPanel1.add((Component)this.label, null);
        this.jPanel1.add((Component)this.orCheckbox, null);
        this.jPanel1.add((Component)this.includeRadio, null);
        this.jPanel1.add((Component)this.excludeRadio, null);
        this.bg1.add(this.includeRadio);
        this.bg1.add(this.excludeRadio);
        this.bg2.add(this.causeRadio);
        this.bg2.add(this.effectRadio);
        this.bg2.add(this.childRadio);
        this.bg2.add(this.parentRadio);
        this.bg3.add(this.standarEntityRadio);
        this.bg3.add(this.currentEntityRadio);
        this.bg3.add(this.selectEntityRadio);
        this.jPanel4.add((Component)this.jPanel5, "Center");
        this.jPanel5.add((Component)this.jPanel6, null);
        this.jPanel6.add((Component)this.standarEntityRadio, null);
        this.jPanel4.add((Component)this.jLabel1, "West");
        this.jPanel6.add((Component)this.standardsCombo, null);
        this.jPanel6.add((Component)this.currentEntityRadio, null);
        this.jPanel6.add((Component)this.currentEntity, null);
        this.jPanel5.add((Component)this.jPanel8, null);
        this.jPanel8.add((Component)this.selectEntityRadio, null);
        this.jPanel8.add((Component)this.entityChooserComboBox1, null);
        this.jPanel5.add((Component)this.jPanel9, null);
        this.jPanel9.add((Component)this.includeSuperCheck, null);
        this.jPanel9.add((Component)this.recursionSpin, null);
        this.jPanel9.add((Component)this.jLabel2, null);
        this.standardsCombo.setModel(this.standardsModel);
    }

    void regexCheck_actionPerformed(ActionEvent e) {
        boolean b = !this.regexCheck.isSelected();
        this.matchingRulesCheck.setEnabled(b);
        this.exactCheck.setEnabled(b);
        this.ignoreCaseCheck.setEnabled(b);
    }
}

