/*
 * Decompiled with CFR 0.152.
 */
package medicine.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.text.html.HTMLEditorKit;
import medicine.Entity;
import medicine.EntitySearcher;
import medicine.gui.NavigatorPanel;
import medicine.gui.SynonymInputDialog;

public class EntityPanel
extends JPanel {
    BorderLayout borderLayout1 = new BorderLayout();
    Entity entity;
    Border border1;
    JTabbedPane jTabbedPane1 = new JTabbedPane();
    JScrollPane jScrollPane1 = new JScrollPane();
    JEditorPane descriptiontxt = new JEditorPane();
    HTMLEditorKit hTMLEditorKit1 = new HTMLEditorKit();
    JScrollPane synonympanel = new JScrollPane();
    JList synonymlist = new JList();
    JTextField namepanel = new JTextField();
    JPopupMenu popupmenu = new JPopupMenu();
    JMenuItem jMenuItem1 = new JMenuItem();
    JMenuItem removesynon = new JMenuItem();
    JComponent thisComp = this;
    int nreplaces;
    String lastTestedName = "";
    boolean isEditable;

    public EntityPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setEntity(Entity e) {
        this.entity = e;
        this.init();
    }

    public Entity getEntity() {
        return this.entity;
    }

    public void init() {
        if (this.entity != null) {
            this.namepanel.setText(this.entity.name);
            this.synonymlist.setListData(this.entity.synonyms);
            this.descriptiontxt.setText(this.entity.description);
        } else {
            this.namepanel.setText("");
            this.synonymlist.setListData(new Vector());
            this.descriptiontxt.setText("");
        }
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(new Color(248, 240, 255), new Color(121, 117, 151)), BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.setLayout(this.borderLayout1);
        this.setBorder(this.border1);
        this.descriptiontxt.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                EntityPanel.this.descriptionChanged(e);
            }
        });
        this.namepanel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EntityPanel.this.nameChanged();
            }
        });
        this.jMenuItem1.setText("Add...");
        this.jMenuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EntityPanel.this.addsynonym(e);
            }
        });
        this.removesynon.setText("Remove");
        this.removesynon.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EntityPanel.this.removesynonym(e);
            }
        });
        this.synonymlist.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                EntityPanel.this.synonymlist_mouseReleased(e);
            }
        });
        this.namepanel.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                EntityPanel.this.nameChanged();
            }
        });
        this.namepanel.setFont(new Font("SansSerif", 1, 12));
        this.namepanel.setToolTipText("Name of entity");
        this.add((Component)this.jTabbedPane1, "Center");
        this.jTabbedPane1.add((Component)this.jScrollPane1, "Description");
        this.jTabbedPane1.add((Component)this.synonympanel, "Synonyms");
        this.add((Component)this.namepanel, "North");
        this.synonympanel.getViewport().add((Component)this.synonymlist, null);
        this.jScrollPane1.getViewport().add((Component)this.descriptiontxt, null);
        this.popupmenu.add(this.jMenuItem1);
        this.popupmenu.add(this.removesynon);
    }

    void namepanel_inputMethodTextChanged(InputMethodEvent e) {
        if (this.entity != null) {
            this.entity.name = this.namepanel.getText();
        }
    }

    void addsynonym(ActionEvent e) {
        SynonymInputDialog sid = new SynonymInputDialog(this.entity);
        sid.setModal(true);
        sid.show();
        if (sid.synonym != null && sid.synonym != "") {
            this.entity.synonyms.add(sid.synonym);
            this.redisplay();
        }
    }

    void removesynonym(ActionEvent e) {
        Object o = this.synonymlist.getSelectedValue();
        this.entity.synonyms.remove(o);
        this.redisplay();
    }

    void redisplay() {
        this.setEntity(this.entity);
    }

    void synonymlist_mouseReleased(MouseEvent e) {
        if (this.isEditable && e.getModifiers() == 4) {
            this.popupmenu.show(this.synonympanel, e.getX(), e.getY());
        }
    }

    void descriptionChanged(FocusEvent e) {
        if (this.entity != null) {
            this.entity.description = this.descriptiontxt.getText();
        }
    }

    void nameChanged() {
        if (this.entity == null) {
            return;
        }
        this.entity.name = this.namepanel.getText();
        if (this.lastTestedName.equals(this.entity.name)) {
            return;
        }
        this.lastTestedName = this.entity.name;
        EntitySearcher esearch = new EntitySearcher(this.entity.name, this.entity, new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == EntityPanel.this.entity) {
                    return;
                }
                if (e.getSource() instanceof EntitySearcher && e.getActionCommand() == null) {
                    return;
                }
                JComponent jComponent = EntityPanel.this.thisComp;
                synchronized (jComponent) {
                    if (e.getSource() instanceof Entity && EntityPanel.this.nreplaces < 1) {
                        Entity duplicate = (Entity)e.getSource();
                        String dstr = String.valueOf(duplicate.name) + " (" + duplicate.description + ")";
                        if (EntityPanel.this.entity.isBlank()) {
                            int res = JOptionPane.showConfirmDialog(EntityPanel.this.thisComp, "An entity called " + dstr + " already exists. Would you like to replace the" + "current entity with it?", "Duplicate entity", 0);
                            if (res == 0) {
                                ++EntityPanel.this.nreplaces;
                                EntityPanel.this.entity.replaceAllWith(duplicate);
                                EntityPanel.this.setEntity(duplicate);
                                if (EntityPanel.this.getParent() instanceof NavigatorPanel) {
                                    ((NavigatorPanel)EntityPanel.this.getParent()).setEntity(EntityPanel.this.entity);
                                }
                            }
                        } else {
                            JOptionPane.showMessageDialog(EntityPanel.this.thisComp, "Warning: an entity called " + dstr + " already exists.", "Duplicate entity name", 2);
                        }
                    }
                }
            }
        });
        this.nreplaces = 0;
        esearch.exactMatch = true;
        esearch.start();
    }

    public void setEditable(boolean t) {
        this.isEditable = t;
        this.namepanel.setEditable(t);
        this.descriptiontxt.setEditable(t);
    }

    public boolean isEditable() {
        return this.isEditable;
    }
}

