/*
 * Decompiled with CFR 0.152.
 */
package medicine.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import medicine.TransferableEntity;
import medicine.TransferableEntityList;
import medicine.gui.NavButton;
import medicine.gui.NavigatorPanel;
import medicine.gui.SynonymInputDialog;

public class EntityEditorPanel
extends JPanel
implements ActionListener {
    public NavigatorPanel navigator = new NavigatorPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    JPanel clippanel = new JPanel();
    JLabel cliplabel = new JLabel();
    JPanel bookmarkpanel = new JPanel();
    Border border1;
    TitledBorder titledBorder1;
    Border border2;
    TitledBorder titledBorder2;

    public EntityEditorPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JList[] lists = new JList[]{this.navigator.sublist, this.navigator.superlist, this.navigator.causelist, this.navigator.effectlist};
        this.registerKeyboardAction(this, "Bookmark", KeyStroke.getKeyStroke(66, 2), 1);
        TransferableEntity.listener = this;
        TransferableEntityList.listener = this;
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createEtchedBorder(new Color(248, 240, 255), new Color(121, 117, 151));
        this.titledBorder1 = new TitledBorder(this.border1, "Bookmarks");
        this.border2 = BorderFactory.createEtchedBorder(new Color(248, 240, 255), new Color(121, 117, 151));
        this.titledBorder2 = new TitledBorder(this.border2, "Clipboard");
        this.setLayout(this.borderLayout1);
        this.clippanel.setMinimumSize(new Dimension(80, 55));
        this.cliplabel.setToolTipText("Clipboard");
        this.cliplabel.setText("Nothing copied");
        this.bookmarkpanel.setMinimumSize(new Dimension(80, 38));
        this.add((Component)this.navigator, "Center");
        this.add((Component)this.jPanel1, "North");
        this.jPanel1.add((Component)this.bookmarkpanel, null);
        this.jPanel1.add((Component)this.clippanel, null);
        this.clippanel.add((Component)this.cliplabel, null);
        this.cliplabel.setIcon(new ImageIcon("openFile.gif"));
    }

    public void inputSynonym() {
        SynonymInputDialog sid = new SynonymInputDialog(this.navigator.entity);
        sid.setModal(true);
        sid.show();
        if (sid.synonym != "") {
            this.navigator.entity.synonyms.add(sid.synonym);
            this.navigator.setEntity(this.navigator.entity);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        if (s.equals("ClipboardChanged")) {
            this.cliplabel.setText(e.getSource().toString());
            return;
        }
        Component c = (Component)e.getSource();
        if (c instanceof JList) {
            JList jList = (JList)c;
        }
        if (s.equals("Bookmark")) {
            this.bookmarkpanel.add(new NavButton(this.navigator.entity, this.navigator));
            this.validateTree();
        }
    }
}

