/*
 * Decompiled with CFR 0.152.
 */
package medicine.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import medicine.Entity;
import medicine.EntitySearcher;

public class EntityChooserComboBox
extends JComboBox
implements ActionListener {
    protected Entity startNode = null;
    protected EntitySearcher es;
    protected DefaultComboBoxModel model = new DefaultComboBoxModel();
    protected boolean clearList = false;
    protected String oldstring;
    protected Entity entity;
    protected boolean allowCreateNewEntity = true;
    protected boolean createdNewEntity = false;

    public EntityChooserComboBox() {
        this.setEditable(true);
        this.setModel(this.model);
        this.getEditor().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EntityChooserComboBox.this.editChange();
            }
        });
    }

    public void setEntity(Entity e) {
        this.startNode = e;
    }

    void editChange() {
        this.keypressed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void keypressed() {
        String string = this.getEditor().getItem().toString();
        if (string.equals(this.oldstring)) {
            return;
        }
        this.oldstring = string;
        if (string.length() < 3) {
            return;
        }
        if (this.startNode == null) {
            throw new IllegalStateException("Initial node not set");
        }
        EntityChooserComboBox entityChooserComboBox = this;
        synchronized (entityChooserComboBox) {
            if (this.es != null) {
                this.es.stop();
            }
            this.clearList = true;
            this.es = new EntitySearcher(string, this.startNode, this);
            this.es.start();
        }
    }

    void emptyList() {
        this.model = new DefaultComboBoxModel();
        this.setModel(this.model);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof Entity) {
            Object selection = this.getEditor().getItem();
            if (this.clearList) {
                this.emptyList();
                this.clearList = false;
            }
            Entity f = (Entity)e.getSource();
            this.hidePopup();
            this.model.addElement(f);
            this.setMaximumRowCount(this.model.getSize());
            this.showPopup();
            this.getEditor().setItem(selection);
        }
    }

    public boolean allowCreateNewEntity() {
        return this.allowCreateNewEntity;
    }

    public boolean hasCreatedNewEntity() {
        return this.createdNewEntity;
    }

    public Entity getSelectedValue() {
        Object o = this.getSelectedItem();
        Entity sel = null;
        if (o instanceof Entity) {
            sel = (Entity)o;
        }
        if (sel == null && o instanceof String) {
            String name = (String)o;
            int i = 0;
            while (i < this.model.getSize()) {
                Entity test;
                Object ob = this.model.getElementAt(i);
                if (ob instanceof Entity && (test = (Entity)ob).equalsIgnoreCase(name)) {
                    sel = test;
                }
                ++i;
            }
        }
        if (sel == null) {
            String str = this.getEditor().getItem().toString();
            if (this.allowCreateNewEntity && JOptionPane.showConfirmDialog(this, "Create new entity '" + str + "' ?", "No entity selected", 0) == 0) {
                this.entity = new Entity(null, -1);
                this.entity.name = str;
                this.createdNewEntity = true;
                return this.entity;
            }
            this.entity = null;
            return this.entity;
        }
        this.entity = sel;
        this.createdNewEntity = false;
        return this.entity;
    }
}

