/*
 * Decompiled with CFR 0.152.
 */
package medicine.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import medicine.Diagnoser;
import medicine.Entity;
import medicine.MainApplication;
import medicine.gui.EntityChooser;
import medicine.gui.NavigatorPanel;

public class DiagnosisDialog
extends JDialog
implements ActionListener {
    private JPanel jPanel1 = new JPanel();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JSplitPane jSplitPane1 = new JSplitPane();
    private JPanel jPanel2 = new JPanel();
    private JPanel jPanel3 = new JPanel();
    private BorderLayout borderLayout2 = new BorderLayout();
    private JPanel jPanel4 = new JPanel();
    private JScrollPane jScrollPane1 = new JScrollPane();
    private JList obslist = new JList();
    private BorderLayout borderLayout3 = new BorderLayout();
    private Border border1;
    private JPanel jPanel5 = new JPanel();
    private JButton addButton = new JButton();
    private JButton removeButton = new JButton();
    private JLabel jLabel1 = new JLabel();
    private DefaultListModel obslistmodel = new DefaultListModel();
    private BorderLayout borderLayout4 = new BorderLayout();
    private JPanel jPanel6 = new JPanel();
    private BorderLayout borderLayout5 = new BorderLayout();
    private JPanel jPanel7 = new JPanel();
    private JButton jButton1 = new JButton();
    private Border border2;
    private JScrollPane jScrollPane2 = new JScrollPane();
    private JList diaglist = new JList();
    private JLabel jLabel2 = new JLabel();
    private Border border3;
    private JPanel jPanel8 = new JPanel();
    private JButton diagButton = new JButton();
    Entity entity;
    NavigatorPanel navigator;
    private DefaultListModel diaglistmodel = new DefaultListModel();
    Diagnoser diagnoser;
    private JButton gotoButton = new JButton();
    JSlider jSlider1 = new JSlider();
    JLabel jLabel3 = new JLabel();

    public DiagnosisDialog(NavigatorPanel nav) {
        this.entity = nav.entity;
        this.navigator = nav;
        this.init();
    }

    void init() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setSize(400, 300);
        MainApplication.centreWindow(this);
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.border2 = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.border3 = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.jPanel1.setLayout(this.borderLayout1);
        this.jPanel2.setLayout(this.borderLayout2);
        this.jPanel4.setLayout(this.borderLayout3);
        this.jPanel4.setBorder(this.border1);
        this.addButton.setText("Add");
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DiagnosisDialog.this.addButton_actionPerformed(e);
            }
        });
        this.removeButton.setText("Remove");
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DiagnosisDialog.this.removeButton_actionPerformed(e);
            }
        });
        this.jLabel1.setText("Signs and Symptoms");
        this.jPanel3.setLayout(this.borderLayout4);
        this.jPanel6.setLayout(this.borderLayout5);
        this.jButton1.setText("OK");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DiagnosisDialog.this.jButton1_actionPerformed(e);
            }
        });
        this.setTitle("Diagnosis");
        this.jLabel2.setText("Differential");
        this.jPanel3.setBorder(this.border3);
        this.diagButton.setText("Diagnose");
        this.diagButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DiagnosisDialog.this.diagButton_actionPerformed(e);
            }
        });
        this.obslist.setModel(this.obslistmodel);
        this.diaglist.setModel(this.diaglistmodel);
        this.gotoButton.setText("Go to");
        this.gotoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DiagnosisDialog.this.gotoButton_actionPerformed(e);
            }
        });
        this.jSlider1.setMinimum(1);
        this.jSlider1.setBorder(BorderFactory.createEtchedBorder());
        this.jSlider1.setPreferredSize(new Dimension(100, 22));
        this.jLabel3.setText("Nearness");
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.jSplitPane1, "Center");
        this.jSplitPane1.add((Component)this.jPanel2, "left");
        this.jPanel2.add((Component)this.jPanel4, "Center");
        this.jPanel4.add((Component)this.jScrollPane1, "Center");
        this.jPanel4.add((Component)this.jPanel5, "South");
        this.jPanel5.add((Component)this.addButton, null);
        this.jPanel5.add((Component)this.removeButton, null);
        this.jScrollPane1.getViewport().add((Component)this.obslist, null);
        this.jSplitPane1.add((Component)this.jPanel3, "right");
        this.jPanel3.add((Component)this.jPanel6, "Center");
        this.jPanel6.add((Component)this.jScrollPane2, "Center");
        this.jPanel3.add((Component)this.jLabel2, "North");
        this.jPanel3.add((Component)this.jPanel8, "South");
        this.jPanel8.add((Component)this.diagButton, null);
        this.jPanel8.add((Component)this.gotoButton, null);
        this.jScrollPane2.getViewport().add((Component)this.diaglist, null);
        this.jPanel1.add((Component)this.jPanel7, "South");
        this.jPanel7.add((Component)this.jButton1, null);
        this.jPanel7.add((Component)this.jLabel3, null);
        this.jPanel7.add((Component)this.jSlider1, null);
        this.jPanel4.add((Component)this.jLabel1, "North");
        this.jSplitPane1.setDividerLocation(200);
    }

    void addButton_actionPerformed(ActionEvent e) {
        EntityChooser ec = new EntityChooser();
        ec.setModal(true);
        ec.navigator.setEntity(this.entity);
        ec.show();
        if (ec.OK) {
            Entity ne = ec.entity;
            this.obslistmodel.addElement(ne);
        }
    }

    void removeButton_actionPerformed(ActionEvent e) {
        Object[] re = this.obslist.getSelectedValues();
        int i = 0;
        while (i < re.length) {
            this.obslistmodel.removeElement(re[i]);
            ++i;
        }
    }

    void diagButton_actionPerformed(ActionEvent e) {
        this.doDiagnosis();
    }

    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (!(o instanceof Entity)) {
            this.diaglist.setCursor(Cursor.getDefaultCursor());
        }
        this.fillList(this.diaglistmodel, this.diagnoser.getDifferential());
    }

    void fillList(DefaultListModel lm, Vector v) {
        lm.removeAllElements();
        int i = 0;
        while (i < v.size()) {
            lm.addElement(v.get(i));
            ++i;
        }
    }

    void gotoButton_actionPerformed(ActionEvent e) {
        Object o = this.diaglist.getSelectedValue();
        if (o instanceof Entity) {
            this.navigator.setEntity((Entity)o);
        }
    }

    void jButton1_actionPerformed(ActionEvent e) {
        this.hide();
    }

    public JList getObsList() {
        return this.obslist;
    }

    public JList getDiagList() {
        return this.diaglist;
    }

    public void doDiagnosis() {
        Vector v = new Vector();
        int i = 0;
        while (i < this.obslistmodel.size()) {
            Object o = this.obslistmodel.getElementAt(i);
            if (o instanceof Entity) {
                v.addElement(o);
            }
            ++i;
        }
        this.diaglistmodel.removeAllElements();
        this.diagnoser = new Diagnoser(v, this);
        this.diagnoser.proximityPower = (double)this.jSlider1.getValue() / 100.0;
        this.diagnoser.start();
        this.diaglist.setCursor(Cursor.getPredefinedCursor(3));
    }
}

